/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.engines;

import cn.org.bjca.mssp.msspjce.crypto.BlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DataLengthException;
import cn.org.bjca.mssp.msspjce.crypto.OutputLengthException;
import cn.org.bjca.mssp.msspjce.crypto.params.KeyParameter;

public class SM4Engine
implements BlockCipher {
    public static final int ROUND = 32;
    private static final int BLOCK = 16;
    private byte[] Sbox;
    private int[] CK;
    int[] rk;

    public SM4Engine() {
        byte[] byArray = new byte[256];
        byArray[0] = -42;
        byArray[1] = -112;
        byArray[2] = -23;
        byArray[3] = -2;
        byArray[4] = -52;
        byArray[5] = -31;
        byArray[6] = 61;
        byArray[7] = -73;
        byArray[8] = 22;
        byArray[9] = -74;
        byArray[10] = 20;
        byArray[11] = -62;
        byArray[12] = 40;
        byArray[13] = -5;
        byArray[14] = 44;
        byArray[15] = 5;
        byArray[16] = 43;
        byArray[17] = 103;
        byArray[18] = -102;
        byArray[19] = 118;
        byArray[20] = 42;
        byArray[21] = -66;
        byArray[22] = 4;
        byArray[23] = -61;
        byArray[24] = -86;
        byArray[25] = 68;
        byArray[26] = 19;
        byArray[27] = 38;
        byArray[28] = 73;
        byArray[29] = -122;
        byArray[30] = 6;
        byArray[31] = -103;
        byArray[32] = -100;
        byArray[33] = 66;
        byArray[34] = 80;
        byArray[35] = -12;
        byArray[36] = -111;
        byArray[37] = -17;
        byArray[38] = -104;
        byArray[39] = 122;
        byArray[40] = 51;
        byArray[41] = 84;
        byArray[42] = 11;
        byArray[43] = 67;
        byArray[44] = -19;
        byArray[45] = -49;
        byArray[46] = -84;
        byArray[47] = 98;
        byArray[48] = -28;
        byArray[49] = -77;
        byArray[50] = 28;
        byArray[51] = -87;
        byArray[52] = -55;
        byArray[53] = 8;
        byArray[54] = -24;
        byArray[55] = -107;
        byArray[56] = -128;
        byArray[57] = -33;
        byArray[58] = -108;
        byArray[59] = -6;
        byArray[60] = 117;
        byArray[61] = -113;
        byArray[62] = 63;
        byArray[63] = -90;
        byArray[64] = 71;
        byArray[65] = 7;
        byArray[66] = -89;
        byArray[67] = -4;
        byArray[68] = -13;
        byArray[69] = 115;
        byArray[70] = 23;
        byArray[71] = -70;
        byArray[72] = -125;
        byArray[73] = 89;
        byArray[74] = 60;
        byArray[75] = 25;
        byArray[76] = -26;
        byArray[77] = -123;
        byArray[78] = 79;
        byArray[79] = -88;
        byArray[80] = 104;
        byArray[81] = 107;
        byArray[82] = -127;
        byArray[83] = -78;
        byArray[84] = 113;
        byArray[85] = 100;
        byArray[86] = -38;
        byArray[87] = -117;
        byArray[88] = -8;
        byArray[89] = -21;
        byArray[90] = 15;
        byArray[91] = 75;
        byArray[92] = 112;
        byArray[93] = 86;
        byArray[94] = -99;
        byArray[95] = 53;
        byArray[96] = 30;
        byArray[97] = 36;
        byArray[98] = 14;
        byArray[99] = 94;
        byArray[100] = 99;
        byArray[101] = 88;
        byArray[102] = -47;
        byArray[103] = -94;
        byArray[104] = 37;
        byArray[105] = 34;
        byArray[106] = 124;
        byArray[107] = 59;
        byArray[108] = 1;
        byArray[109] = 33;
        byArray[110] = 120;
        byArray[111] = -121;
        byArray[112] = -44;
        byArray[114] = 70;
        byArray[115] = 87;
        byArray[116] = -97;
        byArray[117] = -45;
        byArray[118] = 39;
        byArray[119] = 82;
        byArray[120] = 76;
        byArray[121] = 54;
        byArray[122] = 2;
        byArray[123] = -25;
        byArray[124] = -96;
        byArray[125] = -60;
        byArray[126] = -56;
        byArray[127] = -98;
        byArray[128] = -22;
        byArray[129] = -65;
        byArray[130] = -118;
        byArray[131] = -46;
        byArray[132] = 64;
        byArray[133] = -57;
        byArray[134] = 56;
        byArray[135] = -75;
        byArray[136] = -93;
        byArray[137] = -9;
        byArray[138] = -14;
        byArray[139] = -50;
        byArray[140] = -7;
        byArray[141] = 97;
        byArray[142] = 21;
        byArray[143] = -95;
        byArray[144] = -32;
        byArray[145] = -82;
        byArray[146] = 93;
        byArray[147] = -92;
        byArray[148] = -101;
        byArray[149] = 52;
        byArray[150] = 26;
        byArray[151] = 85;
        byArray[152] = -83;
        byArray[153] = -109;
        byArray[154] = 50;
        byArray[155] = 48;
        byArray[156] = -11;
        byArray[157] = -116;
        byArray[158] = -79;
        byArray[159] = -29;
        byArray[160] = 29;
        byArray[161] = -10;
        byArray[162] = -30;
        byArray[163] = 46;
        byArray[164] = -126;
        byArray[165] = 102;
        byArray[166] = -54;
        byArray[167] = 96;
        byArray[168] = -64;
        byArray[169] = 41;
        byArray[170] = 35;
        byArray[171] = -85;
        byArray[172] = 13;
        byArray[173] = 83;
        byArray[174] = 78;
        byArray[175] = 111;
        byArray[176] = -43;
        byArray[177] = -37;
        byArray[178] = 55;
        byArray[179] = 69;
        byArray[180] = -34;
        byArray[181] = -3;
        byArray[182] = -114;
        byArray[183] = 47;
        byArray[184] = 3;
        byArray[185] = -1;
        byArray[186] = 106;
        byArray[187] = 114;
        byArray[188] = 109;
        byArray[189] = 108;
        byArray[190] = 91;
        byArray[191] = 81;
        byArray[192] = -115;
        byArray[193] = 27;
        byArray[194] = -81;
        byArray[195] = -110;
        byArray[196] = -69;
        byArray[197] = -35;
        byArray[198] = -68;
        byArray[199] = 127;
        byArray[200] = 17;
        byArray[201] = -39;
        byArray[202] = 92;
        byArray[203] = 65;
        byArray[204] = 31;
        byArray[205] = 16;
        byArray[206] = 90;
        byArray[207] = -40;
        byArray[208] = 10;
        byArray[209] = -63;
        byArray[210] = 49;
        byArray[211] = -120;
        byArray[212] = -91;
        byArray[213] = -51;
        byArray[214] = 123;
        byArray[215] = -67;
        byArray[216] = 45;
        byArray[217] = 116;
        byArray[218] = -48;
        byArray[219] = 18;
        byArray[220] = -72;
        byArray[221] = -27;
        byArray[222] = -76;
        byArray[223] = -80;
        byArray[224] = -119;
        byArray[225] = 105;
        byArray[226] = -105;
        byArray[227] = 74;
        byArray[228] = 12;
        byArray[229] = -106;
        byArray[230] = 119;
        byArray[231] = 126;
        byArray[232] = 101;
        byArray[233] = -71;
        byArray[234] = -15;
        byArray[235] = 9;
        byArray[236] = -59;
        byArray[237] = 110;
        byArray[238] = -58;
        byArray[239] = -124;
        byArray[240] = 24;
        byArray[241] = -16;
        byArray[242] = 125;
        byArray[243] = -20;
        byArray[244] = 58;
        byArray[245] = -36;
        byArray[246] = 77;
        byArray[247] = 32;
        byArray[248] = 121;
        byArray[249] = -18;
        byArray[250] = 95;
        byArray[251] = 62;
        byArray[252] = -41;
        byArray[253] = -53;
        byArray[254] = 57;
        byArray[255] = 72;
        this.Sbox = byArray;
        this.CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
        this.rk = new int[32];
    }

    private int Rotl(int x, int y) {
        return x << y | x >>> 32 - y;
    }

    private int ByteSub(int A) {
        return (this.Sbox[A >>> 24 & 0xFF] & 0xFF) << 24 | (this.Sbox[A >>> 16 & 0xFF] & 0xFF) << 16 | (this.Sbox[A >>> 8 & 0xFF] & 0xFF) << 8 | this.Sbox[A & 0xFF] & 0xFF;
    }

    private int L1(int B) {
        return B ^ this.Rotl(B, 2) ^ this.Rotl(B, 10) ^ this.Rotl(B, 18) ^ this.Rotl(B, 24);
    }

    private int L2(int B) {
        return B ^ this.Rotl(B, 13) ^ this.Rotl(B, 23);
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        int mid;
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to sm4 init - " + params.getClass().getName());
        }
        byte[] Key2 = ((KeyParameter)params).getKey();
        int[] x = new int[4];
        int[] tmp = new int[4];
        int i = 0;
        while (i < 4) {
            tmp[0] = Key2[0 + 4 * i] & 0xFF;
            tmp[1] = Key2[1 + 4 * i] & 0xFF;
            tmp[2] = Key2[2 + 4 * i] & 0xFF;
            tmp[3] = Key2[3 + 4 * i] & 0xFF;
            x[i] = tmp[0] << 24 | tmp[1] << 16 | tmp[2] << 8 | tmp[3];
            ++i;
        }
        x[0] = x[0] ^ 0xA3B1BAC6;
        x[1] = x[1] ^ 0x56AA3350;
        x[2] = x[2] ^ 0x677D9197;
        x[3] = x[3] ^ 0xB27022DC;
        int r = 0;
        while (r < 32) {
            mid = x[1] ^ x[2] ^ x[3] ^ this.CK[r + 0];
            mid = this.ByteSub(mid);
            this.rk[r + 0] = x[0] = x[0] ^ this.L2(mid);
            mid = x[2] ^ x[3] ^ x[0] ^ this.CK[r + 1];
            mid = this.ByteSub(mid);
            this.rk[r + 1] = x[1] = x[1] ^ this.L2(mid);
            mid = x[3] ^ x[0] ^ x[1] ^ this.CK[r + 2];
            mid = this.ByteSub(mid);
            this.rk[r + 2] = x[2] = x[2] ^ this.L2(mid);
            mid = x[0] ^ x[1] ^ x[2] ^ this.CK[r + 3];
            mid = this.ByteSub(mid);
            this.rk[r + 3] = x[3] = x[3] ^ this.L2(mid);
            r += 4;
        }
        if (!forEncryption) {
            r = 0;
            while (r < 16) {
                mid = this.rk[r];
                this.rk[r] = this.rk[31 - r];
                this.rk[31 - r] = mid;
                ++r;
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SM4";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int[] x = new int[4];
        int[] tmp = new int[4];
        int i = 0;
        while (i < 4) {
            tmp[0] = in[inOff + 0 + 4 * i] & 0xFF;
            tmp[1] = in[inOff + 1 + 4 * i] & 0xFF;
            tmp[2] = in[inOff + 2 + 4 * i] & 0xFF;
            tmp[3] = in[inOff + 3 + 4 * i] & 0xFF;
            x[i] = tmp[0] << 24 | tmp[1] << 16 | tmp[2] << 8 | tmp[3];
            ++i;
        }
        int r = 0;
        while (r < 32) {
            int mid = x[1] ^ x[2] ^ x[3] ^ this.rk[r + 0];
            mid = this.ByteSub(mid);
            x[0] = x[0] ^ this.L1(mid);
            mid = x[2] ^ x[3] ^ x[0] ^ this.rk[r + 1];
            mid = this.ByteSub(mid);
            x[1] = x[1] ^ this.L1(mid);
            mid = x[3] ^ x[0] ^ x[1] ^ this.rk[r + 2];
            mid = this.ByteSub(mid);
            x[2] = x[2] ^ this.L1(mid);
            mid = x[0] ^ x[1] ^ x[2] ^ this.rk[r + 3];
            mid = this.ByteSub(mid);
            x[3] = x[3] ^ this.L1(mid);
            r += 4;
        }
        int j = 0;
        while (j < 16) {
            out[outOff + j] = (byte)(x[3 - j / 4] >>> 24 & 0xFF);
            out[outOff + j + 1] = (byte)(x[3 - j / 4] >>> 16 & 0xFF);
            out[outOff + j + 2] = (byte)(x[3 - j / 4] >>> 8 & 0xFF);
            out[outOff + j + 3] = (byte)(x[3 - j / 4] & 0xFF);
            j += 4;
        }
        return 16;
    }

    @Override
    public void reset() {
    }
}

