/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.generators;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.mssp.msspjce.crypto.KeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DSAKeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DSAParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DSAPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DSAPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dsaParams = this.param.getParameters();
        BigInteger x = DSAKeyPairGenerator.generatePrivateKey(dsaParams.getQ(), this.param.getRandom());
        BigInteger y = DSAKeyPairGenerator.calculatePublicKey(dsaParams.getP(), dsaParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }

    private static BigInteger generatePrivateKey(BigInteger q, SecureRandom random) {
        return BigIntegers.createRandomInRange(ONE, q.subtract(ONE), random);
    }

    private static BigInteger calculatePublicKey(BigInteger p, BigInteger g, BigInteger x) {
        return g.modPow(x, p);
    }
}

