/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.generators;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.mssp.msspjce.crypto.KeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECDomainParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.math.ec.ECConstants;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, this.random)).equals(ZERO) || d.compareTo(n) >= 0) {
        }
        ECPoint Q = this.params.getG().multiply(d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }
}

