/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.macs;

import cn.org.bjca.mssp.msspjce.crypto.BlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.Mac;
import cn.org.bjca.mssp.msspjce.crypto.modes.CBCBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.paddings.ISO7816d4Padding;
import cn.org.bjca.mssp.msspjce.crypto.params.KeyParameter;

public class CMac
implements Mac {
    private static final byte CONSTANT_128 = -121;
    private static final byte CONSTANT_64 = 27;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] L;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() * 8);
    }

    public CMac(BlockCipher cipher, int macSizeInBits) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (macSizeInBits > cipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + cipher.getBlockSize() * 8);
        }
        if (cipher.getBlockSize() != 8 && cipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Block size must be either 64 or 128 bits");
        }
        this.cipher = new CBCBlockCipher(cipher);
        this.macSize = macSizeInBits / 8;
        this.mac = new byte[cipher.getBlockSize()];
        this.buf = new byte[cipher.getBlockSize()];
        this.ZEROES = new byte[cipher.getBlockSize()];
        this.bufOff = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    private static int shiftLeft(byte[] block, byte[] output) {
        int i = block.length;
        int bit = 0;
        while (--i >= 0) {
            int b = block[i] & 0xFF;
            output[i] = (byte)(b << 1 | bit);
            bit = b >>> 7 & 1;
        }
        return bit;
    }

    private static byte[] doubleLu(byte[] in) {
        byte[] ret = new byte[in.length];
        int carry = CMac.shiftLeft(in, ret);
        int xor = 0xFF & (in.length == 16 ? -121 : 27);
        int n = in.length - 1;
        ret[n] = (byte)(ret[n] ^ xor >>> (1 - carry << 3));
        return ret;
    }

    @Override
    public void init(CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.cipher.init(true, params);
            this.L = new byte[this.ZEROES.length];
            this.cipher.processBlock(this.ZEROES, 0, this.L, 0);
            this.Lu = CMac.doubleLu(this.L);
            this.Lu2 = CMac.doubleLu(this.Lu);
        } else if (params != null) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
        this.reset();
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte in) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int blockSize = this.cipher.getBlockSize();
        int gapLen = blockSize - this.bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > blockSize) {
                this.cipher.processBlock(in, inOff, this.mac, 0);
                len -= blockSize;
                inOff += blockSize;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] lu;
        int blockSize = this.cipher.getBlockSize();
        if (this.bufOff == blockSize) {
            lu = this.Lu;
        } else {
            new ISO7816d4Padding().addPadding(this.buf, this.bufOff);
            lu = this.Lu2;
        }
        int i = 0;
        while (i < this.mac.length) {
            int n = i;
            this.buf[n] = (byte)(this.buf[n] ^ lu[i]);
            ++i;
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, out, outOff, this.macSize);
        this.reset();
        return this.macSize;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = 0;
            ++i;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

