/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.paddings;

import cn.org.bjca.mssp.msspjce.crypto.InvalidCipherTextException;
import cn.org.bjca.mssp.msspjce.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length) {
            in[inOff] = code;
            ++inOff;
        }
        return code;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        if (count > in.length || count == 0) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        int i = 1;
        while (i <= count) {
            if (in[in.length - i] != count) {
                throw new InvalidCipherTextException("pad block corrupted");
            }
            ++i;
        }
        return count;
    }
}

