/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.params;

import cn.org.bjca.mssp.msspjce.crypto.DerivationParameters;
import cn.org.bjca.mssp.msspjce.util.Arrays;

public final class KDFCounterParameters
implements DerivationParameters {
    private final byte[] ki;
    private final byte[] fixedInputData;
    private final int r;

    public KDFCounterParameters(byte[] ki, byte[] fixedInputData, int r) {
        if (ki == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.ki = Arrays.clone(ki);
        this.fixedInputData = fixedInputData == null ? new byte[0] : Arrays.clone(fixedInputData);
        if (r != 8 && r != 16 && r != 24 && r != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        this.r = r;
    }

    public byte[] getKI() {
        return this.ki;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }

    public int getR() {
        return this.r;
    }
}

