/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.prng;

import cn.org.bjca.mssp.msspjce.crypto.prng.EntropySource;
import cn.org.bjca.mssp.msspjce.crypto.prng.EntropySourceProvider;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom random, boolean isPredictionResistant) {
        this._sr = random;
        this._predictionResistant = isPredictionResistant;
    }

    @Override
    public EntropySource get(final int bitsRequired) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                return BasicEntropySourceProvider.this._sr.generateSeed((bitsRequired + 7) / 8);
            }

            @Override
            public int entropySize() {
                return bitsRequired;
            }
        };
    }
}

