/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.signers;

import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DSA;
import cn.org.bjca.mssp.msspjce.crypto.params.ECDomainParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.math.ec.ECAlgorithms;
import cn.org.bjca.mssp.msspjce.math.ec.ECCurve;
import cn.org.bjca.mssp.msspjce.math.ec.ECFieldElement;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                param = rParam.getParameters();
            } else {
                this.random = new SecureRandom();
            }
            this.key = (ECPrivateKeyParameters)param;
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        ECFieldElement y;
        BigInteger r;
        BigInteger e;
        ECFieldElement Fe;
        ECDomainParameters parameters = this.key.getParameters();
        ECCurve curve = parameters.getCurve();
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h.isZero()) {
            h = curve.fromBigInteger(ONE);
        }
        BigInteger n = parameters.getN();
        do {
            e = DSTU4145Signer.generateRandomInteger(n, this.random);
        } while ((Fe = parameters.getG().multiply(e).normalize().getAffineXCoord()).isZero() || (r = DSTU4145Signer.fieldElement2Integer(n, y = h.multiply(Fe))).signum() == 0 || (s = r.multiply(((ECPrivateKeyParameters)this.key).getD()).add(e).mod(n)).signum() == 0);
        return new BigInteger[]{r, s};
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint R;
        if (r.signum() <= 0 || s.signum() <= 0) {
            return false;
        }
        ECDomainParameters parameters = this.key.getParameters();
        BigInteger n = parameters.getN();
        if (r.compareTo(n) >= 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ECCurve curve = parameters.getCurve();
        ECFieldElement h = DSTU4145Signer.hash2FieldElement(curve, message);
        if (h.isZero()) {
            h = curve.fromBigInteger(ONE);
        }
        if ((R = ECAlgorithms.sumOfTwoMultiplies(parameters.getG(), s, ((ECPublicKeyParameters)this.key).getQ(), r).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement y = h.multiply(R.getAffineXCoord());
        return DSTU4145Signer.fieldElement2Integer(n, y).compareTo(r) == 0;
    }

    private static BigInteger generateRandomInteger(BigInteger n, SecureRandom random) {
        return new BigInteger(n.bitLength() - 1, random);
    }

    private static void reverseBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length / 2) {
            byte tmp = bytes[i];
            bytes[i] = bytes[bytes.length - 1 - i];
            bytes[bytes.length - 1 - i] = tmp;
            ++i;
        }
    }

    private static ECFieldElement hash2FieldElement(ECCurve curve, byte[] hash) {
        byte[] data = Arrays.clone(hash);
        DSTU4145Signer.reverseBytes(data);
        BigInteger num = new BigInteger(1, data);
        while (num.bitLength() > curve.getFieldSize()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return curve.fromBigInteger(num);
    }

    private static BigInteger fieldElement2Integer(BigInteger n, ECFieldElement fieldElement) {
        BigInteger num = fieldElement.toBigInteger();
        while (num.bitLength() >= n.bitLength()) {
            num = num.clearBit(num.bitLength() - 1);
        }
        return num;
    }
}

