/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.signers;

import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DSA;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.crypto.signers.DSAKCalculator;
import cn.org.bjca.mssp.msspjce.crypto.signers.RandomDSAKCalculator;
import cn.org.bjca.mssp.msspjce.math.ec.ECAlgorithms;
import cn.org.bjca.mssp.msspjce.math.ec.ECConstants;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements ECConstants,
DSA {
    private final DSAKCalculator kCalculator;
    private ECKeyParameters key;
    private SecureRandom random;

    public ECDSASigner() {
        this.kCalculator = new RandomDSAKCalculator();
    }

    public ECDSASigner(DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d;
        BigInteger k;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger r = null;
        BigInteger s = null;
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(n, ((ECPrivateKeyParameters)this.key).getD(), message);
        } else {
            this.kCalculator.init(n, this.random);
        }
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            do {
                k = this.kCalculator.nextK();
            } while ((r = (x = (p = this.key.getParameters().getG().multiply(k).normalize()).getAffineXCoord().toBigInteger()).mod(n)).equals(ZERO));
            d = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s = k.modInverse(n).multiply(e.add(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, u1, Q = ((ECPublicKeyParameters)this.key).getQ(), u2).normalize();
        if (point.isInfinity()) {
            return false;
        }
        BigInteger v = point.getAffineXCoord().toBigInteger().mod(n);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }
}

