/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.signers;

import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DSA;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.math.ec.ECAlgorithms;
import cn.org.bjca.mssp.msspjce.math.ec.ECConstants;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECGOST3410Signer
implements DSA {
    ECKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger d;
        BigInteger k;
        byte[] mRev = new byte[message.length];
        int i = 0;
        while (i != mRev.length) {
            mRev[i] = message[mRev.length - 1 - i];
            ++i;
        }
        BigInteger e = new BigInteger(1, mRev);
        BigInteger n = this.key.getParameters().getN();
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            while ((k = new BigInteger(n.bitLength(), this.random)).equals(ECConstants.ZERO) || (r = (x = (p = this.key.getParameters().getG().multiply(k).normalize()).getAffineXCoord().toBigInteger()).mod(n)).equals(ECConstants.ZERO)) {
            }
            d = ((ECPrivateKeyParameters)this.key).getD();
        } while ((s = k.multiply(e).add(d.multiply(r)).mod(n)).equals(ECConstants.ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        byte[] mRev = new byte[message.length];
        int i = 0;
        while (i != mRev.length) {
            mRev[i] = message[mRev.length - 1 - i];
            ++i;
        }
        BigInteger e = new BigInteger(1, mRev);
        BigInteger n = this.key.getParameters().getN();
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger v = e.modInverse(n);
        BigInteger z1 = s.multiply(v).mod(n);
        BigInteger z2 = n.subtract(r).multiply(v).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q = ((ECPublicKeyParameters)this.key).getQ(), z2).normalize();
        if (point.isInfinity()) {
            return false;
        }
        BigInteger R = point.getAffineXCoord().toBigInteger().mod(n);
        return R.equals(r);
    }
}

