/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.signers;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DSA;
import cn.org.bjca.mssp.msspjce.crypto.DataLengthException;
import cn.org.bjca.mssp.msspjce.crypto.generators.ECKeyPairGenerator;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.math.ec.ECAlgorithms;
import cn.org.bjca.mssp.msspjce.math.ec.ECConstants;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECNRSigner
implements DSA {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] digest) {
        ECKeyPairGenerator keyGen;
        AsymmetricCipherKeyPair tempPair;
        ECPublicKeyParameters V;
        BigInteger Vx;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger n = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, digest);
        int eBitLength = e.bitLength();
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)this.key;
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger r = null;
        BigInteger s = null;
        do {
            keyGen = new ECKeyPairGenerator();
            keyGen.init(new ECKeyGenerationParameters(privKey.getParameters(), this.random));
        } while ((r = (Vx = (V = (ECPublicKeyParameters)(tempPair = keyGen.generateKeyPair()).getPublic()).getQ().normalize().getAffineXCoord().toBigInteger()).add(e).mod(n)).equals(ECConstants.ZERO));
        BigInteger x = privKey.getD();
        BigInteger u = ((ECPrivateKeyParameters)tempPair.getPrivate()).getD();
        s = u.subtract(r.multiply(x)).mod(n);
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] digest, BigInteger r, BigInteger s) {
        ECPoint W;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters pubKey = (ECPublicKeyParameters)this.key;
        BigInteger n = pubKey.getParameters().getN();
        int nBitLength = n.bitLength();
        BigInteger e = new BigInteger(1, digest);
        int eBitLength = e.bitLength();
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ZERO) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s, W = pubKey.getQ(), r).normalize();
        if (P.isInfinity()) {
            return false;
        }
        BigInteger x = P.getAffineXCoord().toBigInteger();
        BigInteger t = r.subtract(x).mod(n);
        return t.equals(e);
    }
}

