/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.signers;

import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.crypto.DSA;
import cn.org.bjca.mssp.msspjce.crypto.params.ECKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.crypto.signers.DSAKCalculator;
import cn.org.bjca.mssp.msspjce.crypto.signers.RandomDSAKCalculator;
import cn.org.bjca.mssp.msspjce.math.ec.ECConstants;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2Signer
implements ECConstants,
DSA {
    private final DSAKCalculator kCalculator;
    private ECKeyParameters key;
    private SecureRandom random;

    public SM2Signer() {
        this.kCalculator = new RandomDSAKCalculator();
    }

    public SM2Signer(DSAKCalculator kCalculator) {
        this.kCalculator = kCalculator;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k;
        BigInteger b23;
        BigInteger d;
        BigInteger b22;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        BigInteger r = null;
        BigInteger s = null;
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(n, ((ECPrivateKeyParameters)this.key).getD(), message);
        } else {
            this.kCalculator.init(n, this.random);
        }
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            do {
                k = this.kCalculator.nextK();
            } while ((r = (x = (p = this.key.getParameters().getG().multiply(k).normalize()).getAffineXCoord().toBigInteger()).add(e).mod(n)).equals(ZERO));
        } while ((s = (b22 = (d = ((ECPrivateKeyParameters)this.key).getD()).add(BigInteger.ONE).modInverse(n)).multiply(b23 = k.subtract(r.multiply(d))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint X2;
        BigInteger n = this.key.getParameters().getN();
        BigInteger e = this.calculateE(n, message);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint P = ((ECPublicKeyParameters)this.key).getQ();
        ECPoint X1 = G.multiply(s);
        ECPoint X = X1.add(X2 = P.multiply(t)).normalize();
        if (X.isInfinity()) {
            return false;
        }
        BigInteger x = X.getAffineXCoord().toBigInteger();
        BigInteger v = e.add(x).mod(n);
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }
}

