/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsPeer;
import cn.org.bjca.mssp.msspjce.crypto.tls.DefaultTlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.NewSessionTicket;
import cn.org.bjca.mssp.msspjce.crypto.tls.ProtocolVersion;
import cn.org.bjca.mssp.msspjce.crypto.tls.SignatureAndHashAlgorithm;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsClient;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsClientContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCompression;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsECCUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsExtensionsUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsNullCompression;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSession;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsClient
extends AbstractTlsPeer
implements TlsClient {
    protected TlsCipherFactory cipherFactory;
    protected TlsClientContext context;
    protected Vector supportedSignatureAlgorithms;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;

    public AbstractTlsClient() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsClient(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    @Override
    public void init(TlsClientContext context) {
        this.context = context;
    }

    @Override
    public TlsSession getSessionToResume() {
        return null;
    }

    @Override
    public ProtocolVersion getClientHelloRecordLayerVersion() {
        return this.getClientVersion();
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return ProtocolVersion.TLSv12;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = null;
        ProtocolVersion clientVersion = this.context.getClientVersion();
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(clientVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1};
            this.supportedSignatureAlgorithms = new Vector();
            int i = 0;
            while (i < hashAlgorithms.length) {
                int j = 0;
                while (j < signatureAlgorithms.length) {
                    this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                    ++j;
                }
                ++i;
            }
            this.supportedSignatureAlgorithms.addElement(new SignatureAndHashAlgorithm(2, 2));
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsUtils.addSignatureAlgorithmsExtension(clientExtensions, this.supportedSignatureAlgorithms);
        }
        if (TlsECCUtils.containsECCCipherSuites(this.getCipherSuites())) {
            this.namedCurves = new int[]{23, 24};
            short[] sArray = new short[3];
            sArray[1] = 1;
            sArray[2] = 2;
            this.clientECPointFormats = sArray;
            clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
            TlsECCUtils.addSupportedEllipticCurvesExtension(clientExtensions, this.namedCurves);
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        return clientExtensions;
    }

    public ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        if (!this.getMinimumVersion().isEqualOrEarlierVersionOf(serverVersion)) {
            throw new TlsFatalAlert(70);
        }
    }

    @Override
    public short[] getCompressionMethods() {
        return new short[1];
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
    }

    @Override
    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    @Override
    public void notifySelectedCompressionMethod(short selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (serverExtensions != null) {
            if (serverExtensions.containsKey(TlsUtils.EXT_signature_algorithms)) {
                throw new TlsFatalAlert(47);
            }
            int[] namedCurves = TlsECCUtils.getSupportedEllipticCurvesExtension(serverExtensions);
            if (namedCurves != null) {
                throw new TlsFatalAlert(47);
            }
            this.serverECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(serverExtensions);
            if (this.serverECPointFormats != null && !TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
                throw new TlsFatalAlert(47);
            }
        }
    }

    @Override
    public void processServerSupplementalData(Vector serverSupplementalData) throws IOException {
        if (serverSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public Vector getClientSupplementalData() throws IOException {
        return null;
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public void notifyNewSessionTicket(NewSessionTicket newSessionTicket) throws IOException {
    }
}

