/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsPeer;
import cn.org.bjca.mssp.msspjce.crypto.tls.Certificate;
import cn.org.bjca.mssp.msspjce.crypto.tls.CertificateRequest;
import cn.org.bjca.mssp.msspjce.crypto.tls.CertificateStatus;
import cn.org.bjca.mssp.msspjce.crypto.tls.DefaultTlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.NamedCurve;
import cn.org.bjca.mssp.msspjce.crypto.tls.NewSessionTicket;
import cn.org.bjca.mssp.msspjce.crypto.tls.ProtocolVersion;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCompression;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsECCUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsExtensionsUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsNullCompression;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsServer;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsServerContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsUtils;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsCipherFactory cipherFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected boolean eccCipherSuitesOffered;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer() {
        this(new DefaultTlsCipherFactory());
    }

    public AbstractTlsServer(TlsCipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[1];
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv11;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected boolean supportsClientECCCapabilities(int[] namedCurves, short[] ecPointFormats) {
        if (namedCurves == null) {
            return TlsECCUtils.hasAnySupportedNamedCurves();
        }
        int i = 0;
        while (i < namedCurves.length) {
            int namedCurve = namedCurves[i];
            if (!NamedCurve.refersToASpecificNamedCurve(namedCurve) || TlsECCUtils.isSupportedNamedCurve(namedCurve)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void init(TlsServerContext context) {
        this.context = context;
    }

    @Override
    public void notifyClientVersion(ProtocolVersion clientVersion) throws IOException {
        this.clientVersion = clientVersion;
    }

    @Override
    public void notifyOfferedCipherSuites(int[] offeredCipherSuites) throws IOException {
        this.offeredCipherSuites = offeredCipherSuites;
        this.eccCipherSuitesOffered = TlsECCUtils.containsECCCipherSuites(this.offeredCipherSuites);
    }

    @Override
    public void notifyOfferedCompressionMethods(short[] offeredCompressionMethods) throws IOException {
        this.offeredCompressionMethods = offeredCompressionMethods;
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        this.clientExtensions = clientExtensions;
        if (clientExtensions != null) {
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions);
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension(clientExtensions);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension(clientExtensions);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.namedCurves = TlsECCUtils.getSupportedEllipticCurvesExtension(clientExtensions);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension(clientExtensions);
        }
        if (!(this.eccCipherSuitesOffered || this.namedCurves == null && this.clientECPointFormats == null)) {
            throw new TlsFatalAlert(47);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion maximumVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(maximumVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(maximumVersion)) {
                this.serverVersion = maximumVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        boolean eccCipherSuitesEnabled = this.supportsClientECCCapabilities(this.namedCurves, this.clientECPointFormats);
        int[] cipherSuites = this.getCipherSuites();
        int i = 0;
        while (i < cipherSuites.length) {
            int cipherSuite = cipherSuites[i];
            if (Arrays.contains(this.offeredCipherSuites, cipherSuite) && (eccCipherSuitesEnabled || !TlsECCUtils.isECCCipherSuite(cipherSuite))) {
                this.selectedCipherSuite = cipherSuite;
                return this.selectedCipherSuite;
            }
            ++i;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public short getSelectedCompressionMethod() throws IOException {
        short[] compressionMethods = this.getCompressionMethods();
        int i = 0;
        while (i < compressionMethods.length) {
            if (Arrays.contains(this.offeredCompressionMethods, compressionMethods[i])) {
                this.selectedCompressionMethod = compressionMethods[i];
                return this.selectedCompressionMethod;
            }
            ++i;
        }
        throw new TlsFatalAlert(40);
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        if (this.maxFragmentLengthOffered >= 0) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension(this.checkServerExtensions(), this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension(this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCCipherSuite(this.selectedCipherSuite)) {
            short[] sArray = new short[3];
            sArray[0] = 2;
            sArray[1] = 1;
            this.serverECPointFormats = sArray;
            TlsECCUtils.addSupportedPointFormatsExtension(this.checkServerExtensions(), this.serverECPointFormats);
        }
        return this.serverExtensions;
    }

    @Override
    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    @Override
    public void processClientSupplementalData(Vector clientSupplementalData) throws IOException {
        if (clientSupplementalData != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

