/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.BlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.Digest;
import cn.org.bjca.mssp.msspjce.crypto.Mac;
import cn.org.bjca.mssp.msspjce.crypto.StreamCipher;
import cn.org.bjca.mssp.msspjce.crypto.digests.MD5Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA1Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA256Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA384Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA512Digest;
import cn.org.bjca.mssp.msspjce.crypto.engines.AESFastEngine;
import cn.org.bjca.mssp.msspjce.crypto.engines.CamelliaEngine;
import cn.org.bjca.mssp.msspjce.crypto.engines.DESedeEngine;
import cn.org.bjca.mssp.msspjce.crypto.engines.RC4Engine;
import cn.org.bjca.mssp.msspjce.crypto.engines.SEEDEngine;
import cn.org.bjca.mssp.msspjce.crypto.engines.Salsa20Engine;
import cn.org.bjca.mssp.msspjce.crypto.macs.HMac;
import cn.org.bjca.mssp.msspjce.crypto.modes.AEADBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.CBCBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.CCMBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.GCMBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsAEADCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsNullCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsStreamCipher;
import java.io.IOException;

public class DefaultTlsCipherFactory
extends AbstractTlsCipherFactory {
    @Override
    public TlsCipher createCipher(TlsContext context, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(context, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(context, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(context, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(context, 16, 8);
            }
            case 17: {
                return this.createCipher_AES_CCM(context, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(context, 32, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(context, 16, 16);
            }
            case 9: {
                return this.createAESCipher(context, 32, macAlgorithm);
            }
            case 11: {
                return this.createCipher_AES_GCM(context, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(context, 16, macAlgorithm);
            }
            case 13: {
                return this.createCamelliaCipher(context, 32, macAlgorithm);
            }
            case 100: {
                return this.createSalsa20Cipher(context, 12, 32, macAlgorithm);
            }
            case 0: {
                return this.createNullCipher(context, macAlgorithm);
            }
            case 2: {
                return this.createRC4Cipher(context, 16, macAlgorithm);
            }
            case 101: {
                return this.createSalsa20Cipher(context, 20, 32, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(context, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsBlockCipher createAESCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_CCM(), this.createAEADBlockCipher_AES_CCM(), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsContext context, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(context, this.createAEADBlockCipher_AES_GCM(), this.createAEADBlockCipher_AES_GCM(), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createCamelliaCipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createCamelliaBlockCipher(), this.createCamelliaBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsNullCipher(context, this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm));
    }

    protected TlsStreamCipher createRC4Cipher(TlsContext context, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsStreamCipher createSalsa20Cipher(TlsContext context, int rounds, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsStreamCipher(context, this.createSalsa20StreamCipher(rounds), this.createSalsa20StreamCipher(rounds), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), cipherKeySize);
    }

    protected TlsBlockCipher createSEEDCipher(TlsContext context, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(context, this.createSEEDBlockCipher(), this.createSEEDBlockCipher(), this.createHMACDigest(macAlgorithm), this.createHMACDigest(macAlgorithm), 16);
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(new CamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected StreamCipher createSalsa20StreamCipher(int rounds) {
        return new Salsa20Engine(rounds);
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    protected Digest createHMACDigest(int macAlgorithm) throws IOException {
        switch (macAlgorithm) {
            case 0: {
                return null;
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
            case 5: {
                return new SHA512Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected Mac createMac(int macAlgorithm) throws IOException {
        return new HMac(this.createHMACDigest(macAlgorithm));
    }
}

