/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.InvalidCipherTextException;
import cn.org.bjca.mssp.msspjce.crypto.encodings.PKCS1Encoding;
import cn.org.bjca.mssp.msspjce.crypto.engines.RSABlindedEngine;
import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.ParametersWithRandom;
import cn.org.bjca.mssp.msspjce.crypto.params.RSAKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsEncryptionCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.Certificate;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class DefaultTlsEncryptionCredentials
extends AbstractTlsEncryptionCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public DefaultTlsEncryptionCredentials(TlsContext context, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.context = context;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] decryptPreMasterSecret(byte[] encryptedPreMasterSecret) throws IOException {
        PKCS1Encoding encoding = new PKCS1Encoding(new RSABlindedEngine());
        encoding.init(false, new ParametersWithRandom(this.privateKey, this.context.getSecureRandom()));
        try {
            return encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (InvalidCipherTextException e) {
            throw new TlsFatalAlert(47);
        }
    }
}

