/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsClient;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCipher;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCipherFactory;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsKeyExchange;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsPSKIdentity;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsPSKKeyExchange;
import java.io.IOException;

public abstract class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this.pskIdentity = pskIdentity;
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.pskIdentity = pskIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 182, 148};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 45: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 170: 
            case 171: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 49318: 
            case 49319: 
            case 49322: 
            case 49323: 
            case 65290: 
            case 65291: 
            case 65306: 
            case 65307: {
                return this.createPSKKeyExchange(14);
            }
            case 49203: 
            case 49204: 
            case 49205: 
            case 49206: 
            case 49207: 
            case 49208: 
            case 49209: 
            case 49210: 
            case 49211: 
            case 65294: 
            case 65295: 
            case 65310: 
            case 65311: {
                return this.createPSKKeyExchange(24);
            }
            case 44: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 168: 
            case 169: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 49316: 
            case 49317: 
            case 49320: 
            case 49321: 
            case 65288: 
            case 65289: 
            case 65304: 
            case 65305: {
                return this.createPSKKeyExchange(13);
            }
            case 46: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 172: 
            case 173: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 65292: 
            case 65293: 
            case 65308: 
            case 65309: {
                return this.createPSKKeyExchange(15);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsCipher getCipher() throws IOException {
        switch (this.selectedCipherSuite) {
            case 139: 
            case 143: 
            case 147: 
            case 49204: {
                return this.cipherFactory.createCipher(this.context, 7, 2);
            }
            case 140: 
            case 144: 
            case 148: 
            case 49205: {
                return this.cipherFactory.createCipher(this.context, 8, 2);
            }
            case 174: 
            case 178: 
            case 182: 
            case 49207: {
                return this.cipherFactory.createCipher(this.context, 8, 3);
            }
            case 49316: 
            case 49318: {
                return this.cipherFactory.createCipher(this.context, 15, 0);
            }
            case 49320: 
            case 49322: {
                return this.cipherFactory.createCipher(this.context, 16, 0);
            }
            case 168: 
            case 170: 
            case 172: {
                return this.cipherFactory.createCipher(this.context, 10, 0);
            }
            case 141: 
            case 145: 
            case 149: 
            case 49206: {
                return this.cipherFactory.createCipher(this.context, 9, 2);
            }
            case 175: 
            case 179: 
            case 183: 
            case 49208: {
                return this.cipherFactory.createCipher(this.context, 9, 4);
            }
            case 49317: 
            case 49319: {
                return this.cipherFactory.createCipher(this.context, 17, 0);
            }
            case 49321: 
            case 49323: {
                return this.cipherFactory.createCipher(this.context, 18, 0);
            }
            case 169: 
            case 171: 
            case 173: {
                return this.cipherFactory.createCipher(this.context, 11, 0);
            }
            case 65288: 
            case 65290: 
            case 65292: 
            case 65294: {
                return this.cipherFactory.createCipher(this.context, 100, 2);
            }
            case 65304: 
            case 65306: 
            case 65308: 
            case 65310: {
                return this.cipherFactory.createCipher(this.context, 100, 100);
            }
            case 44: 
            case 45: 
            case 46: 
            case 49209: {
                return this.cipherFactory.createCipher(this.context, 0, 2);
            }
            case 176: 
            case 180: 
            case 184: 
            case 49210: {
                return this.cipherFactory.createCipher(this.context, 0, 3);
            }
            case 177: 
            case 181: 
            case 185: 
            case 49211: {
                return this.cipherFactory.createCipher(this.context, 0, 4);
            }
            case 138: 
            case 142: 
            case 146: 
            case 49203: {
                return this.cipherFactory.createCipher(this.context, 2, 2);
            }
            case 65289: 
            case 65291: 
            case 65293: 
            case 65295: {
                return this.cipherFactory.createCipher(this.context, 101, 2);
            }
            case 65305: 
            case 65307: 
            case 65309: 
            case 65311: {
                return this.cipherFactory.createCipher(this.context, 101, 100);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

