/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.DHParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DHPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.DHPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.AbstractTlsKeyExchange;
import cn.org.bjca.mssp.msspjce.crypto.tls.Certificate;
import cn.org.bjca.mssp.msspjce.crypto.tls.CertificateRequest;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsAgreementCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsDHUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsDSSSigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsRSASigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSignerCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsUtils;
import cn.org.bjca.mssp.msspjce.crypto.util.PublicKeyFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class TlsDHKeyExchange
extends AbstractTlsKeyExchange {
    protected static final BigInteger ONE = BigInteger.valueOf(1L);
    protected static final BigInteger TWO = BigInteger.valueOf(2L);
    protected TlsSigner tlsSigner;
    protected DHParameters dhParameters;
    protected AsymmetricKeyParameter serverPublicKey;
    protected DHPublicKeyParameters dhAgreeServerPublicKey;
    protected TlsAgreementCredentials agreementCredentials;
    protected DHPrivateKeyParameters dhAgreeClientPrivateKey;
    protected DHPrivateKeyParameters dhAgreeServerPrivateKey;
    protected DHPublicKeyParameters dhAgreeClientPublicKey;

    public TlsDHKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 7: 
            case 9: {
                this.tlsSigner = null;
                break;
            }
            case 5: {
                this.tlsSigner = new TlsRSASigner();
                break;
            }
            case 3: {
                this.tlsSigner = new TlsDSSSigner();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.dhParameters = dhParameters;
    }

    @Override
    public void init(TlsContext context) {
        super.init(context);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(context);
        }
    }

    @Override
    public void skipServerCredentials() throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        cn.org.bjca.mssp.msspjce.asn1.x509.Certificate x509Cert = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43);
        }
        if (this.tlsSigner == null) {
            try {
                this.dhAgreeServerPublicKey = TlsDHUtils.validateDHPublicKey((DHPublicKeyParameters)this.serverPublicKey);
            }
            catch (ClassCastException e) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 8);
        } else {
            if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
                throw new TlsFatalAlert(46);
            }
            TlsUtils.validateKeyUsage(x509Cert, 128);
        }
        super.processServerCertificate(serverCertificate);
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 3: 
            case 5: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 64: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (clientCredentials instanceof TlsAgreementCredentials) {
            this.agreementCredentials = (TlsAgreementCredentials)clientCredentials;
        } else if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.agreementCredentials == null) {
            this.dhAgreeClientPrivateKey = TlsDHUtils.generateEphemeralClientKeyExchange(this.context.getSecureRandom(), this.dhAgreeServerPublicKey.getParameters(), output);
        }
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        if (this.agreementCredentials != null) {
            return this.agreementCredentials.generateAgreement(this.dhAgreeServerPublicKey);
        }
        if (this.dhAgreeServerPrivateKey != null) {
            return TlsDHUtils.calculateDHBasicAgreement(this.dhAgreeClientPublicKey, this.dhAgreeServerPrivateKey);
        }
        if (this.dhAgreeClientPrivateKey != null) {
            return TlsDHUtils.calculateDHBasicAgreement(this.dhAgreeServerPublicKey, this.dhAgreeClientPrivateKey);
        }
        throw new TlsFatalAlert(80);
    }
}

