/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.Digest;
import cn.org.bjca.mssp.msspjce.crypto.Signer;
import cn.org.bjca.mssp.msspjce.crypto.params.ECDomainParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.CertificateRequest;
import cn.org.bjca.mssp.msspjce.crypto.tls.CombinedHash;
import cn.org.bjca.mssp.msspjce.crypto.tls.DigestInputBuffer;
import cn.org.bjca.mssp.msspjce.crypto.tls.DigitallySigned;
import cn.org.bjca.mssp.msspjce.crypto.tls.SecurityParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.SignatureAndHashAlgorithm;
import cn.org.bjca.mssp.msspjce.crypto.tls.SignerInputBuffer;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsECCUtils;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsECDHKeyExchange;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSignerCredentials;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsUtils;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import cn.org.bjca.mssp.msspjce.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, int[] namedCurves, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms, namedCurves, clientECPointFormats, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        Digest d;
        SignatureAndHashAlgorithm signatureAndHashAlgorithm;
        int namedCurve = -1;
        if (this.namedCurves == null) {
            namedCurve = 23;
        } else {
            int i = 0;
            while (i < this.namedCurves.length) {
                int entry = this.namedCurves[i];
                if (TlsECCUtils.isSupportedNamedCurve(entry)) {
                    namedCurve = entry;
                    break;
                }
                ++i;
            }
        }
        ECDomainParameters curve_params = null;
        if (namedCurve >= 0) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(namedCurve);
        } else if (Arrays.contains(this.namedCurves, 65281)) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (Arrays.contains(this.namedCurves, 65282)) {
            curve_params = TlsECCUtils.getParametersForNamedCurve(10);
        }
        if (curve_params == null) {
            throw new TlsFatalAlert(80);
        }
        AsymmetricCipherKeyPair kp = TlsECCUtils.generateECKeyPair(this.context.getSecureRandom(), curve_params);
        this.ecAgreePrivateKey = (ECPrivateKeyParameters)kp.getPrivate();
        DigestInputBuffer buf = new DigestInputBuffer();
        if (namedCurve < 0) {
            TlsECCUtils.writeExplicitECParameters(this.clientECPointFormats, curve_params, buf);
        } else {
            TlsECCUtils.writeNamedECParameters(namedCurve, buf);
        }
        ECPublicKeyParameters ecPublicKey = (ECPublicKeyParameters)kp.getPublic();
        TlsECCUtils.writeECPoint(this.clientECPointFormats, ecPublicKey.getQ(), buf);
        if (TlsUtils.isTLSv12(this.context)) {
            signatureAndHashAlgorithm = this.serverCredentials.getSignatureAndHashAlgorithm();
            if (signatureAndHashAlgorithm == null) {
                throw new TlsFatalAlert(80);
            }
            d = TlsUtils.createHash(signatureAndHashAlgorithm.getHash());
        } else {
            signatureAndHashAlgorithm = null;
            d = new CombinedHash();
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(d);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
        DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
        signed_params.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = new SignerInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        ECDomainParameters curve_params = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, teeIn);
        byte[] point = TlsUtils.readOpaque8(teeIn);
        DigitallySigned signed_params = DigitallySigned.parse(this.context, input);
        Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
        buf.updateSigner(signer);
        if (!signer.verifySignature(signed_params.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreePublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, curve_params, point));
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        int i = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    break;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
            ++i;
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

