/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.crypto.tls;

import cn.org.bjca.mssp.msspjce.asn1.ASN1InputStream;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.asn1.x509.Extensions;
import cn.org.bjca.mssp.msspjce.asn1.x509.KeyUsage;
import cn.org.bjca.mssp.msspjce.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.mssp.msspjce.asn1.x509.X509ObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.crypto.Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.MD5Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA1Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA224Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA256Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA384Digest;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA512Digest;
import cn.org.bjca.mssp.msspjce.crypto.macs.HMac;
import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.DSAPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.KeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.RSAKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.Certificate;
import cn.org.bjca.mssp.msspjce.crypto.tls.CombinedHash;
import cn.org.bjca.mssp.msspjce.crypto.tls.ProtocolVersion;
import cn.org.bjca.mssp.msspjce.crypto.tls.SecurityParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.SessionParameters;
import cn.org.bjca.mssp.msspjce.crypto.tls.SignatureAndHashAlgorithm;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsContext;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsDSSSigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsECDSASigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsFatalAlert;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsHandshakeHash;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsProtocol;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsRSASigner;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSession;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSessionImpl;
import cn.org.bjca.mssp.msspjce.crypto.tls.TlsSigner;
import cn.org.bjca.mssp.msspjce.crypto.util.PublicKeyFactory;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import cn.org.bjca.mssp.msspjce.util.Integers;
import cn.org.bjca.mssp.msspjce.util.Strings;
import cn.org.bjca.mssp.msspjce.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class TlsUtils {
    public static byte[] EMPTY_BYTES = new byte[0];
    public static final Integer EXT_signature_algorithms = Integers.valueOf(13);
    static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
    static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
    static final byte[][] SSL3_CONST = TlsUtils.genConst();

    public static void checkUint8(short i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint8(int i) throws IOException {
        if (!TlsUtils.isValidUint8(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint16(int i) throws IOException {
        if (!TlsUtils.isValidUint16(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint24(int i) throws IOException {
        if (!TlsUtils.isValidUint24(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint32(long i) throws IOException {
        if (!TlsUtils.isValidUint32(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint48(long i) throws IOException {
        if (!TlsUtils.isValidUint48(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static void checkUint64(long i) throws IOException {
        if (!TlsUtils.isValidUint64(i)) {
            throw new TlsFatalAlert(80);
        }
    }

    public static boolean isValidUint8(short i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint8(int i) {
        return (i & 0xFF) == i;
    }

    public static boolean isValidUint16(int i) {
        return (i & 0xFFFF) == i;
    }

    public static boolean isValidUint24(int i) {
        return (i & 0xFFFFFF) == i;
    }

    public static boolean isValidUint32(long i) {
        return (i & 0xFFFFFFFFL) == i;
    }

    public static boolean isValidUint48(long i) {
        return (i & 0xFFFFFFFFFFFFL) == i;
    }

    public static boolean isValidUint64(long i) {
        return true;
    }

    public static boolean isSSL(TlsContext context) {
        return context.getServerVersion().isSSL();
    }

    public static boolean isTLSv11(TlsContext context) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(context.getServerVersion().getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsContext context) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(context.getServerVersion().getEquivalentTLSVersion());
    }

    public static void writeUint8(short i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(int i, OutputStream output) throws IOException {
        output.write(i);
    }

    public static void writeUint8(short i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint8(int i, byte[] buf, int offset) {
        buf[offset] = (byte)i;
    }

    public static void writeUint16(int i, OutputStream output) throws IOException {
        output.write(i >> 8);
        output.write(i);
    }

    public static void writeUint16(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 8);
        buf[offset + 1] = (byte)i;
    }

    public static void writeUint24(int i, OutputStream output) throws IOException {
        output.write(i >> 16);
        output.write(i >> 8);
        output.write(i);
    }

    public static void writeUint24(int i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 16);
        buf[offset + 1] = (byte)(i >> 8);
        buf[offset + 2] = (byte)i;
    }

    public static void writeUint32(long i, OutputStream output) throws IOException {
        output.write((int)(i >> 24));
        output.write((int)(i >> 16));
        output.write((int)(i >> 8));
        output.write((int)i);
    }

    public static void writeUint32(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 24);
        buf[offset + 1] = (byte)(i >> 16);
        buf[offset + 2] = (byte)(i >> 8);
        buf[offset + 3] = (byte)i;
    }

    public static void writeUint48(long i, OutputStream output) throws IOException {
        output.write((byte)(i >> 40));
        output.write((byte)(i >> 32));
        output.write((byte)(i >> 24));
        output.write((byte)(i >> 16));
        output.write((byte)(i >> 8));
        output.write((byte)i);
    }

    public static void writeUint48(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 40);
        buf[offset + 1] = (byte)(i >> 32);
        buf[offset + 2] = (byte)(i >> 24);
        buf[offset + 3] = (byte)(i >> 16);
        buf[offset + 4] = (byte)(i >> 8);
        buf[offset + 5] = (byte)i;
    }

    public static void writeUint64(long i, OutputStream output) throws IOException {
        output.write((byte)(i >> 56));
        output.write((byte)(i >> 48));
        output.write((byte)(i >> 40));
        output.write((byte)(i >> 32));
        output.write((byte)(i >> 24));
        output.write((byte)(i >> 16));
        output.write((byte)(i >> 8));
        output.write((byte)i);
    }

    public static void writeUint64(long i, byte[] buf, int offset) {
        buf[offset] = (byte)(i >> 56);
        buf[offset + 1] = (byte)(i >> 48);
        buf[offset + 2] = (byte)(i >> 40);
        buf[offset + 3] = (byte)(i >> 32);
        buf[offset + 4] = (byte)(i >> 24);
        buf[offset + 5] = (byte)(i >> 16);
        buf[offset + 6] = (byte)(i >> 8);
        buf[offset + 7] = (byte)i;
    }

    public static void writeOpaque8(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint8(buf.length);
        TlsUtils.writeUint8(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque16(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint16(buf.length);
        TlsUtils.writeUint16(buf.length, output);
        output.write(buf);
    }

    public static void writeOpaque24(byte[] buf, OutputStream output) throws IOException {
        TlsUtils.checkUint24(buf.length);
        TlsUtils.writeUint24(buf.length, output);
        output.write(buf);
    }

    public static void writeUint8Array(short[] uints, OutputStream output) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint8(uints[i], output);
            ++i;
        }
    }

    public static void writeUint8Array(short[] uints, byte[] buf, int offset) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint8(uints[i], buf, offset);
            ++offset;
            ++i;
        }
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, OutputStream output) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, output);
        TlsUtils.writeUint8Array(uints, output);
    }

    public static void writeUint8ArrayWithUint8Length(short[] uints, byte[] buf, int offset) throws IOException {
        TlsUtils.checkUint8(uints.length);
        TlsUtils.writeUint8(uints.length, buf, offset);
        TlsUtils.writeUint8Array(uints, buf, offset + 1);
    }

    public static void writeUint16Array(int[] uints, OutputStream output) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint16(uints[i], output);
            ++i;
        }
    }

    public static void writeUint16Array(int[] uints, byte[] buf, int offset) throws IOException {
        int i = 0;
        while (i < uints.length) {
            TlsUtils.writeUint16(uints[i], buf, offset);
            offset += 2;
            ++i;
        }
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, OutputStream output) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        TlsUtils.writeUint16Array(uints, output);
    }

    public static void writeUint16ArrayWithUint16Length(int[] uints, byte[] buf, int offset) throws IOException {
        int length = 2 * uints.length;
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, buf, offset);
        TlsUtils.writeUint16Array(uints, buf, offset + 2);
    }

    public static byte[] encodeOpaque8(byte[] buf) throws IOException {
        TlsUtils.checkUint8(buf.length);
        return Arrays.prepend(buf, (byte)buf.length);
    }

    public static byte[] encodeUint8ArrayWithUint8Length(short[] uints) throws IOException {
        byte[] result = new byte[1 + uints.length];
        TlsUtils.writeUint8ArrayWithUint8Length(uints, result, 0);
        return result;
    }

    public static byte[] encodeUint16ArrayWithUint16Length(int[] uints) throws IOException {
        int length = 2 * uints.length;
        byte[] result = new byte[2 + length];
        TlsUtils.writeUint16ArrayWithUint16Length(uints, result, 0);
        return result;
    }

    public static short readUint8(InputStream input) throws IOException {
        int i = input.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (short)i;
    }

    public static short readUint8(byte[] buf, int offset) {
        return buf[offset];
    }

    public static int readUint16(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static int readUint16(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static int readUint24(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        if (i3 < 0) {
            throw new EOFException();
        }
        return i1 << 16 | i2 << 8 | i3;
    }

    public static int readUint24(byte[] buf, int offset) {
        int n = (buf[offset] & 0xFF) << 16;
        n |= (buf[++offset] & 0xFF) << 8;
        return n |= buf[++offset] & 0xFF;
    }

    public static long readUint32(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        if (i4 < 0) {
            throw new EOFException();
        }
        return (long)i1 << 24 | (long)i2 << 16 | (long)i3 << 8 | (long)i4;
    }

    public static long readUint48(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        int i3 = input.read();
        int i4 = input.read();
        int i5 = input.read();
        int i6 = input.read();
        if (i6 < 0) {
            throw new EOFException();
        }
        return (long)i1 << 40 | (long)i2 << 32 | (long)i3 << 24 | (long)i4 << 16 | (long)i5 << 8 | (long)i6;
    }

    public static long readUint48(byte[] buf, int offset) {
        int hi = TlsUtils.readUint24(buf, offset);
        int lo = TlsUtils.readUint24(buf, offset + 3);
        return ((long)hi & 0xFFFFFFFFL) << 24 | (long)lo & 0xFFFFFFFFL;
    }

    public static byte[] readAllOrNothing(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        int read = Streams.readFully(input, buf);
        if (read == 0) {
            return null;
        }
        if (read != length) {
            throw new EOFException();
        }
        return buf;
    }

    public static byte[] readFully(int length, InputStream input) throws IOException {
        if (length < 1) {
            return EMPTY_BYTES;
        }
        byte[] buf = new byte[length];
        if (length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
        return buf;
    }

    public static void readFully(byte[] buf, InputStream input) throws IOException {
        int length = buf.length;
        if (length > 0 && length != Streams.readFully(input, buf)) {
            throw new EOFException();
        }
    }

    public static byte[] readOpaque8(InputStream input) throws IOException {
        short length = TlsUtils.readUint8(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque16(InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        return TlsUtils.readFully(length, input);
    }

    public static byte[] readOpaque24(InputStream input) throws IOException {
        int length = TlsUtils.readUint24(input);
        return TlsUtils.readFully(length, input);
    }

    public static short[] readUint8Array(int count, InputStream input) throws IOException {
        short[] uints = new short[count];
        int i = 0;
        while (i < count) {
            uints[i] = TlsUtils.readUint8(input);
            ++i;
        }
        return uints;
    }

    public static int[] readUint16Array(int count, InputStream input) throws IOException {
        int[] uints = new int[count];
        int i = 0;
        while (i < count) {
            uints[i] = TlsUtils.readUint16(input);
            ++i;
        }
        return uints;
    }

    public static ProtocolVersion readVersion(byte[] buf, int offset) throws IOException {
        return ProtocolVersion.get(buf[offset] & 0xFF, buf[offset + 1] & 0xFF);
    }

    public static ProtocolVersion readVersion(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return ProtocolVersion.get(i1, i2);
    }

    public static int readVersionRaw(byte[] buf, int offset) throws IOException {
        return buf[offset] << 8 | buf[offset + 1];
    }

    public static int readVersionRaw(InputStream input) throws IOException {
        int i1 = input.read();
        int i2 = input.read();
        if (i2 < 0) {
            throw new EOFException();
        }
        return i1 << 8 | i2;
    }

    public static ASN1Primitive readASN1Object(byte[] encoding) throws IOException {
        ASN1InputStream asn1 = new ASN1InputStream(encoding);
        ASN1Primitive result = asn1.readObject();
        if (result == null) {
            throw new TlsFatalAlert(50);
        }
        if (asn1.readObject() != null) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static ASN1Primitive readDERObject(byte[] encoding) throws IOException {
        ASN1Primitive result = TlsUtils.readASN1Object(encoding);
        byte[] check = result.getEncoded("DER");
        if (!Arrays.areEqual(check, encoding)) {
            throw new TlsFatalAlert(50);
        }
        return result;
    }

    public static void writeGMTUnixTime(byte[] buf, int offset) {
        int t = (int)(System.currentTimeMillis() / 1000L);
        buf[offset] = (byte)(t >> 24);
        buf[offset + 1] = (byte)(t >> 16);
        buf[offset + 2] = (byte)(t >> 8);
        buf[offset + 3] = (byte)t;
    }

    public static void writeVersion(ProtocolVersion version, OutputStream output) throws IOException {
        output.write(version.getMajorVersion());
        output.write(version.getMinorVersion());
    }

    public static void writeVersion(ProtocolVersion version, byte[] buf, int offset) {
        buf[offset] = (byte)version.getMajorVersion();
        buf[offset + 1] = (byte)version.getMinorVersion();
    }

    public static Vector getDefaultDSSSignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 2));
    }

    public static Vector getDefaultECDSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 3));
    }

    public static Vector getDefaultRSASignatureAlgorithms() {
        return TlsUtils.vectorOfOne(new SignatureAndHashAlgorithm(2, 1));
    }

    public static byte[] getExtensionData(Hashtable extensions, Integer extensionType) {
        return extensions == null ? null : (byte[])extensions.get(extensionType);
    }

    public static boolean hasExpectedEmptyExtensionData(Hashtable extensions, Integer extensionType, short alertDescription) throws IOException {
        byte[] extension_data = TlsUtils.getExtensionData(extensions, extensionType);
        if (extension_data == null) {
            return false;
        }
        if (extension_data.length != 0) {
            throw new TlsFatalAlert(alertDescription);
        }
        return true;
    }

    public static TlsSession importSession(byte[] sessionID, SessionParameters sessionParameters) {
        return new TlsSessionImpl(sessionID, sessionParameters);
    }

    public static boolean isSignatureAlgorithmsExtensionAllowed(ProtocolVersion clientVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(clientVersion.getEquivalentTLSVersion());
    }

    public static void addSignatureAlgorithmsExtension(Hashtable extensions, Vector supportedSignatureAlgorithms) throws IOException {
        extensions.put(EXT_signature_algorithms, TlsUtils.createSignatureAlgorithmsExtension(supportedSignatureAlgorithms));
    }

    public static Vector getSignatureAlgorithmsExtension(Hashtable extensions) throws IOException {
        byte[] extensionData = TlsUtils.getExtensionData(extensions, EXT_signature_algorithms);
        return extensionData == null ? null : TlsUtils.readSignatureAlgorithmsExtension(extensionData);
    }

    public static byte[] createSignatureAlgorithmsExtension(Vector supportedSignatureAlgorithms) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsUtils.encodeSupportedSignatureAlgorithms(supportedSignatureAlgorithms, false, buf);
        return buf.toByteArray();
    }

    public static Vector readSignatureAlgorithmsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream buf = new ByteArrayInputStream(extensionData);
        Vector supported_signature_algorithms = TlsUtils.parseSupportedSignatureAlgorithms(false, buf);
        TlsProtocol.assertEmpty(buf);
        return supported_signature_algorithms;
    }

    public static void encodeSupportedSignatureAlgorithms(Vector supportedSignatureAlgorithms, boolean allowAnonymous, OutputStream output) throws IOException {
        if (supportedSignatureAlgorithms == null || supportedSignatureAlgorithms.size() < 1 || supportedSignatureAlgorithms.size() >= 32768) {
            throw new IllegalArgumentException("'supportedSignatureAlgorithms' must have length from 1 to (2^15 - 1)");
        }
        int length = 2 * supportedSignatureAlgorithms.size();
        TlsUtils.checkUint16(length);
        TlsUtils.writeUint16(length, output);
        int i = 0;
        while (i < supportedSignatureAlgorithms.size()) {
            SignatureAndHashAlgorithm entry = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (!allowAnonymous && entry.getSignature() == 0) {
                throw new IllegalArgumentException("SignatureAlgorithm.anonymous MUST NOT appear in the signature_algorithms extension");
            }
            entry.encode(output);
            ++i;
        }
    }

    public static Vector parseSupportedSignatureAlgorithms(boolean allowAnonymous, InputStream input) throws IOException {
        int length = TlsUtils.readUint16(input);
        if (length < 2 || (length & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int count = length / 2;
        Vector<SignatureAndHashAlgorithm> supportedSignatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(count);
        int i = 0;
        while (i < count) {
            SignatureAndHashAlgorithm entry = SignatureAndHashAlgorithm.parse(input);
            if (!allowAnonymous && entry.getSignature() == 0) {
                throw new TlsFatalAlert(47);
            }
            supportedSignatureAlgorithms.addElement(entry);
            ++i;
        }
        return supportedSignatureAlgorithms;
    }

    public static byte[] PRF(TlsContext context, byte[] secret, String asciiLabel, byte[] seed, int size) {
        ProtocolVersion version = context.getServerVersion();
        if (version.isSSL()) {
            throw new IllegalStateException("No PRF available for SSLv3 session");
        }
        byte[] label = Strings.toByteArray(asciiLabel);
        byte[] labelSeed = TlsUtils.concat(label, seed);
        int prfAlgorithm = context.getSecurityParameters().getPrfAlgorithm();
        if (prfAlgorithm == 0) {
            return TlsUtils.PRF_legacy(secret, label, labelSeed, size);
        }
        Digest prfDigest = TlsUtils.createPRFHash(prfAlgorithm);
        byte[] buf = new byte[size];
        TlsUtils.hmac_hash(prfDigest, secret, labelSeed, buf);
        return buf;
    }

    static byte[] PRF_legacy(byte[] secret, byte[] label, byte[] labelSeed, int size) {
        int s_half = (secret.length + 1) / 2;
        byte[] s1 = new byte[s_half];
        byte[] s2 = new byte[s_half];
        System.arraycopy(secret, 0, s1, 0, s_half);
        System.arraycopy(secret, secret.length - s_half, s2, 0, s_half);
        byte[] b1 = new byte[size];
        byte[] b2 = new byte[size];
        TlsUtils.hmac_hash(new MD5Digest(), s1, labelSeed, b1);
        TlsUtils.hmac_hash(new SHA1Digest(), s2, labelSeed, b2);
        int i = 0;
        while (i < size) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
            ++i;
        }
        return b1;
    }

    static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    static void hmac_hash(Digest digest, byte[] secret, byte[] seed, byte[] out) {
        HMac mac = new HMac(digest);
        KeyParameter param = new KeyParameter(secret);
        byte[] a = seed;
        int size = digest.getDigestSize();
        int iterations = (out.length + size - 1) / size;
        byte[] buf = new byte[mac.getMacSize()];
        byte[] buf2 = new byte[mac.getMacSize()];
        int i = 0;
        while (i < iterations) {
            mac.init(param);
            mac.update(a, 0, a.length);
            mac.doFinal(buf, 0);
            a = buf;
            mac.init(param);
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(buf2, 0);
            System.arraycopy(buf2, 0, out, size * i, Math.min(size, out.length - size * i));
            ++i;
        }
    }

    static void validateKeyUsage(cn.org.bjca.mssp.msspjce.asn1.x509.Certificate c, int keyUsageBits) throws IOException {
        int bits;
        KeyUsage ku;
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (ku = KeyUsage.fromExtensions(exts)) != null && ((bits = ku.getBytes()[0] & 0xFF) & keyUsageBits) != keyUsageBits) {
            throw new TlsFatalAlert(46);
        }
    }

    static byte[] calculateKeyBlock(TlsContext context, int size) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] master_secret = securityParameters.getMasterSecret();
        byte[] seed = TlsUtils.concat(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        if (TlsUtils.isSSL(context)) {
            return TlsUtils.calculateKeyBlock_SSL(master_secret, seed, size);
        }
        return TlsUtils.PRF(context, master_secret, "key expansion", seed, size);
    }

    static byte[] calculateKeyBlock_SSL(byte[] master_secret, byte[] random, int size) {
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] tmp = new byte[size + md5Size];
        int i = 0;
        int pos = 0;
        while (pos < size) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(master_secret, 0, master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(master_secret, 0, master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(tmp, pos);
            pos += md5Size;
            ++i;
        }
        byte[] rval = new byte[size];
        System.arraycopy(tmp, 0, rval, 0, size);
        return rval;
    }

    static byte[] calculateMasterSecret(TlsContext context, byte[] pre_master_secret) {
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] seed = TlsUtils.concat(securityParameters.getClientRandom(), securityParameters.getServerRandom());
        if (TlsUtils.isSSL(context)) {
            return TlsUtils.calculateMasterSecret_SSL(pre_master_secret, seed);
        }
        return TlsUtils.PRF(context, pre_master_secret, "master secret", seed, 48);
    }

    static byte[] calculateMasterSecret_SSL(byte[] pre_master_secret, byte[] random) {
        MD5Digest md5 = new MD5Digest();
        SHA1Digest sha1 = new SHA1Digest();
        int md5Size = md5.getDigestSize();
        byte[] shatmp = new byte[sha1.getDigestSize()];
        byte[] rval = new byte[md5Size * 3];
        int pos = 0;
        int i = 0;
        while (i < 3) {
            byte[] ssl3Const = SSL3_CONST[i];
            sha1.update(ssl3Const, 0, ssl3Const.length);
            sha1.update(pre_master_secret, 0, pre_master_secret.length);
            sha1.update(random, 0, random.length);
            sha1.doFinal(shatmp, 0);
            md5.update(pre_master_secret, 0, pre_master_secret.length);
            md5.update(shatmp, 0, shatmp.length);
            md5.doFinal(rval, pos);
            pos += md5Size;
            ++i;
        }
        return rval;
    }

    static byte[] calculateVerifyData(TlsContext context, String asciiLabel, byte[] handshakeHash) {
        if (TlsUtils.isSSL(context)) {
            return handshakeHash;
        }
        SecurityParameters securityParameters = context.getSecurityParameters();
        byte[] master_secret = securityParameters.getMasterSecret();
        int verify_data_length = securityParameters.getVerifyDataLength();
        return TlsUtils.PRF(context, master_secret, asciiLabel, handshakeHash, verify_data_length);
    }

    public static final Digest createHash(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest cloneHash(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    public static final Digest createPRFHash(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                return new CombinedHash();
            }
        }
        return TlsUtils.createHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
    }

    public static final Digest clonePRFHash(int prfAlgorithm, Digest hash) {
        switch (prfAlgorithm) {
            case 0: {
                return new CombinedHash((CombinedHash)hash);
            }
        }
        return TlsUtils.cloneHash(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm), hash);
    }

    public static final short getHashAlgorithmForPRFAlgorithm(int prfAlgorithm) {
        switch (prfAlgorithm) {
            case 0: {
                throw new IllegalArgumentException("legacy PRF not a valid algorithm");
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
        }
        throw new IllegalArgumentException("unknown PRFAlgorithm");
    }

    public static ASN1ObjectIdentifier getOIDForHashAlgorithm(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 1: {
                return PKCSObjectIdentifiers.md5;
            }
            case 2: {
                return X509ObjectIdentifiers.id_SHA1;
            }
            case 3: {
                return NISTObjectIdentifiers.id_sha224;
            }
            case 4: {
                return NISTObjectIdentifiers.id_sha256;
            }
            case 5: {
                return NISTObjectIdentifiers.id_sha384;
            }
            case 6: {
                return NISTObjectIdentifiers.id_sha512;
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm");
    }

    static short getClientCertificateType(Certificate clientCertificate, Certificate serverCertificate) throws IOException {
        AsymmetricKeyParameter publicKey;
        cn.org.bjca.mssp.msspjce.asn1.x509.Certificate x509Cert;
        block8: {
            block7: {
                if (clientCertificate.isEmpty()) {
                    return -1;
                }
                x509Cert = clientCertificate.getCertificateAt(0);
                SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
                publicKey = PublicKeyFactory.createKey(keyInfo);
                if (publicKey.isPrivate()) {
                    throw new TlsFatalAlert(80);
                }
                if (!(publicKey instanceof RSAKeyParameters)) break block7;
                TlsUtils.validateKeyUsage(x509Cert, 128);
                return 1;
            }
            if (!(publicKey instanceof DSAPublicKeyParameters)) break block8;
            TlsUtils.validateKeyUsage(x509Cert, 128);
            return 2;
        }
        try {
            if (publicKey instanceof ECPublicKeyParameters) {
                TlsUtils.validateKeyUsage(x509Cert, 128);
                return 64;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new TlsFatalAlert(43);
    }

    static void trackHashAlgorithms(TlsHandshakeHash handshakeHash, Vector supportedSignatureAlgorithms) {
        if (supportedSignatureAlgorithms != null) {
            int i = 0;
            while (i < supportedSignatureAlgorithms.size()) {
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                short hashAlgorithm = signatureAndHashAlgorithm.getHash();
                handshakeHash.trackHashAlgorithm(hashAlgorithm);
                ++i;
            }
        }
    }

    public static boolean hasSigningCapability(short clientCertificateType) {
        switch (clientCertificateType) {
            case 1: 
            case 2: 
            case 64: {
                return true;
            }
        }
        return false;
    }

    public static TlsSigner createTlsSigner(short clientCertificateType) {
        switch (clientCertificateType) {
            case 2: {
                return new TlsDSSSigner();
            }
            case 64: {
                return new TlsECDSASigner();
            }
            case 1: {
                return new TlsRSASigner();
            }
        }
        throw new IllegalArgumentException("'clientCertificateType' is not a type with signing capability");
    }

    private static byte[][] genConst() {
        int n = 10;
        byte[][] arr = new byte[n][];
        int i = 0;
        while (i < n) {
            byte[] b = new byte[i + 1];
            Arrays.fill(b, (byte)(65 + i));
            arr[i] = b;
            ++i;
        }
        return arr;
    }

    private static Vector vectorOfOne(Object obj) {
        Vector<Object> v = new Vector<Object>(1);
        v.addElement(obj);
        return v;
    }
}

