/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.asymmetric.util;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Integer;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.asn1.x9.X962NamedCurves;
import cn.org.bjca.mssp.msspjce.asn1.x9.X9ECParameters;
import cn.org.bjca.mssp.msspjce.crypto.digests.SM3Digest;
import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.jcajce.provider.asymmetric.util.ECUtil;
import cn.org.bjca.mssp.msspjce.jcajce.provider.asymmetric.util.RandomKGenerator;
import cn.org.bjca.mssp.msspjce.jce.provider.MSSPProvider;
import cn.org.bjca.mssp.msspjce.jce.spec.ECNamedCurveParameterSpec;
import cn.org.bjca.mssp.msspjce.jce.spec.ECParameterSpec;
import cn.org.bjca.mssp.msspjce.jce.spec.ECPrivateKeySpec;
import cn.org.bjca.mssp.msspjce.jce.spec.ECPublicKeySpec;
import cn.org.bjca.mssp.msspjce.math.ec.ECCurve;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;

public class SM2Util {
    static X9ECParameters param = X962NamedCurves.getByName("prime256v1_sm2");
    static ECCurve curve = param.getCurve();
    static ECPoint G = param.getG();
    static BigInteger n = param.getN();

    static {
        Security.addProvider(new MSSPProvider());
    }

    public static PublicKey pack2PublicKey(ECPoint p) throws Exception {
        ECNamedCurveParameterSpec spec2 = new ECNamedCurveParameterSpec("prime256v1_sm2", curve, G, param.getN());
        ECPublicKeySpec spec = new ECPublicKeySpec(p, spec2);
        PublicKey pub = KeyFactory.getInstance("EC").generatePublic(spec);
        return pub;
    }

    public static ECPoint pack2Point(byte[] data) throws Exception {
        return curve.decodePoint(data);
    }

    public static PrivateKey pack2PrivateKey(BigInteger d) throws Exception {
        ECParameterSpec spec2 = new ECParameterSpec(curve, G, param.getN());
        ECPrivateKeySpec prispec = new ECPrivateKeySpec(d, spec2);
        PrivateKey pri = KeyFactory.getInstance("EC").generatePrivate(prispec);
        return pri;
    }

    public static void copyBytes2Buffer(byte[] bs, ByteArrayOutputStream buff, int len) {
        byte[] b = new byte[len];
        int i = 0;
        while (i < b.length) {
            b[i] = 0;
            ++i;
        }
        if (bs.length == len) {
            System.arraycopy(bs, 0, b, 0, len);
        }
        if (bs.length > len) {
            System.arraycopy(bs, bs.length - len, b, 0, len);
        } else if (bs.length < len) {
            System.arraycopy(bs, 0, b, len - bs.length, bs.length);
        }
        try {
            buff.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] sm3hash(byte[] d) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(d, 0, d.length);
        byte[] r = new byte[32];
        sm3.doFinal(r, 0);
        return r;
    }

    public static byte[] SM3ForSignature(byte[] plain, ECPoint P) throws Exception {
        byte[] ID = "1234567812345678".getBytes();
        byte[] a = param.getCurve().getA().toBigInteger().toByteArray();
        byte[] b = param.getCurve().getB().toBigInteger().toByteArray();
        byte[] x = P.getAffineXCoord().toBigInteger().toByteArray();
        byte[] y = P.getAffineYCoord().toBigInteger().toByteArray();
        byte[] xg = G.getAffineXCoord().toBigInteger().toByteArray();
        byte[] yg = G.getAffineYCoord().toBigInteger().toByteArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(0);
        baos.write(128);
        baos.write(ID);
        SM2Util.copyBytes2Buffer(a, baos, 32);
        SM2Util.copyBytes2Buffer(b, baos, 32);
        SM2Util.copyBytes2Buffer(xg, baos, 32);
        SM2Util.copyBytes2Buffer(yg, baos, 32);
        SM2Util.copyBytes2Buffer(x, baos, 32);
        SM2Util.copyBytes2Buffer(y, baos, 32);
        byte[] tbh = baos.toByteArray();
        byte[] h1 = SM2Util.sm3hash(tbh);
        byte[] tbh2 = new byte[h1.length + plain.length];
        System.arraycopy(h1, 0, tbh2, 0, h1.length);
        System.arraycopy(plain, 0, tbh2, h1.length, plain.length);
        return SM2Util.sm3hash(tbh2);
    }

    private static BigInteger calculateE(BigInteger n, byte[] message) {
        int log2n = n.bitLength();
        int messageBitLength = message.length * 8;
        BigInteger e = new BigInteger(1, message);
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    public static byte[] sign(PrivateKey pri, byte[] hash) throws Exception {
        BigInteger k;
        BigInteger b23;
        BigInteger d;
        BigInteger b22;
        BigInteger r = null;
        BigInteger s = null;
        BigInteger e = SM2Util.calculateE(n, hash);
        RandomKGenerator kg = new RandomKGenerator();
        kg.init(n, new SecureRandom());
        AsymmetricKeyParameter param = ECUtil.generatePrivateKeyParameter(pri);
        ECPrivateKeyParameters key = (ECPrivateKeyParameters)param;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            do {
                k = kg.nextK();
            } while ((r = (x = (p = key.getParameters().getG().multiply(k).normalize()).getAffineXCoord().toBigInteger()).add(e).mod(n)).equals(BigInteger.ZERO));
        } while ((s = (b22 = (d = key.getD()).add(BigInteger.ONE).modInverse(n)).multiply(b23 = k.subtract(r.multiply(d))).mod(n)).equals(BigInteger.ZERO));
        ASN1EncodableVector aev = new ASN1EncodableVector();
        aev.add(new ASN1Integer(r));
        aev.add(new ASN1Integer(s));
        DERSequence seq = new DERSequence(aev);
        return seq.getEncoded();
    }

    public static boolean verify(PublicKey pub, byte[] signed, byte[] hash) throws Exception {
        ECPoint X2;
        AsymmetricKeyParameter param2 = ECUtil.generatePublicKeyParameter(pub);
        ECPublicKeyParameters key = (ECPublicKeyParameters)param2;
        ECPoint P = key.getQ();
        ASN1Sequence seq = (ASN1Sequence)ASN1Sequence.fromByteArray(signed);
        ASN1Integer ai1 = (ASN1Integer)seq.getObjectAt(0);
        ASN1Integer ai2 = (ASN1Integer)seq.getObjectAt(1);
        BigInteger br = ai1.getPositiveValue();
        BigInteger bs = ai2.getPositiveValue();
        BigInteger t = br.add(bs).mod(n);
        BigInteger e = new BigInteger(1, hash);
        ECPoint X1 = G.multiply(bs);
        ECPoint X = X1.add(X2 = P.multiply(t)).normalize();
        BigInteger x = X.getAffineXCoord().toBigInteger();
        BigInteger r1 = e.add(x).mod(n);
        return br.equals(r1);
    }
}

