/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.digest;

import cn.org.bjca.mssp.msspjce.asn1.nist.NISTObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.crypto.CipherKeyGenerator;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA224Digest;
import cn.org.bjca.mssp.msspjce.crypto.macs.HMac;
import cn.org.bjca.mssp.msspjce.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.digest.BCMessageDigest;
import cn.org.bjca.mssp.msspjce.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseMac;

public class SHA224 {
    private SHA224() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA224Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new SHA224Digest((SHA224Digest)this.digest);
            return d;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA224Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA224", 224, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA224.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA-224", String.valueOf(PREFIX) + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest.SHA224", "SHA-224");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
            this.addHMACAlgorithm(provider, "SHA224", String.valueOf(PREFIX) + "$HashMac", String.valueOf(PREFIX) + "$KeyGenerator");
            this.addHMACAlias(provider, "SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        }
    }
}

