/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.digest;

import cn.org.bjca.mssp.msspjce.crypto.CipherKeyGenerator;
import cn.org.bjca.mssp.msspjce.crypto.digests.SHA3Digest;
import cn.org.bjca.mssp.msspjce.crypto.macs.HMac;
import cn.org.bjca.mssp.msspjce.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.digest.BCMessageDigest;
import cn.org.bjca.mssp.msspjce.jcajce.provider.digest.DigestAlgorithmProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseMac;

public class SHA3 {
    private SHA3() {
    }

    public static class Digest224
    extends DigestSHA3 {
        public Digest224() {
            super(224);
        }
    }

    public static class Digest256
    extends DigestSHA3 {
        public Digest256() {
            super(256);
        }
    }

    public static class Digest384
    extends DigestSHA3 {
        public Digest384() {
            super(384);
        }
    }

    public static class Digest512
    extends DigestSHA3 {
        public Digest512() {
            super(512);
        }
    }

    public static class DigestSHA3
    extends BCMessageDigest
    implements Cloneable {
        public DigestSHA3(int size) {
            super(new SHA3Digest(size));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest d = (BCMessageDigest)super.clone();
            d.digest = new SHA3Digest((SHA3Digest)this.digest);
            return d;
        }
    }

    public static class HashMac224
    extends BaseMac {
        public HashMac224() {
            super(new HMac(new SHA3Digest(224)));
        }
    }

    public static class HashMac256
    extends BaseMac {
        public HashMac256() {
            super(new HMac(new SHA3Digest(256)));
        }
    }

    public static class HashMac384
    extends BaseMac {
        public HashMac384() {
            super(new HMac(new SHA3Digest(384)));
        }
    }

    public static class HashMac512
    extends BaseMac {
        public HashMac512() {
            super(new HMac(new SHA3Digest(512)));
        }
    }

    public static class KeyGenerator224
    extends BaseKeyGenerator {
        public KeyGenerator224() {
            super("HMACSHA3-224", 224, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator256
    extends BaseKeyGenerator {
        public KeyGenerator256() {
            super("HMACSHA3-256", 256, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator384
    extends BaseKeyGenerator {
        public KeyGenerator384() {
            super("HMACSHA3-384", 384, new CipherKeyGenerator());
        }
    }

    public static class KeyGenerator512
    extends BaseKeyGenerator {
        public KeyGenerator512() {
            super("HMACSHA3-512", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA3.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.SHA3-224", String.valueOf(PREFIX) + "$Digest224");
            provider.addAlgorithm("MessageDigest.SHA3-256", String.valueOf(PREFIX) + "$Digest256");
            provider.addAlgorithm("MessageDigest.SHA3-384", String.valueOf(PREFIX) + "$Digest384");
            provider.addAlgorithm("MessageDigest.SHA3-512", String.valueOf(PREFIX) + "$Digest512");
            this.addHMACAlgorithm(provider, "SHA3-224", String.valueOf(PREFIX) + "$HashMac224", String.valueOf(PREFIX) + "$KeyGenerator224");
            this.addHMACAlgorithm(provider, "SHA3-256", String.valueOf(PREFIX) + "$HashMac256", String.valueOf(PREFIX) + "$KeyGenerator256");
            this.addHMACAlgorithm(provider, "SHA3-384", String.valueOf(PREFIX) + "$HashMac384", String.valueOf(PREFIX) + "$KeyGenerator384");
            this.addHMACAlgorithm(provider, "SHA3-512", String.valueOf(PREFIX) + "$HashMac512", String.valueOf(PREFIX) + "$KeyGenerator512");
        }
    }
}

