/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric;

import cn.org.bjca.mssp.msspjce.crypto.BlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.CipherKeyGenerator;
import cn.org.bjca.mssp.msspjce.crypto.engines.CAST6Engine;
import cn.org.bjca.mssp.msspjce.crypto.generators.Poly1305KeyGenerator;
import cn.org.bjca.mssp.msspjce.crypto.macs.GMac;
import cn.org.bjca.mssp.msspjce.crypto.modes.GCMBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseMac;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BlockCipherProvider;

public final class CAST6 {
    private CAST6() {
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new CAST6Engine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = CAST6.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CAST6", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.CAST6", String.valueOf(PREFIX) + "$KeyGen");
            this.addGMacAlgorithm(provider, "CAST6", String.valueOf(PREFIX) + "$GMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addPoly1305Algorithm(provider, "CAST6", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new cn.org.bjca.mssp.msspjce.crypto.macs.Poly1305(new CAST6Engine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-CAST6", 256, new Poly1305KeyGenerator());
        }
    }
}

