/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric;

import cn.org.bjca.mssp.msspjce.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.crypto.BufferedBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.CipherKeyGenerator;
import cn.org.bjca.mssp.msspjce.crypto.engines.GOST28147Engine;
import cn.org.bjca.mssp.msspjce.crypto.macs.GOST28147Mac;
import cn.org.bjca.mssp.msspjce.crypto.modes.CBCBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.GCFBBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseMac;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.org.bjca.mssp.msspjce.jcajce.provider.util.AlgorithmProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class GOST28147 {
    private GOST28147() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("GOST28147", "MSSP");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "GOST IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new GOST28147Engine()), 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new GOST28147Engine());
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            super(new BufferedBlockCipher(new GCFBBlockCipher(new GOST28147Engine())), 64);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("GOST28147", keySize, new CipherKeyGenerator());
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            super(new GOST28147Mac());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = GOST28147.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.GOST28147", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.Cipher.GOST-28147", "GOST28147");
            provider.addAlgorithm("Cipher." + CryptoProObjectIdentifiers.gostR28147_gcfb, String.valueOf(PREFIX) + "$GCFB");
            provider.addAlgorithm("KeyGenerator.GOST28147", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator.GOST-28147", "GOST28147");
            provider.addAlgorithm("Alg.Alias.KeyGenerator." + CryptoProObjectIdentifiers.gostR28147_gcfb, "GOST28147");
            provider.addAlgorithm("Mac.GOST28147MAC", String.valueOf(PREFIX) + "$Mac");
            provider.addAlgorithm("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        }
    }
}

