/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric;

import cn.org.bjca.mssp.msspjce.crypto.BlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.BufferedBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.engines.SM4Engine;
import cn.org.bjca.mssp.msspjce.crypto.modes.CBCBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.CFBBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.GCMBlockCipher;
import cn.org.bjca.mssp.msspjce.crypto.modes.OFBBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.org.bjca.mssp.msspjce.jcajce.provider.symmetric.util.BlockCipherProvider;

public final class SM4 {
    private static final Class gcmSpecClass = SM4.lookup("javax.crypto.spec.GCMParameterSpec");

    private SM4() {
    }

    private static Class lookup(String className) {
        try {
            Class<?> def = SM4.class.getClassLoader().loadClass(className);
            return def;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SM4Engine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new SM4Engine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SM4Engine();
                }
            });
        }
    }

    public static class GCM
    extends BaseBlockCipher {
        public GCM() {
            super(new GCMBlockCipher(new SM4Engine()));
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = SM4.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.SM4", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher.SM4/ECB", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher.SM4/CBC", String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Alg.Alias.Cipher.1.2.156.10197.1.104", "SM4");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new SM4Engine(), 128)), 128);
        }
    }
}

