/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.math.ec;

import cn.org.bjca.mssp.msspjce.math.ec.AbstractECMultiplier;
import cn.org.bjca.mssp.msspjce.math.ec.ECPoint;
import cn.org.bjca.mssp.msspjce.math.ec.WNafUtil;
import java.math.BigInteger;

public class NafR2LMultiplier
extends AbstractECMultiplier {
    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        int[] naf = WNafUtil.generateCompactNaf(k);
        ECPoint R0 = p.getCurve().getInfinity();
        ECPoint R1 = p;
        int zeroes = 0;
        int i = 0;
        while (i < naf.length) {
            int ni = naf[i];
            int digit = ni >> 16;
            R1 = R1.timesPow2(zeroes += ni & 0xFFFF);
            R0 = R0.add(digit < 0 ? R1.negate() : R1);
            zeroes = 1;
            ++i;
        }
        return R0;
    }
}

