/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.asn1;

import cn.org.bjca.mssp.msspjce.asn1.ASN1EncodableVector;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Integer;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Object;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.DEROctetString;
import cn.org.bjca.mssp.msspjce.asn1.DERSequence;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.math.BigInteger;

public class McElieceCCA2PrivateKey
extends ASN1Object {
    private ASN1ObjectIdentifier oid;
    private int n;
    private int k;
    private byte[] encField;
    private byte[] encGp;
    private byte[] encP;
    private byte[] encH;
    private byte[][] encqInv;

    public McElieceCCA2PrivateKey(ASN1ObjectIdentifier oid, int n, int k, GF2mField field, PolynomialGF2mSmallM goppaPoly, Permutation p, GF2Matrix h, PolynomialGF2mSmallM[] qInv) {
        this.oid = oid;
        this.n = n;
        this.k = k;
        this.encField = field.getEncoded();
        this.encGp = goppaPoly.getEncoded();
        this.encP = p.getEncoded();
        this.encH = h.getEncoded();
        this.encqInv = new byte[qInv.length][];
        int i = 0;
        while (i != qInv.length) {
            this.encqInv[i] = qInv[i].getEncoded();
            ++i;
        }
    }

    private McElieceCCA2PrivateKey(ASN1Sequence seq) {
        this.oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        BigInteger bigN = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        this.n = bigN.intValue();
        BigInteger bigK = ((ASN1Integer)seq.getObjectAt(2)).getValue();
        this.k = bigK.intValue();
        this.encField = ((ASN1OctetString)seq.getObjectAt(3)).getOctets();
        this.encGp = ((ASN1OctetString)seq.getObjectAt(4)).getOctets();
        this.encP = ((ASN1OctetString)seq.getObjectAt(5)).getOctets();
        this.encH = ((ASN1OctetString)seq.getObjectAt(6)).getOctets();
        ASN1Sequence asnQInv = (ASN1Sequence)seq.getObjectAt(7);
        this.encqInv = new byte[asnQInv.size()][];
        int i = 0;
        while (i < asnQInv.size()) {
            this.encqInv[i] = ((ASN1OctetString)asnQInv.getObjectAt(i)).getOctets();
            ++i;
        }
    }

    public ASN1ObjectIdentifier getOID() {
        return this.oid;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    public GF2mField getField() {
        return new GF2mField(this.encField);
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return new PolynomialGF2mSmallM(this.getField(), this.encGp);
    }

    public Permutation getP() {
        return new Permutation(this.encP);
    }

    public GF2Matrix getH() {
        return new GF2Matrix(this.encH);
    }

    public PolynomialGF2mSmallM[] getQInv() {
        PolynomialGF2mSmallM[] qInv = new PolynomialGF2mSmallM[this.encqInv.length];
        GF2mField field = this.getField();
        int i = 0;
        while (i < this.encqInv.length) {
            qInv[i] = new PolynomialGF2mSmallM(field, this.encqInv[i]);
            ++i;
        }
        return qInv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.oid);
        v.add(new ASN1Integer(this.n));
        v.add(new ASN1Integer(this.k));
        v.add(new DEROctetString(this.encField));
        v.add(new DEROctetString(this.encGp));
        v.add(new DEROctetString(this.encP));
        v.add(new DEROctetString(this.encH));
        ASN1EncodableVector asnQInv = new ASN1EncodableVector();
        int i = 0;
        while (i < this.encqInv.length) {
            asnQInv.add(new DEROctetString(this.encqInv[i]));
            ++i;
        }
        v.add(new DERSequence(asnQInv));
        return new DERSequence(v);
    }

    public static McElieceCCA2PrivateKey getInstance(Object o) {
        if (o instanceof McElieceCCA2PrivateKey) {
            return (McElieceCCA2PrivateKey)o;
        }
        if (o != null) {
            return new McElieceCCA2PrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

