/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.mssp.msspjce.crypto.KeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceCCA2Parameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GoppaCode;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.PolynomialRingGF2m;
import java.security.SecureRandom;

public class McElieceCCA2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";
    private McElieceCCA2KeyGenerationParameters mcElieceCCA2Params;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceCCA2KeyGenerationParameters mcCCA2Params = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters());
        this.init(mcCCA2Params);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.mcElieceCCA2Params = (McElieceCCA2KeyGenerationParameters)param;
        this.random = new SecureRandom();
        this.m = this.mcElieceCCA2Params.getParameters().getM();
        this.n = this.mcElieceCCA2Params.getParameters().getN();
        this.t = this.mcElieceCCA2Params.getParameters().getT();
        this.fieldPoly = this.mcElieceCCA2Params.getParameters().getFieldPoly();
        this.initialized = true;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        PolynomialRingGF2m ring = new PolynomialRingGF2m(field, gp);
        PolynomialGF2mSmallM[] qInv = ring.getSquareRootMatrix();
        GF2Matrix h = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        int k = shortG.getNumRows();
        McElieceCCA2PublicKeyParameters pubKey = new McElieceCCA2PublicKeyParameters(OID, this.n, this.t, shortG, this.mcElieceCCA2Params.getParameters());
        McElieceCCA2PrivateKeyParameters privKey = new McElieceCCA2PrivateKeyParameters(OID, this.n, k, field, gp, p, h, qInv, this.mcElieceCCA2Params.getParameters());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

