/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece;

import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.mssp.msspjce.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.mssp.msspjce.crypto.KeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McElieceParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.GoppaCode;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.PolynomialRingGF2m;
import java.security.SecureRandom;

public class McElieceKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private McElieceKeyGenerationParameters mcElieceParams;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceKeyGenerationParameters mcParams = new McElieceKeyGenerationParameters(new SecureRandom(), new McElieceParameters());
        this.initialize(mcParams);
    }

    private void initialize(KeyGenerationParameters param) {
        this.mcElieceParams = (McElieceKeyGenerationParameters)param;
        this.random = new SecureRandom();
        this.m = this.mcElieceParams.getParameters().getM();
        this.n = this.mcElieceParams.getParameters().getN();
        this.t = this.mcElieceParams.getParameters().getT();
        this.fieldPoly = this.mcElieceParams.getParameters().getFieldPoly();
        this.initialized = true;
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        PolynomialRingGF2m ring = new PolynomialRingGF2m(field, gp);
        PolynomialGF2mSmallM[] sqRootMatrix = ring.getSquareRootMatrix();
        GF2Matrix h = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p1 = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        GF2Matrix gPrime = shortG.extendLeftCompactForm();
        int k = shortG.getNumRows();
        GF2Matrix[] matrixSandInverse = GF2Matrix.createRandomRegularMatrixAndItsInverse(k, this.random);
        Permutation p2 = new Permutation(this.n, this.random);
        GF2Matrix g = (GF2Matrix)matrixSandInverse[0].rightMultiply(gPrime);
        g = (GF2Matrix)g.rightMultiply(p2);
        McEliecePublicKeyParameters pubKey = new McEliecePublicKeyParameters(OID, this.n, this.t, g, this.mcElieceParams.getParameters());
        McEliecePrivateKeyParameters privKey = new McEliecePrivateKeyParameters(OID, this.n, k, field, gp, matrixSandInverse[1], p1, p2, h, sqRootMatrix, this.mcElieceParams.getParameters());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

