/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.crypto.ntru;

import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.pqc.crypto.ntru.NTRUSigningKeyGenerationParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.IntegerPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.Polynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.ProductFormPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class NTRUSigningPrivateKeyParameters
extends AsymmetricKeyParameter {
    private List<Basis> bases;
    private NTRUSigningPublicKeyParameters publicKey;

    public NTRUSigningPrivateKeyParameters(byte[] b, NTRUSigningKeyGenerationParameters params) throws IOException {
        this(new ByteArrayInputStream(b), params);
    }

    public NTRUSigningPrivateKeyParameters(InputStream is, NTRUSigningKeyGenerationParameters params) throws IOException {
        super(true);
        this.bases = new ArrayList<Basis>();
        int i = 0;
        while (i <= params.B) {
            this.add(new Basis(is, params, i != 0));
            ++i;
        }
        this.publicKey = new NTRUSigningPublicKeyParameters(is, params.getSigningParameters());
    }

    public NTRUSigningPrivateKeyParameters(List<Basis> bases, NTRUSigningPublicKeyParameters publicKey) {
        super(true);
        this.bases = new ArrayList<Basis>(bases);
        this.publicKey = publicKey;
    }

    private void add(Basis b) {
        this.bases.add(b);
    }

    public Basis getBasis(int i) {
        return this.bases.get(i);
    }

    public NTRUSigningPublicKeyParameters getPublicKey() {
        return this.publicKey;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = 0;
        while (i < this.bases.size()) {
            this.bases.get(i).encode(os, i != 0);
            ++i;
        }
        os.write(this.publicKey.getEncoded());
        return os.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bases == null ? 0 : this.bases.hashCode());
        for (Basis basis : this.bases) {
            result += basis.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPrivateKeyParameters other = (NTRUSigningPrivateKeyParameters)obj;
        if (this.bases == null && other.bases != null) {
            return false;
        }
        if (this.bases.size() != other.bases.size()) {
            return false;
        }
        int i = 0;
        while (i < this.bases.size()) {
            Basis basis1 = this.bases.get(i);
            Basis basis2 = other.bases.get(i);
            if (!basis1.f.equals(basis2.f)) {
                return false;
            }
            if (!basis1.fPrime.equals(basis2.fPrime)) {
                return false;
            }
            if (i != 0 && !basis1.h.equals(basis2.h)) {
                return false;
            }
            if (!basis1.params.equals(basis2.params)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Basis {
        public Polynomial f;
        public Polynomial fPrime;
        public IntegerPolynomial h;
        NTRUSigningKeyGenerationParameters params;

        protected Basis(Polynomial f, Polynomial fPrime, IntegerPolynomial h, NTRUSigningKeyGenerationParameters params) {
            this.f = f;
            this.fPrime = fPrime;
            this.h = h;
            this.params = params;
        }

        Basis(InputStream is, NTRUSigningKeyGenerationParameters params, boolean include_h) throws IOException {
            int N = params.N;
            int q = params.q;
            int d1 = params.d1;
            int d2 = params.d2;
            int d3 = params.d3;
            boolean sparse = params.sparse;
            this.params = params;
            if (params.polyType == 1) {
                this.f = ProductFormPolynomial.fromBinary(is, N, d1, d2, d3 + 1, d3);
            } else {
                IntegerPolynomial fInt = IntegerPolynomial.fromBinary3Tight(is, N);
                Polynomial polynomial = this.f = sparse ? new SparseTernaryPolynomial(fInt) : new DenseTernaryPolynomial(fInt);
            }
            if (params.basisType == 0) {
                IntegerPolynomial fPrimeInt = IntegerPolynomial.fromBinary(is, N, q);
                int i = 0;
                while (i < fPrimeInt.coeffs.length) {
                    int n = i++;
                    fPrimeInt.coeffs[n] = fPrimeInt.coeffs[n] - q / 2;
                }
                this.fPrime = fPrimeInt;
            } else {
                this.fPrime = params.polyType == 1 ? ProductFormPolynomial.fromBinary(is, N, d1, d2, d3 + 1, d3) : IntegerPolynomial.fromBinary3Tight(is, N);
            }
            if (include_h) {
                this.h = IntegerPolynomial.fromBinary(is, N, q);
            }
        }

        void encode(OutputStream os, boolean include_h) throws IOException {
            int q = this.params.q;
            os.write(this.getEncoded(this.f));
            if (this.params.basisType == 0) {
                IntegerPolynomial fPrimeInt = this.fPrime.toIntegerPolynomial();
                int i = 0;
                while (i < fPrimeInt.coeffs.length) {
                    int n = i++;
                    fPrimeInt.coeffs[n] = fPrimeInt.coeffs[n] + q / 2;
                }
                os.write(fPrimeInt.toBinary(q));
            } else {
                os.write(this.getEncoded(this.fPrime));
            }
            if (include_h) {
                os.write(this.h.toBinary(q));
            }
        }

        private byte[] getEncoded(Polynomial p) {
            if (p instanceof ProductFormPolynomial) {
                return ((ProductFormPolynomial)p).toBinary();
            }
            return p.toIntegerPolynomial().toBinary3Tight();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.f == null ? 0 : this.f.hashCode());
            result = 31 * result + (this.fPrime == null ? 0 : this.fPrime.hashCode());
            result = 31 * result + (this.h == null ? 0 : this.h.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Basis)) {
                return false;
            }
            Basis other = (Basis)obj;
            if (this.f == null ? other.f != null : !this.f.equals(other.f)) {
                return false;
            }
            if (this.fPrime == null ? other.fPrime != null : !this.fPrime.equals(other.fPrime)) {
                return false;
            }
            if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
                return false;
            }
            return !(this.params == null ? other.params != null : !this.params.equals(other.params));
        }
    }
}

