/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.crypto.ntru;

import cn.org.bjca.mssp.msspjce.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.mssp.msspjce.pqc.crypto.ntru.NTRUSigningParameters;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.IntegerPolynomial;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUSigningPublicKeyParameters
extends AsymmetricKeyParameter {
    private NTRUSigningParameters params;
    public IntegerPolynomial h;

    public NTRUSigningPublicKeyParameters(IntegerPolynomial h, NTRUSigningParameters params) {
        super(false);
        this.h = h;
        this.params = params;
    }

    public NTRUSigningPublicKeyParameters(byte[] b, NTRUSigningParameters params) {
        super(false);
        this.h = IntegerPolynomial.fromBinary(b, params.N, params.q);
        this.params = params;
    }

    public NTRUSigningPublicKeyParameters(InputStream is, NTRUSigningParameters params) throws IOException {
        super(false);
        this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
        this.params = params;
    }

    public byte[] getEncoded() {
        return this.h.toBinary(this.params.q);
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.h == null ? 0 : this.h.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NTRUSigningPublicKeyParameters other = (NTRUSigningPublicKeyParameters)obj;
        if (this.h == null ? other.h != null : !this.h.equals(other.h)) {
            return false;
        }
        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
    }
}

