/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.jcajce.provider.gmss;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.crypto.CipherParameters;
import cn.org.bjca.mssp.msspjce.pqc.asn1.GMSSPublicKey;
import cn.org.bjca.mssp.msspjce.pqc.asn1.PQCObjectIdentifiers;
import cn.org.bjca.mssp.msspjce.pqc.asn1.ParSet;
import cn.org.bjca.mssp.msspjce.pqc.crypto.gmss.GMSSParameters;
import cn.org.bjca.mssp.msspjce.pqc.crypto.gmss.GMSSPublicKeyParameters;
import cn.org.bjca.mssp.msspjce.pqc.jcajce.provider.util.KeyUtil;
import cn.org.bjca.mssp.msspjce.pqc.jcajce.spec.GMSSPublicKeySpec;
import cn.org.bjca.mssp.msspjce.util.encoders.Hex;
import java.security.PublicKey;

public class BCGMSSPublicKey
implements CipherParameters,
PublicKey {
    private static final long serialVersionUID = 1L;
    private byte[] publicKeyBytes;
    private GMSSParameters gmssParameterSet;
    private GMSSParameters gmssParams;

    public BCGMSSPublicKey(byte[] pub, GMSSParameters gmssParameterSet) {
        this.gmssParameterSet = gmssParameterSet;
        this.publicKeyBytes = pub;
    }

    protected BCGMSSPublicKey(GMSSPublicKeySpec keySpec) {
        this(keySpec.getPublicKey(), keySpec.getParameters());
    }

    public BCGMSSPublicKey(GMSSPublicKeyParameters params) {
        this(params.getPublicKey(), params.getParameters());
    }

    @Override
    public String getAlgorithm() {
        return "GMSS";
    }

    public byte[] getPublicKeyBytes() {
        return this.publicKeyBytes;
    }

    public GMSSParameters getParameterSet() {
        return this.gmssParameterSet;
    }

    public String toString() {
        String out = "GMSS public key : " + new String(Hex.encode(this.publicKeyBytes)) + "\n" + "Height of Trees: \n";
        int i = 0;
        while (i < this.gmssParameterSet.getHeightOfTrees().length) {
            out = String.valueOf(out) + "Layer " + i + " : " + this.gmssParameterSet.getHeightOfTrees()[i] + " WinternitzParameter: " + this.gmssParameterSet.getWinternitzParameter()[i] + " K: " + this.gmssParameterSet.getK()[i] + "\n";
            ++i;
        }
        return out;
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PQCObjectIdentifiers.gmss, (ASN1Encodable)new ParSet(this.gmssParameterSet.getNumOfLayers(), this.gmssParameterSet.getHeightOfTrees(), this.gmssParameterSet.getWinternitzParameter(), this.gmssParameterSet.getK()).toASN1Primitive()), new GMSSPublicKey(this.publicKeyBytes));
    }

    @Override
    public String getFormat() {
        return "X.509";
    }
}

