/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra;

import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.IntUtils;
import cn.org.bjca.mssp.msspjce.pqc.math.linearalgebra.IntegerFunctions;
import java.math.BigInteger;
import java.util.Random;

public class GF2Polynomial {
    private int len;
    private int blocks;
    private int[] value;
    private static Random rand = new Random();
    private static final boolean[] parity;
    private static final short[] squaringTable;
    private static final int[] bitMask;
    private static final int[] reverseRightMask;

    static {
        boolean[] blArray = new boolean[256];
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[11] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[16] = true;
        blArray[19] = true;
        blArray[21] = true;
        blArray[22] = true;
        blArray[25] = true;
        blArray[26] = true;
        blArray[28] = true;
        blArray[31] = true;
        blArray[32] = true;
        blArray[35] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[41] = true;
        blArray[42] = true;
        blArray[44] = true;
        blArray[47] = true;
        blArray[49] = true;
        blArray[50] = true;
        blArray[52] = true;
        blArray[55] = true;
        blArray[56] = true;
        blArray[59] = true;
        blArray[61] = true;
        blArray[62] = true;
        blArray[64] = true;
        blArray[67] = true;
        blArray[69] = true;
        blArray[70] = true;
        blArray[73] = true;
        blArray[74] = true;
        blArray[76] = true;
        blArray[79] = true;
        blArray[81] = true;
        blArray[82] = true;
        blArray[84] = true;
        blArray[87] = true;
        blArray[88] = true;
        blArray[91] = true;
        blArray[93] = true;
        blArray[94] = true;
        blArray[97] = true;
        blArray[98] = true;
        blArray[100] = true;
        blArray[103] = true;
        blArray[104] = true;
        blArray[107] = true;
        blArray[109] = true;
        blArray[110] = true;
        blArray[112] = true;
        blArray[115] = true;
        blArray[117] = true;
        blArray[118] = true;
        blArray[121] = true;
        blArray[122] = true;
        blArray[124] = true;
        blArray[127] = true;
        blArray[128] = true;
        blArray[131] = true;
        blArray[133] = true;
        blArray[134] = true;
        blArray[137] = true;
        blArray[138] = true;
        blArray[140] = true;
        blArray[143] = true;
        blArray[145] = true;
        blArray[146] = true;
        blArray[148] = true;
        blArray[151] = true;
        blArray[152] = true;
        blArray[155] = true;
        blArray[157] = true;
        blArray[158] = true;
        blArray[161] = true;
        blArray[162] = true;
        blArray[164] = true;
        blArray[167] = true;
        blArray[168] = true;
        blArray[171] = true;
        blArray[173] = true;
        blArray[174] = true;
        blArray[176] = true;
        blArray[179] = true;
        blArray[181] = true;
        blArray[182] = true;
        blArray[185] = true;
        blArray[186] = true;
        blArray[188] = true;
        blArray[191] = true;
        blArray[193] = true;
        blArray[194] = true;
        blArray[196] = true;
        blArray[199] = true;
        blArray[200] = true;
        blArray[203] = true;
        blArray[205] = true;
        blArray[206] = true;
        blArray[208] = true;
        blArray[211] = true;
        blArray[213] = true;
        blArray[214] = true;
        blArray[217] = true;
        blArray[218] = true;
        blArray[220] = true;
        blArray[223] = true;
        blArray[224] = true;
        blArray[227] = true;
        blArray[229] = true;
        blArray[230] = true;
        blArray[233] = true;
        blArray[234] = true;
        blArray[236] = true;
        blArray[239] = true;
        blArray[241] = true;
        blArray[242] = true;
        blArray[244] = true;
        blArray[247] = true;
        blArray[248] = true;
        blArray[251] = true;
        blArray[253] = true;
        blArray[254] = true;
        parity = blArray;
        short[] sArray = new short[256];
        sArray[1] = 1;
        sArray[2] = 4;
        sArray[3] = 5;
        sArray[4] = 16;
        sArray[5] = 17;
        sArray[6] = 20;
        sArray[7] = 21;
        sArray[8] = 64;
        sArray[9] = 65;
        sArray[10] = 68;
        sArray[11] = 69;
        sArray[12] = 80;
        sArray[13] = 81;
        sArray[14] = 84;
        sArray[15] = 85;
        sArray[16] = 256;
        sArray[17] = 257;
        sArray[18] = 260;
        sArray[19] = 261;
        sArray[20] = 272;
        sArray[21] = 273;
        sArray[22] = 276;
        sArray[23] = 277;
        sArray[24] = 320;
        sArray[25] = 321;
        sArray[26] = 324;
        sArray[27] = 325;
        sArray[28] = 336;
        sArray[29] = 337;
        sArray[30] = 340;
        sArray[31] = 341;
        sArray[32] = 1024;
        sArray[33] = 1025;
        sArray[34] = 1028;
        sArray[35] = 1029;
        sArray[36] = 1040;
        sArray[37] = 1041;
        sArray[38] = 1044;
        sArray[39] = 1045;
        sArray[40] = 1088;
        sArray[41] = 1089;
        sArray[42] = 1092;
        sArray[43] = 1093;
        sArray[44] = 1104;
        sArray[45] = 1105;
        sArray[46] = 1108;
        sArray[47] = 1109;
        sArray[48] = 1280;
        sArray[49] = 1281;
        sArray[50] = 1284;
        sArray[51] = 1285;
        sArray[52] = 1296;
        sArray[53] = 1297;
        sArray[54] = 1300;
        sArray[55] = 1301;
        sArray[56] = 1344;
        sArray[57] = 1345;
        sArray[58] = 1348;
        sArray[59] = 1349;
        sArray[60] = 1360;
        sArray[61] = 1361;
        sArray[62] = 1364;
        sArray[63] = 1365;
        sArray[64] = 4096;
        sArray[65] = 4097;
        sArray[66] = 4100;
        sArray[67] = 4101;
        sArray[68] = 4112;
        sArray[69] = 4113;
        sArray[70] = 4116;
        sArray[71] = 4117;
        sArray[72] = 4160;
        sArray[73] = 4161;
        sArray[74] = 4164;
        sArray[75] = 4165;
        sArray[76] = 4176;
        sArray[77] = 4177;
        sArray[78] = 4180;
        sArray[79] = 4181;
        sArray[80] = 4352;
        sArray[81] = 4353;
        sArray[82] = 4356;
        sArray[83] = 4357;
        sArray[84] = 4368;
        sArray[85] = 4369;
        sArray[86] = 4372;
        sArray[87] = 4373;
        sArray[88] = 4416;
        sArray[89] = 4417;
        sArray[90] = 4420;
        sArray[91] = 4421;
        sArray[92] = 4432;
        sArray[93] = 4433;
        sArray[94] = 4436;
        sArray[95] = 4437;
        sArray[96] = 5120;
        sArray[97] = 5121;
        sArray[98] = 5124;
        sArray[99] = 5125;
        sArray[100] = 5136;
        sArray[101] = 5137;
        sArray[102] = 5140;
        sArray[103] = 5141;
        sArray[104] = 5184;
        sArray[105] = 5185;
        sArray[106] = 5188;
        sArray[107] = 5189;
        sArray[108] = 5200;
        sArray[109] = 5201;
        sArray[110] = 5204;
        sArray[111] = 5205;
        sArray[112] = 5376;
        sArray[113] = 5377;
        sArray[114] = 5380;
        sArray[115] = 5381;
        sArray[116] = 5392;
        sArray[117] = 5393;
        sArray[118] = 5396;
        sArray[119] = 5397;
        sArray[120] = 5440;
        sArray[121] = 5441;
        sArray[122] = 5444;
        sArray[123] = 5445;
        sArray[124] = 5456;
        sArray[125] = 5457;
        sArray[126] = 5460;
        sArray[127] = 5461;
        sArray[128] = 16384;
        sArray[129] = 16385;
        sArray[130] = 16388;
        sArray[131] = 16389;
        sArray[132] = 16400;
        sArray[133] = 16401;
        sArray[134] = 16404;
        sArray[135] = 16405;
        sArray[136] = 16448;
        sArray[137] = 16449;
        sArray[138] = 16452;
        sArray[139] = 16453;
        sArray[140] = 16464;
        sArray[141] = 16465;
        sArray[142] = 16468;
        sArray[143] = 16469;
        sArray[144] = 16640;
        sArray[145] = 16641;
        sArray[146] = 16644;
        sArray[147] = 16645;
        sArray[148] = 16656;
        sArray[149] = 16657;
        sArray[150] = 16660;
        sArray[151] = 16661;
        sArray[152] = 16704;
        sArray[153] = 16705;
        sArray[154] = 16708;
        sArray[155] = 16709;
        sArray[156] = 16720;
        sArray[157] = 16721;
        sArray[158] = 16724;
        sArray[159] = 16725;
        sArray[160] = 17408;
        sArray[161] = 17409;
        sArray[162] = 17412;
        sArray[163] = 17413;
        sArray[164] = 17424;
        sArray[165] = 17425;
        sArray[166] = 17428;
        sArray[167] = 17429;
        sArray[168] = 17472;
        sArray[169] = 17473;
        sArray[170] = 17476;
        sArray[171] = 17477;
        sArray[172] = 17488;
        sArray[173] = 17489;
        sArray[174] = 17492;
        sArray[175] = 17493;
        sArray[176] = 17664;
        sArray[177] = 17665;
        sArray[178] = 17668;
        sArray[179] = 17669;
        sArray[180] = 17680;
        sArray[181] = 17681;
        sArray[182] = 17684;
        sArray[183] = 17685;
        sArray[184] = 17728;
        sArray[185] = 17729;
        sArray[186] = 17732;
        sArray[187] = 17733;
        sArray[188] = 17744;
        sArray[189] = 17745;
        sArray[190] = 17748;
        sArray[191] = 17749;
        sArray[192] = 20480;
        sArray[193] = 20481;
        sArray[194] = 20484;
        sArray[195] = 20485;
        sArray[196] = 20496;
        sArray[197] = 20497;
        sArray[198] = 20500;
        sArray[199] = 20501;
        sArray[200] = 20544;
        sArray[201] = 20545;
        sArray[202] = 20548;
        sArray[203] = 20549;
        sArray[204] = 20560;
        sArray[205] = 20561;
        sArray[206] = 20564;
        sArray[207] = 20565;
        sArray[208] = 20736;
        sArray[209] = 20737;
        sArray[210] = 20740;
        sArray[211] = 20741;
        sArray[212] = 20752;
        sArray[213] = 20753;
        sArray[214] = 20756;
        sArray[215] = 20757;
        sArray[216] = 20800;
        sArray[217] = 20801;
        sArray[218] = 20804;
        sArray[219] = 20805;
        sArray[220] = 20816;
        sArray[221] = 20817;
        sArray[222] = 20820;
        sArray[223] = 20821;
        sArray[224] = 21504;
        sArray[225] = 21505;
        sArray[226] = 21508;
        sArray[227] = 21509;
        sArray[228] = 21520;
        sArray[229] = 21521;
        sArray[230] = 21524;
        sArray[231] = 21525;
        sArray[232] = 21568;
        sArray[233] = 21569;
        sArray[234] = 21572;
        sArray[235] = 21573;
        sArray[236] = 21584;
        sArray[237] = 21585;
        sArray[238] = 21588;
        sArray[239] = 21589;
        sArray[240] = 21760;
        sArray[241] = 21761;
        sArray[242] = 21764;
        sArray[243] = 21765;
        sArray[244] = 21776;
        sArray[245] = 21777;
        sArray[246] = 21780;
        sArray[247] = 21781;
        sArray[248] = 21824;
        sArray[249] = 21825;
        sArray[250] = 21828;
        sArray[251] = 21829;
        sArray[252] = 21840;
        sArray[253] = 21841;
        sArray[254] = 21844;
        sArray[255] = 21845;
        squaringTable = sArray;
        int[] nArray = new int[33];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 8;
        nArray[4] = 16;
        nArray[5] = 32;
        nArray[6] = 64;
        nArray[7] = 128;
        nArray[8] = 256;
        nArray[9] = 512;
        nArray[10] = 1024;
        nArray[11] = 2048;
        nArray[12] = 4096;
        nArray[13] = 8192;
        nArray[14] = 16384;
        nArray[15] = 32768;
        nArray[16] = 65536;
        nArray[17] = 131072;
        nArray[18] = 262144;
        nArray[19] = 524288;
        nArray[20] = 0x100000;
        nArray[21] = 0x200000;
        nArray[22] = 0x400000;
        nArray[23] = 0x800000;
        nArray[24] = 0x1000000;
        nArray[25] = 0x2000000;
        nArray[26] = 0x4000000;
        nArray[27] = 0x8000000;
        nArray[28] = 0x10000000;
        nArray[29] = 0x20000000;
        nArray[30] = 0x40000000;
        nArray[31] = Integer.MIN_VALUE;
        bitMask = nArray;
        int[] nArray2 = new int[33];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 7;
        nArray2[4] = 15;
        nArray2[5] = 31;
        nArray2[6] = 63;
        nArray2[7] = 127;
        nArray2[8] = 255;
        nArray2[9] = 511;
        nArray2[10] = 1023;
        nArray2[11] = 2047;
        nArray2[12] = 4095;
        nArray2[13] = 8191;
        nArray2[14] = 16383;
        nArray2[15] = Short.MAX_VALUE;
        nArray2[16] = 65535;
        nArray2[17] = 131071;
        nArray2[18] = 262143;
        nArray2[19] = 524287;
        nArray2[20] = 1048575;
        nArray2[21] = 0x1FFFFF;
        nArray2[22] = 0x3FFFFF;
        nArray2[23] = 0x7FFFFF;
        nArray2[24] = 0xFFFFFF;
        nArray2[25] = 0x1FFFFFF;
        nArray2[26] = 0x3FFFFFF;
        nArray2[27] = 0x7FFFFFF;
        nArray2[28] = 0xFFFFFFF;
        nArray2[29] = 0x1FFFFFFF;
        nArray2[30] = 0x3FFFFFFF;
        nArray2[31] = Integer.MAX_VALUE;
        nArray2[32] = -1;
        reverseRightMask = nArray2;
    }

    public GF2Polynomial(int length) {
        int l = length;
        if (l < 1) {
            l = 1;
        }
        this.blocks = (l - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l;
    }

    public GF2Polynomial(int length, Random rand) {
        int l = length;
        if (l < 1) {
            l = 1;
        }
        this.blocks = (l - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l;
        this.randomize(rand);
    }

    public GF2Polynomial(int length, String value) {
        int l = length;
        if (l < 1) {
            l = 1;
        }
        this.blocks = (l - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l;
        if (value.equalsIgnoreCase("ZERO")) {
            this.assignZero();
        } else if (value.equalsIgnoreCase("ONE")) {
            this.assignOne();
        } else if (value.equalsIgnoreCase("RANDOM")) {
            this.randomize();
        } else if (value.equalsIgnoreCase("X")) {
            this.assignX();
        } else if (value.equalsIgnoreCase("ALL")) {
            this.assignAll();
        } else {
            throw new IllegalArgumentException("Error: GF2Polynomial was called using " + value + " as value!");
        }
    }

    public GF2Polynomial(int length, int[] bs) {
        int leng = length;
        if (leng < 1) {
            leng = 1;
        }
        this.blocks = (leng - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = leng;
        int l = Math.min(this.blocks, bs.length);
        System.arraycopy(bs, 0, this.value, 0, l);
        this.zeroUnusedBits();
    }

    public GF2Polynomial(int length, byte[] os) {
        int m;
        int l = length;
        if (l < 1) {
            l = 1;
        }
        this.blocks = (l - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l;
        int k = Math.min((os.length - 1 >> 2) + 1, this.blocks);
        int i = 0;
        while (i < k - 1) {
            m = os.length - (i << 2) - 1;
            this.value[i] = os[m] & 0xFF;
            int n = i;
            this.value[n] = this.value[n] | os[m - 1] << 8 & 0xFF00;
            int n2 = i;
            this.value[n2] = this.value[n2] | os[m - 2] << 16 & 0xFF0000;
            int n3 = i++;
            this.value[n3] = this.value[n3] | os[m - 3] << 24 & 0xFF000000;
        }
        i = k - 1;
        m = os.length - (i << 2) - 1;
        this.value[i] = os[m] & 0xFF;
        if (m > 0) {
            int n = i;
            this.value[n] = this.value[n] | os[m - 1] << 8 & 0xFF00;
        }
        if (m > 1) {
            int n = i;
            this.value[n] = this.value[n] | os[m - 2] << 16 & 0xFF0000;
        }
        if (m > 2) {
            int n = i;
            this.value[n] = this.value[n] | os[m - 3] << 24 & 0xFF000000;
        }
        this.zeroUnusedBits();
        this.reduceN();
    }

    public GF2Polynomial(int length, BigInteger bi) {
        int l = length;
        if (l < 1) {
            l = 1;
        }
        this.blocks = (l - 1 >> 5) + 1;
        this.value = new int[this.blocks];
        this.len = l;
        byte[] val = bi.toByteArray();
        if (val[0] == 0) {
            byte[] dummy = new byte[val.length - 1];
            System.arraycopy(val, 1, dummy, 0, dummy.length);
            val = dummy;
        }
        int ov = val.length & 3;
        int k = (val.length - 1 >> 2) + 1;
        int i = 0;
        while (i < ov) {
            int n = k - 1;
            this.value[n] = this.value[n] | (val[i] & 0xFF) << (ov - 1 - i << 3);
            ++i;
        }
        int m = 0;
        i = 0;
        while (i <= val.length - 4 >> 2) {
            m = val.length - 1 - (i << 2);
            this.value[i] = val[m] & 0xFF;
            int n = i;
            this.value[n] = this.value[n] | val[m - 1] << 8 & 0xFF00;
            int n2 = i;
            this.value[n2] = this.value[n2] | val[m - 2] << 16 & 0xFF0000;
            int n3 = i++;
            this.value[n3] = this.value[n3] | val[m - 3] << 24 & 0xFF000000;
        }
        if ((this.len & 0x1F) != 0) {
            int n = this.blocks - 1;
            this.value[n] = this.value[n] & reverseRightMask[this.len & 0x1F];
        }
        this.reduceN();
    }

    public GF2Polynomial(GF2Polynomial b) {
        this.len = b.len;
        this.blocks = b.blocks;
        this.value = IntUtils.clone(b.value);
    }

    public Object clone() {
        return new GF2Polynomial(this);
    }

    public int getLength() {
        return this.len;
    }

    public int[] toIntegerArray() {
        int[] result = new int[this.blocks];
        System.arraycopy(this.value, 0, result, 0, this.blocks);
        return result;
    }

    public String toString(int radix) {
        char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String[] BIN_CHARS = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};
        String res = new String();
        if (radix == 16) {
            int i = this.blocks - 1;
            while (i >= 0) {
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 28 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 24 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 20 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 16 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 12 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 8 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] >>> 4 & 0xF];
                res = String.valueOf(res) + HEX_CHARS[this.value[i] & 0xF];
                res = String.valueOf(res) + " ";
                --i;
            }
        } else {
            int i = this.blocks - 1;
            while (i >= 0) {
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 28 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 24 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 20 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 16 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 12 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 8 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] >>> 4 & 0xF];
                res = String.valueOf(res) + BIN_CHARS[this.value[i] & 0xF];
                res = String.valueOf(res) + " ";
                --i;
            }
        }
        return res;
    }

    public byte[] toByteArray() {
        int m;
        int k = (this.len - 1 >> 3) + 1;
        int ov = k & 3;
        byte[] res = new byte[k];
        int i = 0;
        while (i < k >> 2) {
            m = k - (i << 2) - 1;
            res[m] = (byte)(this.value[i] & 0xFF);
            res[m - 1] = (byte)((this.value[i] & 0xFF00) >>> 8);
            res[m - 2] = (byte)((this.value[i] & 0xFF0000) >>> 16);
            res[m - 3] = (byte)((this.value[i] & 0xFF000000) >>> 24);
            ++i;
        }
        i = 0;
        while (i < ov) {
            m = ov - i - 1 << 3;
            res[i] = (byte)((this.value[this.blocks - 1] & 255 << m) >>> m);
            ++i;
        }
        return res;
    }

    public BigInteger toFlexiBigInt() {
        if (this.len == 0 || this.isZero()) {
            return new BigInteger(0, new byte[0]);
        }
        return new BigInteger(1, this.toByteArray());
    }

    public void assignOne() {
        int i = 1;
        while (i < this.blocks) {
            this.value[i] = 0;
            ++i;
        }
        this.value[0] = 1;
    }

    public void assignX() {
        int i = 1;
        while (i < this.blocks) {
            this.value[i] = 0;
            ++i;
        }
        this.value[0] = 2;
    }

    public void assignAll() {
        int i = 0;
        while (i < this.blocks) {
            this.value[i] = -1;
            ++i;
        }
        this.zeroUnusedBits();
    }

    public void assignZero() {
        int i = 0;
        while (i < this.blocks) {
            this.value[i] = 0;
            ++i;
        }
    }

    public void randomize() {
        int i = 0;
        while (i < this.blocks) {
            this.value[i] = rand.nextInt();
            ++i;
        }
        this.zeroUnusedBits();
    }

    public void randomize(Random rand) {
        int i = 0;
        while (i < this.blocks) {
            this.value[i] = rand.nextInt();
            ++i;
        }
        this.zeroUnusedBits();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2Polynomial)) {
            return false;
        }
        GF2Polynomial otherPol = (GF2Polynomial)other;
        if (this.len != otherPol.len) {
            return false;
        }
        int i = 0;
        while (i < this.blocks) {
            if (this.value[i] != otherPol.value[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.len + this.value.hashCode();
    }

    public boolean isZero() {
        if (this.len == 0) {
            return true;
        }
        int i = 0;
        while (i < this.blocks) {
            if (this.value[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOne() {
        int i = 1;
        while (i < this.blocks) {
            if (this.value[i] != 0) {
                return false;
            }
            ++i;
        }
        return this.value[0] == 1;
    }

    public void addToThis(GF2Polynomial b) {
        this.expandN(b.len);
        this.xorThisBy(b);
    }

    public GF2Polynomial add(GF2Polynomial b) {
        return this.xor(b);
    }

    public void subtractFromThis(GF2Polynomial b) {
        this.expandN(b.len);
        this.xorThisBy(b);
    }

    public GF2Polynomial subtract(GF2Polynomial b) {
        return this.xor(b);
    }

    public void increaseThis() {
        this.xorBit(0);
    }

    public GF2Polynomial increase() {
        GF2Polynomial result = new GF2Polynomial(this);
        result.increaseThis();
        return result;
    }

    public GF2Polynomial multiplyClassic(GF2Polynomial b) {
        GF2Polynomial result = new GF2Polynomial(Math.max(this.len, b.len) << 1);
        GF2Polynomial[] m = new GF2Polynomial[32];
        m[0] = new GF2Polynomial(this);
        int i = 1;
        while (i <= 31) {
            m[i] = m[i - 1].shiftLeft();
            ++i;
        }
        i = 0;
        while (i < b.blocks) {
            int j = 0;
            while (j <= 31) {
                if ((b.value[i] & bitMask[j]) != 0) {
                    result.xorThisBy(m[j]);
                }
                ++j;
            }
            j = 0;
            while (j <= 31) {
                m[j].shiftBlocksLeft();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public GF2Polynomial multiply(GF2Polynomial b) {
        int n = Math.max(this.len, b.len);
        this.expandN(n);
        b.expandN(n);
        return this.karaMult(b);
    }

    private GF2Polynomial karaMult(GF2Polynomial b) {
        GF2Polynomial result = new GF2Polynomial(this.len << 1);
        if (this.len <= 32) {
            result.value = GF2Polynomial.mult32(this.value[0], b.value[0]);
            return result;
        }
        if (this.len <= 64) {
            result.value = GF2Polynomial.mult64(this.value, b.value);
            return result;
        }
        if (this.len <= 128) {
            result.value = GF2Polynomial.mult128(this.value, b.value);
            return result;
        }
        if (this.len <= 256) {
            result.value = GF2Polynomial.mult256(this.value, b.value);
            return result;
        }
        if (this.len <= 512) {
            result.value = GF2Polynomial.mult512(this.value, b.value);
            return result;
        }
        int n = IntegerFunctions.floorLog(this.len - 1);
        n = bitMask[n];
        GF2Polynomial a0 = this.lower((n - 1 >> 5) + 1);
        GF2Polynomial a1 = this.upper((n - 1 >> 5) + 1);
        GF2Polynomial b0 = b.lower((n - 1 >> 5) + 1);
        GF2Polynomial b1 = b.upper((n - 1 >> 5) + 1);
        GF2Polynomial c = a1.karaMult(b1);
        GF2Polynomial e = a0.karaMult(b0);
        a0.addToThis(a1);
        b0.addToThis(b1);
        GF2Polynomial d = a0.karaMult(b0);
        result.shiftLeftAddThis(c, n << 1);
        result.shiftLeftAddThis(c, n);
        result.shiftLeftAddThis(d, n);
        result.shiftLeftAddThis(e, n);
        result.addToThis(e);
        return result;
    }

    private static int[] mult512(int[] a, int[] b) {
        int[] result = new int[32];
        int[] a0 = new int[8];
        System.arraycopy(a, 0, a0, 0, Math.min(8, a.length));
        int[] a1 = new int[8];
        if (a.length > 8) {
            System.arraycopy(a, 8, a1, 0, Math.min(8, a.length - 8));
        }
        int[] b0 = new int[8];
        System.arraycopy(b, 0, b0, 0, Math.min(8, b.length));
        int[] b1 = new int[8];
        if (b.length > 8) {
            System.arraycopy(b, 8, b1, 0, Math.min(8, b.length - 8));
        }
        int[] c = GF2Polynomial.mult256(a1, b1);
        result[31] = result[31] ^ c[15];
        result[30] = result[30] ^ c[14];
        result[29] = result[29] ^ c[13];
        result[28] = result[28] ^ c[12];
        result[27] = result[27] ^ c[11];
        result[26] = result[26] ^ c[10];
        result[25] = result[25] ^ c[9];
        result[24] = result[24] ^ c[8];
        result[23] = result[23] ^ (c[7] ^ c[15]);
        result[22] = result[22] ^ (c[6] ^ c[14]);
        result[21] = result[21] ^ (c[5] ^ c[13]);
        result[20] = result[20] ^ (c[4] ^ c[12]);
        result[19] = result[19] ^ (c[3] ^ c[11]);
        result[18] = result[18] ^ (c[2] ^ c[10]);
        result[17] = result[17] ^ (c[1] ^ c[9]);
        result[16] = result[16] ^ (c[0] ^ c[8]);
        result[15] = result[15] ^ c[7];
        result[14] = result[14] ^ c[6];
        result[13] = result[13] ^ c[5];
        result[12] = result[12] ^ c[4];
        result[11] = result[11] ^ c[3];
        result[10] = result[10] ^ c[2];
        result[9] = result[9] ^ c[1];
        result[8] = result[8] ^ c[0];
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        a1[2] = a1[2] ^ a0[2];
        a1[3] = a1[3] ^ a0[3];
        a1[4] = a1[4] ^ a0[4];
        a1[5] = a1[5] ^ a0[5];
        a1[6] = a1[6] ^ a0[6];
        a1[7] = a1[7] ^ a0[7];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        b1[2] = b1[2] ^ b0[2];
        b1[3] = b1[3] ^ b0[3];
        b1[4] = b1[4] ^ b0[4];
        b1[5] = b1[5] ^ b0[5];
        b1[6] = b1[6] ^ b0[6];
        b1[7] = b1[7] ^ b0[7];
        int[] d = GF2Polynomial.mult256(a1, b1);
        result[23] = result[23] ^ d[15];
        result[22] = result[22] ^ d[14];
        result[21] = result[21] ^ d[13];
        result[20] = result[20] ^ d[12];
        result[19] = result[19] ^ d[11];
        result[18] = result[18] ^ d[10];
        result[17] = result[17] ^ d[9];
        result[16] = result[16] ^ d[8];
        result[15] = result[15] ^ d[7];
        result[14] = result[14] ^ d[6];
        result[13] = result[13] ^ d[5];
        result[12] = result[12] ^ d[4];
        result[11] = result[11] ^ d[3];
        result[10] = result[10] ^ d[2];
        result[9] = result[9] ^ d[1];
        result[8] = result[8] ^ d[0];
        int[] e = GF2Polynomial.mult256(a0, b0);
        result[23] = result[23] ^ e[15];
        result[22] = result[22] ^ e[14];
        result[21] = result[21] ^ e[13];
        result[20] = result[20] ^ e[12];
        result[19] = result[19] ^ e[11];
        result[18] = result[18] ^ e[10];
        result[17] = result[17] ^ e[9];
        result[16] = result[16] ^ e[8];
        result[15] = result[15] ^ (e[7] ^ e[15]);
        result[14] = result[14] ^ (e[6] ^ e[14]);
        result[13] = result[13] ^ (e[5] ^ e[13]);
        result[12] = result[12] ^ (e[4] ^ e[12]);
        result[11] = result[11] ^ (e[3] ^ e[11]);
        result[10] = result[10] ^ (e[2] ^ e[10]);
        result[9] = result[9] ^ (e[1] ^ e[9]);
        result[8] = result[8] ^ (e[0] ^ e[8]);
        result[7] = result[7] ^ e[7];
        result[6] = result[6] ^ e[6];
        result[5] = result[5] ^ e[5];
        result[4] = result[4] ^ e[4];
        result[3] = result[3] ^ e[3];
        result[2] = result[2] ^ e[2];
        result[1] = result[1] ^ e[1];
        result[0] = result[0] ^ e[0];
        return result;
    }

    private static int[] mult256(int[] a, int[] b) {
        int[] c;
        int[] result = new int[16];
        int[] a0 = new int[4];
        System.arraycopy(a, 0, a0, 0, Math.min(4, a.length));
        int[] a1 = new int[4];
        if (a.length > 4) {
            System.arraycopy(a, 4, a1, 0, Math.min(4, a.length - 4));
        }
        int[] b0 = new int[4];
        System.arraycopy(b, 0, b0, 0, Math.min(4, b.length));
        int[] b1 = new int[4];
        if (b.length > 4) {
            System.arraycopy(b, 4, b1, 0, Math.min(4, b.length - 4));
        }
        if (a1[3] == 0 && a1[2] == 0 && b1[3] == 0 && b1[2] == 0) {
            if (a1[1] == 0 && b1[1] == 0) {
                if (a1[0] != 0 || b1[0] != 0) {
                    c = GF2Polynomial.mult32(a1[0], b1[0]);
                    result[9] = result[9] ^ c[1];
                    result[8] = result[8] ^ c[0];
                    result[5] = result[5] ^ c[1];
                    result[4] = result[4] ^ c[0];
                }
            } else {
                c = GF2Polynomial.mult64(a1, b1);
                result[11] = result[11] ^ c[3];
                result[10] = result[10] ^ c[2];
                result[9] = result[9] ^ c[1];
                result[8] = result[8] ^ c[0];
                result[7] = result[7] ^ c[3];
                result[6] = result[6] ^ c[2];
                result[5] = result[5] ^ c[1];
                result[4] = result[4] ^ c[0];
            }
        } else {
            c = GF2Polynomial.mult128(a1, b1);
            result[15] = result[15] ^ c[7];
            result[14] = result[14] ^ c[6];
            result[13] = result[13] ^ c[5];
            result[12] = result[12] ^ c[4];
            result[11] = result[11] ^ (c[3] ^ c[7]);
            result[10] = result[10] ^ (c[2] ^ c[6]);
            result[9] = result[9] ^ (c[1] ^ c[5]);
            result[8] = result[8] ^ (c[0] ^ c[4]);
            result[7] = result[7] ^ c[3];
            result[6] = result[6] ^ c[2];
            result[5] = result[5] ^ c[1];
            result[4] = result[4] ^ c[0];
        }
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        a1[2] = a1[2] ^ a0[2];
        a1[3] = a1[3] ^ a0[3];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        b1[2] = b1[2] ^ b0[2];
        b1[3] = b1[3] ^ b0[3];
        int[] d = GF2Polynomial.mult128(a1, b1);
        result[11] = result[11] ^ d[7];
        result[10] = result[10] ^ d[6];
        result[9] = result[9] ^ d[5];
        result[8] = result[8] ^ d[4];
        result[7] = result[7] ^ d[3];
        result[6] = result[6] ^ d[2];
        result[5] = result[5] ^ d[1];
        result[4] = result[4] ^ d[0];
        int[] e = GF2Polynomial.mult128(a0, b0);
        result[11] = result[11] ^ e[7];
        result[10] = result[10] ^ e[6];
        result[9] = result[9] ^ e[5];
        result[8] = result[8] ^ e[4];
        result[7] = result[7] ^ (e[3] ^ e[7]);
        result[6] = result[6] ^ (e[2] ^ e[6]);
        result[5] = result[5] ^ (e[1] ^ e[5]);
        result[4] = result[4] ^ (e[0] ^ e[4]);
        result[3] = result[3] ^ e[3];
        result[2] = result[2] ^ e[2];
        result[1] = result[1] ^ e[1];
        result[0] = result[0] ^ e[0];
        return result;
    }

    private static int[] mult128(int[] a, int[] b) {
        int[] e;
        int[] d;
        int[] c;
        int[] result = new int[8];
        int[] a0 = new int[2];
        System.arraycopy(a, 0, a0, 0, Math.min(2, a.length));
        int[] a1 = new int[2];
        if (a.length > 2) {
            System.arraycopy(a, 2, a1, 0, Math.min(2, a.length - 2));
        }
        int[] b0 = new int[2];
        System.arraycopy(b, 0, b0, 0, Math.min(2, b.length));
        int[] b1 = new int[2];
        if (b.length > 2) {
            System.arraycopy(b, 2, b1, 0, Math.min(2, b.length - 2));
        }
        if (a1[1] == 0 && b1[1] == 0) {
            if (a1[0] != 0 || b1[0] != 0) {
                c = GF2Polynomial.mult32(a1[0], b1[0]);
                result[5] = result[5] ^ c[1];
                result[4] = result[4] ^ c[0];
                result[3] = result[3] ^ c[1];
                result[2] = result[2] ^ c[0];
            }
        } else {
            c = GF2Polynomial.mult64(a1, b1);
            result[7] = result[7] ^ c[3];
            result[6] = result[6] ^ c[2];
            result[5] = result[5] ^ (c[1] ^ c[3]);
            result[4] = result[4] ^ (c[0] ^ c[2]);
            result[3] = result[3] ^ c[1];
            result[2] = result[2] ^ c[0];
        }
        a1[0] = a1[0] ^ a0[0];
        a1[1] = a1[1] ^ a0[1];
        b1[0] = b1[0] ^ b0[0];
        b1[1] = b1[1] ^ b0[1];
        if (a1[1] == 0 && b1[1] == 0) {
            d = GF2Polynomial.mult32(a1[0], b1[0]);
            result[3] = result[3] ^ d[1];
            result[2] = result[2] ^ d[0];
        } else {
            d = GF2Polynomial.mult64(a1, b1);
            result[5] = result[5] ^ d[3];
            result[4] = result[4] ^ d[2];
            result[3] = result[3] ^ d[1];
            result[2] = result[2] ^ d[0];
        }
        if (a0[1] == 0 && b0[1] == 0) {
            e = GF2Polynomial.mult32(a0[0], b0[0]);
            result[3] = result[3] ^ e[1];
            result[2] = result[2] ^ e[0];
            result[1] = result[1] ^ e[1];
            result[0] = result[0] ^ e[0];
        } else {
            e = GF2Polynomial.mult64(a0, b0);
            result[5] = result[5] ^ e[3];
            result[4] = result[4] ^ e[2];
            result[3] = result[3] ^ (e[1] ^ e[3]);
            result[2] = result[2] ^ (e[0] ^ e[2]);
            result[1] = result[1] ^ e[1];
            result[0] = result[0] ^ e[0];
        }
        return result;
    }

    private static int[] mult64(int[] a, int[] b) {
        int[] result = new int[4];
        int a0 = a[0];
        int a1 = 0;
        if (a.length > 1) {
            a1 = a[1];
        }
        int b0 = b[0];
        int b1 = 0;
        if (b.length > 1) {
            b1 = b[1];
        }
        if (a1 != 0 || b1 != 0) {
            int[] c = GF2Polynomial.mult32(a1, b1);
            result[3] = result[3] ^ c[1];
            result[2] = result[2] ^ (c[0] ^ c[1]);
            result[1] = result[1] ^ c[0];
        }
        int[] d = GF2Polynomial.mult32(a0 ^ a1, b0 ^ b1);
        result[2] = result[2] ^ d[1];
        result[1] = result[1] ^ d[0];
        int[] e = GF2Polynomial.mult32(a0, b0);
        result[2] = result[2] ^ e[1];
        result[1] = result[1] ^ (e[0] ^ e[1]);
        result[0] = result[0] ^ e[0];
        return result;
    }

    private static int[] mult32(int a, int b) {
        int[] result = new int[2];
        if (a == 0 || b == 0) {
            return result;
        }
        long b2 = b;
        b2 &= 0xFFFFFFFFL;
        long h = 0L;
        int i = 1;
        while (i <= 32) {
            if ((a & bitMask[i - 1]) != 0) {
                h ^= b2;
            }
            b2 <<= 1;
            ++i;
        }
        result[1] = (int)(h >>> 32);
        result[0] = (int)(h & 0xFFFFFFFFL);
        return result;
    }

    private GF2Polynomial upper(int k) {
        int j = Math.min(k, this.blocks - k);
        GF2Polynomial result = new GF2Polynomial(j << 5);
        if (this.blocks >= k) {
            System.arraycopy(this.value, k, result.value, 0, j);
        }
        return result;
    }

    private GF2Polynomial lower(int k) {
        GF2Polynomial result = new GF2Polynomial(k << 5);
        System.arraycopy(this.value, 0, result.value, 0, Math.min(k, this.blocks));
        return result;
    }

    public GF2Polynomial remainder(GF2Polynomial g) throws RuntimeException {
        GF2Polynomial a = new GF2Polynomial(this);
        GF2Polynomial b = new GF2Polynomial(g);
        if (b.isZero()) {
            throw new RuntimeException();
        }
        a.reduceN();
        b.reduceN();
        if (a.len < b.len) {
            return a;
        }
        int i = a.len - b.len;
        while (i >= 0) {
            GF2Polynomial j = b.shiftLeft(i);
            a.subtractFromThis(j);
            a.reduceN();
            i = a.len - b.len;
        }
        return a;
    }

    public GF2Polynomial quotient(GF2Polynomial g) throws RuntimeException {
        GF2Polynomial q = new GF2Polynomial(this.len);
        GF2Polynomial a = new GF2Polynomial(this);
        GF2Polynomial b = new GF2Polynomial(g);
        if (b.isZero()) {
            throw new RuntimeException();
        }
        a.reduceN();
        b.reduceN();
        if (a.len < b.len) {
            return new GF2Polynomial(0);
        }
        int i = a.len - b.len;
        q.expandN(i + 1);
        while (i >= 0) {
            GF2Polynomial j = b.shiftLeft(i);
            a.subtractFromThis(j);
            a.reduceN();
            q.xorBit(i);
            i = a.len - b.len;
        }
        return q;
    }

    public GF2Polynomial[] divide(GF2Polynomial g) throws RuntimeException {
        GF2Polynomial[] result = new GF2Polynomial[2];
        GF2Polynomial q = new GF2Polynomial(this.len);
        GF2Polynomial a = new GF2Polynomial(this);
        GF2Polynomial b = new GF2Polynomial(g);
        if (b.isZero()) {
            throw new RuntimeException();
        }
        a.reduceN();
        b.reduceN();
        if (a.len < b.len) {
            result[0] = new GF2Polynomial(0);
            result[1] = a;
            return result;
        }
        int i = a.len - b.len;
        q.expandN(i + 1);
        while (i >= 0) {
            GF2Polynomial j = b.shiftLeft(i);
            a.subtractFromThis(j);
            a.reduceN();
            q.xorBit(i);
            i = a.len - b.len;
        }
        result[0] = q;
        result[1] = a;
        return result;
    }

    public GF2Polynomial gcd(GF2Polynomial g) throws RuntimeException {
        if (this.isZero() && g.isZero()) {
            throw new ArithmeticException("Both operands of gcd equal zero.");
        }
        if (this.isZero()) {
            return new GF2Polynomial(g);
        }
        if (g.isZero()) {
            return new GF2Polynomial(this);
        }
        GF2Polynomial a = new GF2Polynomial(this);
        GF2Polynomial b = new GF2Polynomial(g);
        while (!b.isZero()) {
            GF2Polynomial c = a.remainder(b);
            a = b;
            b = c;
        }
        return a;
    }

    public boolean isIrreducible() {
        if (this.isZero()) {
            return false;
        }
        GF2Polynomial f = new GF2Polynomial(this);
        f.reduceN();
        int d = f.len - 1;
        GF2Polynomial u = new GF2Polynomial(f.len, "X");
        int i = 1;
        while (i <= d >> 1) {
            u.squareThisPreCalc();
            u = u.remainder(f);
            GF2Polynomial dummy = u.add(new GF2Polynomial(32, "X"));
            if (!dummy.isZero()) {
                GF2Polynomial g = f.gcd(dummy);
                if (!g.isOne()) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    void reduceTrinomial(int m, int tc) {
        long t;
        int p0 = m >>> 5;
        int q0 = 32 - (m & 0x1F);
        int p1 = m - tc >>> 5;
        int q1 = 32 - (m - tc & 0x1F);
        int max = (m << 1) - 2 >>> 5;
        int min = p0;
        int i = max;
        while (i > min) {
            t = (long)this.value[i] & 0xFFFFFFFFL;
            int n = i - p0 - 1;
            this.value[n] = this.value[n] ^ (int)(t << q0);
            int n2 = i - p0;
            this.value[n2] = (int)((long)this.value[n2] ^ t >>> 32 - q0);
            int n3 = i - p1 - 1;
            this.value[n3] = this.value[n3] ^ (int)(t << q1);
            int n4 = i - p1;
            this.value[n4] = (int)((long)this.value[n4] ^ t >>> 32 - q1);
            this.value[i] = 0;
            --i;
        }
        t = (long)this.value[min] & 0xFFFFFFFFL & 0xFFFFFFFFL << (m & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ t >>> 32 - q0);
        if (min - p1 - 1 >= 0) {
            int n = min - p1 - 1;
            this.value[n] = this.value[n] ^ (int)(t << q1);
        }
        int n = min - p1;
        this.value[n] = (int)((long)this.value[n] ^ t >>> 32 - q1);
        int n5 = min;
        this.value[n5] = this.value[n5] & reverseRightMask[m & 0x1F];
        this.blocks = (m - 1 >>> 5) + 1;
        this.len = m;
    }

    void reducePentanomial(int m, int[] pc) {
        long t;
        int p0 = m >>> 5;
        int q0 = 32 - (m & 0x1F);
        int p1 = m - pc[0] >>> 5;
        int q1 = 32 - (m - pc[0] & 0x1F);
        int p2 = m - pc[1] >>> 5;
        int q2 = 32 - (m - pc[1] & 0x1F);
        int p3 = m - pc[2] >>> 5;
        int q3 = 32 - (m - pc[2] & 0x1F);
        int max = (m << 1) - 2 >>> 5;
        int min = p0;
        int i = max;
        while (i > min) {
            t = (long)this.value[i] & 0xFFFFFFFFL;
            int n = i - p0 - 1;
            this.value[n] = this.value[n] ^ (int)(t << q0);
            int n2 = i - p0;
            this.value[n2] = (int)((long)this.value[n2] ^ t >>> 32 - q0);
            int n3 = i - p1 - 1;
            this.value[n3] = this.value[n3] ^ (int)(t << q1);
            int n4 = i - p1;
            this.value[n4] = (int)((long)this.value[n4] ^ t >>> 32 - q1);
            int n5 = i - p2 - 1;
            this.value[n5] = this.value[n5] ^ (int)(t << q2);
            int n6 = i - p2;
            this.value[n6] = (int)((long)this.value[n6] ^ t >>> 32 - q2);
            int n7 = i - p3 - 1;
            this.value[n7] = this.value[n7] ^ (int)(t << q3);
            int n8 = i - p3;
            this.value[n8] = (int)((long)this.value[n8] ^ t >>> 32 - q3);
            this.value[i] = 0;
            --i;
        }
        t = (long)this.value[min] & 0xFFFFFFFFL & 0xFFFFFFFFL << (m & 0x1F);
        this.value[0] = (int)((long)this.value[0] ^ t >>> 32 - q0);
        if (min - p1 - 1 >= 0) {
            int n = min - p1 - 1;
            this.value[n] = this.value[n] ^ (int)(t << q1);
        }
        int n = min - p1;
        this.value[n] = (int)((long)this.value[n] ^ t >>> 32 - q1);
        if (min - p2 - 1 >= 0) {
            int n9 = min - p2 - 1;
            this.value[n9] = this.value[n9] ^ (int)(t << q2);
        }
        int n10 = min - p2;
        this.value[n10] = (int)((long)this.value[n10] ^ t >>> 32 - q2);
        if (min - p3 - 1 >= 0) {
            int n11 = min - p3 - 1;
            this.value[n11] = this.value[n11] ^ (int)(t << q3);
        }
        int n12 = min - p3;
        this.value[n12] = (int)((long)this.value[n12] ^ t >>> 32 - q3);
        int n13 = min;
        this.value[n13] = this.value[n13] & reverseRightMask[m & 0x1F];
        this.blocks = (m - 1 >>> 5) + 1;
        this.len = m;
    }

    public void reduceN() {
        int i = this.blocks - 1;
        while (this.value[i] == 0 && i > 0) {
            --i;
        }
        int h = this.value[i];
        int j = 0;
        while (h != 0) {
            h >>>= 1;
            ++j;
        }
        this.len = (i << 5) + j;
        this.blocks = i + 1;
    }

    public void expandN(int i) {
        if (this.len >= i) {
            return;
        }
        this.len = i;
        int k = (i - 1 >>> 5) + 1;
        if (this.blocks >= k) {
            return;
        }
        if (this.value.length >= k) {
            int j = this.blocks;
            while (j < k) {
                this.value[j] = 0;
                ++j;
            }
            this.blocks = k;
            return;
        }
        int[] bs = new int[k];
        System.arraycopy(this.value, 0, bs, 0, this.blocks);
        this.blocks = k;
        this.value = null;
        this.value = bs;
    }

    public void squareThisBitwise() {
        if (this.isZero()) {
            return;
        }
        int[] result = new int[this.blocks << 1];
        int i = this.blocks - 1;
        while (i >= 0) {
            int h = this.value[i];
            int j = 1;
            int k = 0;
            while (k < 16) {
                if ((h & 1) != 0) {
                    int n = i << 1;
                    result[n] = result[n] | j;
                }
                if ((h & 0x10000) != 0) {
                    int n = (i << 1) + 1;
                    result[n] = result[n] | j;
                }
                j <<= 2;
                h >>>= 1;
                ++k;
            }
            --i;
        }
        this.value = null;
        this.value = result;
        this.blocks = result.length;
        this.len = (this.len << 1) - 1;
    }

    public void squareThisPreCalc() {
        if (this.isZero()) {
            return;
        }
        if (this.value.length >= this.blocks << 1) {
            int i = this.blocks - 1;
            while (i >= 0) {
                this.value[(i << 1) + 1] = squaringTable[(this.value[i] & 0xFF0000) >>> 16] | squaringTable[(this.value[i] & 0xFF000000) >>> 24] << 16;
                this.value[i << 1] = squaringTable[this.value[i] & 0xFF] | squaringTable[(this.value[i] & 0xFF00) >>> 8] << 16;
                --i;
            }
            this.blocks <<= 1;
            this.len = (this.len << 1) - 1;
        } else {
            int[] result = new int[this.blocks << 1];
            int i = 0;
            while (i < this.blocks) {
                result[i << 1] = squaringTable[this.value[i] & 0xFF] | squaringTable[(this.value[i] & 0xFF00) >>> 8] << 16;
                result[(i << 1) + 1] = squaringTable[(this.value[i] & 0xFF0000) >>> 16] | squaringTable[(this.value[i] & 0xFF000000) >>> 24] << 16;
                ++i;
            }
            this.value = null;
            this.value = result;
            this.blocks <<= 1;
            this.len = (this.len << 1) - 1;
        }
    }

    public boolean vectorMult(GF2Polynomial b) throws RuntimeException {
        boolean result = false;
        if (this.len != b.len) {
            throw new RuntimeException();
        }
        int i = 0;
        while (i < this.blocks) {
            int h = this.value[i] & b.value[i];
            result ^= parity[h & 0xFF];
            result ^= parity[h >>> 8 & 0xFF];
            result ^= parity[h >>> 16 & 0xFF];
            result ^= parity[h >>> 24 & 0xFF];
            ++i;
        }
        return result;
    }

    public GF2Polynomial xor(GF2Polynomial b) {
        GF2Polynomial result;
        int k = Math.min(this.blocks, b.blocks);
        if (this.len >= b.len) {
            result = new GF2Polynomial(this);
            int i = 0;
            while (i < k) {
                int n = i;
                result.value[n] = result.value[n] ^ b.value[i];
                ++i;
            }
        } else {
            result = new GF2Polynomial(b);
            int i = 0;
            while (i < k) {
                int n = i;
                result.value[n] = result.value[n] ^ this.value[i];
                ++i;
            }
        }
        result.zeroUnusedBits();
        return result;
    }

    public void xorThisBy(GF2Polynomial b) {
        int i = 0;
        while (i < Math.min(this.blocks, b.blocks)) {
            int n = i;
            this.value[n] = this.value[n] ^ b.value[i];
            ++i;
        }
        this.zeroUnusedBits();
    }

    private void zeroUnusedBits() {
        if ((this.len & 0x1F) != 0) {
            int n = this.blocks - 1;
            this.value[n] = this.value[n] & reverseRightMask[this.len & 0x1F];
        }
    }

    public void setBit(int i) throws RuntimeException {
        if (i < 0 || i > this.len - 1) {
            throw new RuntimeException();
        }
        if (i > this.len - 1) {
            return;
        }
        int n = i >>> 5;
        this.value[n] = this.value[n] | bitMask[i & 0x1F];
    }

    public int getBit(int i) {
        if (i < 0 || i > this.len - 1) {
            return 0;
        }
        return (this.value[i >>> 5] & bitMask[i & 0x1F]) != 0 ? 1 : 0;
    }

    public void resetBit(int i) throws RuntimeException {
        if (i < 0 || i > this.len - 1) {
            throw new RuntimeException();
        }
        if (i > this.len - 1) {
            return;
        }
        int n = i >>> 5;
        this.value[n] = this.value[n] & ~bitMask[i & 0x1F];
    }

    public void xorBit(int i) throws RuntimeException {
        if (i < 0 || i > this.len - 1) {
            throw new RuntimeException();
        }
        if (i > this.len - 1) {
            return;
        }
        int n = i >>> 5;
        this.value[n] = this.value[n] ^ bitMask[i & 0x1F];
    }

    public boolean testBit(int i) {
        if (i < 0 || i > this.len - 1) {
            return false;
        }
        return (this.value[i >>> 5] & bitMask[i & 0x1F]) != 0;
    }

    public GF2Polynomial shiftLeft() {
        GF2Polynomial result = new GF2Polynomial(this.len + 1, this.value);
        int i = result.blocks - 1;
        while (i >= 1) {
            int n = i;
            result.value[n] = result.value[n] << 1;
            int n2 = i;
            result.value[n2] = result.value[n2] | result.value[i - 1] >>> 31;
            --i;
        }
        result.value[0] = result.value[0] << 1;
        return result;
    }

    public void shiftLeftThis() {
        if ((this.len & 0x1F) == 0) {
            ++this.len;
            ++this.blocks;
            if (this.blocks > this.value.length) {
                int[] bs = new int[this.blocks];
                System.arraycopy(this.value, 0, bs, 0, this.value.length);
                this.value = null;
                this.value = bs;
            }
            int i = this.blocks - 1;
            while (i >= 1) {
                int n = i;
                this.value[n] = this.value[n] | this.value[i - 1] >>> 31;
                int n2 = i - 1;
                this.value[n2] = this.value[n2] << 1;
                --i;
            }
        } else {
            ++this.len;
            int i = this.blocks - 1;
            while (i >= 1) {
                int n = i;
                this.value[n] = this.value[n] << 1;
                int n3 = i;
                this.value[n3] = this.value[n3] | this.value[i - 1] >>> 31;
                --i;
            }
            this.value[0] = this.value[0] << 1;
        }
    }

    public GF2Polynomial shiftLeft(int k) {
        int remaining;
        GF2Polynomial result = new GF2Polynomial(this.len + k, this.value);
        if (k >= 32) {
            result.doShiftBlocksLeft(k >>> 5);
        }
        if ((remaining = k & 0x1F) != 0) {
            int i = result.blocks - 1;
            while (i >= 1) {
                int n = i;
                result.value[n] = result.value[n] << remaining;
                int n2 = i;
                result.value[n2] = result.value[n2] | result.value[i - 1] >>> 32 - remaining;
                --i;
            }
            result.value[0] = result.value[0] << remaining;
        }
        return result;
    }

    public void shiftLeftAddThis(GF2Polynomial b, int k) {
        if (k == 0) {
            this.addToThis(b);
            return;
        }
        this.expandN(b.len + k);
        int d = k >>> 5;
        int i = b.blocks - 1;
        while (i >= 0) {
            if (i + d + 1 < this.blocks && (k & 0x1F) != 0) {
                int n = i + d + 1;
                this.value[n] = this.value[n] ^ b.value[i] >>> 32 - (k & 0x1F);
            }
            int n = i + d;
            this.value[n] = this.value[n] ^ b.value[i] << (k & 0x1F);
            --i;
        }
    }

    void shiftBlocksLeft() {
        ++this.blocks;
        this.len += 32;
        if (this.blocks <= this.value.length) {
            int i = this.blocks - 1;
            while (i >= 1) {
                this.value[i] = this.value[i - 1];
                --i;
            }
            this.value[0] = 0;
        } else {
            int[] result = new int[this.blocks];
            System.arraycopy(this.value, 0, result, 1, this.blocks - 1);
            this.value = null;
            this.value = result;
        }
    }

    private void doShiftBlocksLeft(int b) {
        if (this.blocks <= this.value.length) {
            int i = this.blocks - 1;
            while (i >= b) {
                this.value[i] = this.value[i - b];
                --i;
            }
            i = 0;
            while (i < b) {
                this.value[i] = 0;
                ++i;
            }
        } else {
            int[] result = new int[this.blocks];
            System.arraycopy(this.value, 0, result, b, this.blocks - b);
            this.value = null;
            this.value = result;
        }
    }

    public GF2Polynomial shiftRight() {
        GF2Polynomial result = new GF2Polynomial(this.len - 1);
        System.arraycopy(this.value, 0, result.value, 0, result.blocks);
        int i = 0;
        while (i <= result.blocks - 2) {
            int n = i;
            result.value[n] = result.value[n] >>> 1;
            int n2 = i;
            result.value[n2] = result.value[n2] | result.value[i + 1] << 31;
            ++i;
        }
        int n = result.blocks - 1;
        result.value[n] = result.value[n] >>> 1;
        if (result.blocks < this.blocks) {
            int n3 = result.blocks - 1;
            result.value[n3] = result.value[n3] | this.value[result.blocks] << 31;
        }
        return result;
    }

    public void shiftRightThis() {
        --this.len;
        this.blocks = (this.len - 1 >>> 5) + 1;
        int i = 0;
        while (i <= this.blocks - 2) {
            int n = i;
            this.value[n] = this.value[n] >>> 1;
            int n2 = i;
            this.value[n2] = this.value[n2] | this.value[i + 1] << 31;
            ++i;
        }
        int n = this.blocks - 1;
        this.value[n] = this.value[n] >>> 1;
        if ((this.len & 0x1F) == 0) {
            int n3 = this.blocks - 1;
            this.value[n3] = this.value[n3] | this.value[this.blocks] << 31;
        }
    }
}

