/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial;

import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.Constants;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.IntegerPolynomial;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;

public class BigIntPolynomial {
    private static final double LOG_10_2 = Math.log10(2.0);
    BigInteger[] coeffs;

    BigIntPolynomial(int N) {
        this.coeffs = new BigInteger[N];
        int i = 0;
        while (i < N) {
            this.coeffs[i] = Constants.BIGINT_ZERO;
            ++i;
        }
    }

    BigIntPolynomial(BigInteger[] coeffs) {
        this.coeffs = coeffs;
    }

    public BigIntPolynomial(IntegerPolynomial p) {
        this.coeffs = new BigInteger[p.coeffs.length];
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = BigInteger.valueOf(p.coeffs[i]);
            ++i;
        }
    }

    static BigIntPolynomial generateRandomSmall(int N, int numOnes, int numNegOnes) {
        ArrayList<BigInteger> coeffs = new ArrayList<BigInteger>();
        int i = 0;
        while (i < numOnes) {
            coeffs.add(Constants.BIGINT_ONE);
            ++i;
        }
        i = 0;
        while (i < numNegOnes) {
            coeffs.add(BigInteger.valueOf(-1L));
            ++i;
        }
        while (coeffs.size() < N) {
            coeffs.add(Constants.BIGINT_ZERO);
        }
        Collections.shuffle(coeffs, new SecureRandom());
        BigIntPolynomial poly = new BigIntPolynomial(N);
        int i2 = 0;
        while (i2 < coeffs.size()) {
            poly.coeffs[i2] = (BigInteger)coeffs.get(i2);
            ++i2;
        }
        return poly;
    }

    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int N = this.coeffs.length;
        if (poly2.coeffs.length != N) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigIntPolynomial c = this.multRecursive(poly2);
        if (c.coeffs.length > N) {
            int k = N;
            while (k < c.coeffs.length) {
                c.coeffs[k - N] = c.coeffs[k - N].add(c.coeffs[k]);
                ++k;
            }
            c.coeffs = Arrays.copyOf(c.coeffs, N);
        }
        return c;
    }

    private BigIntPolynomial multRecursive(BigIntPolynomial poly2) {
        BigInteger[] a = this.coeffs;
        BigInteger[] b = poly2.coeffs;
        int n = poly2.coeffs.length;
        if (n <= 1) {
            BigInteger[] c = Arrays.clone(this.coeffs);
            int i = 0;
            while (i < this.coeffs.length) {
                c[i] = c[i].multiply(poly2.coeffs[0]);
                ++i;
            }
            return new BigIntPolynomial(c);
        }
        int n1 = n / 2;
        BigIntPolynomial a1 = new BigIntPolynomial(Arrays.copyOf(a, n1));
        BigIntPolynomial a2 = new BigIntPolynomial(Arrays.copyOfRange(a, n1, n));
        BigIntPolynomial b1 = new BigIntPolynomial(Arrays.copyOf(b, n1));
        BigIntPolynomial b2 = new BigIntPolynomial(Arrays.copyOfRange(b, n1, n));
        BigIntPolynomial A = (BigIntPolynomial)a1.clone();
        A.add(a2);
        BigIntPolynomial B = (BigIntPolynomial)b1.clone();
        B.add(b2);
        BigIntPolynomial c1 = a1.multRecursive(b1);
        BigIntPolynomial c2 = a2.multRecursive(b2);
        BigIntPolynomial c3 = A.multRecursive(B);
        c3.sub(c1);
        c3.sub(c2);
        BigIntPolynomial c = new BigIntPolynomial(2 * n - 1);
        int i = 0;
        while (i < c1.coeffs.length) {
            c.coeffs[i] = c1.coeffs[i];
            ++i;
        }
        i = 0;
        while (i < c3.coeffs.length) {
            c.coeffs[n1 + i] = c.coeffs[n1 + i].add(c3.coeffs[i]);
            ++i;
        }
        i = 0;
        while (i < c2.coeffs.length) {
            c.coeffs[2 * n1 + i] = c.coeffs[2 * n1 + i].add(c2.coeffs[i]);
            ++i;
        }
        return c;
    }

    void add(BigIntPolynomial b, BigInteger modulus) {
        this.add(b);
        this.mod(modulus);
    }

    public void add(BigIntPolynomial b) {
        if (b.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
            int i = N;
            while (i < this.coeffs.length) {
                this.coeffs[i] = Constants.BIGINT_ZERO;
                ++i;
            }
        }
        int i = 0;
        while (i < b.coeffs.length) {
            this.coeffs[i] = this.coeffs[i].add(b.coeffs[i]);
            ++i;
        }
    }

    public void sub(BigIntPolynomial b) {
        if (b.coeffs.length > this.coeffs.length) {
            int N = this.coeffs.length;
            this.coeffs = Arrays.copyOf(this.coeffs, b.coeffs.length);
            int i = N;
            while (i < this.coeffs.length) {
                this.coeffs[i] = Constants.BIGINT_ZERO;
                ++i;
            }
        }
        int i = 0;
        while (i < b.coeffs.length) {
            this.coeffs[i] = this.coeffs[i].subtract(b.coeffs[i]);
            ++i;
        }
    }

    public void mult(BigInteger factor) {
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = this.coeffs[i].multiply(factor);
            ++i;
        }
    }

    void mult(int factor) {
        this.mult(BigInteger.valueOf(factor));
    }

    public void div(BigInteger divisor) {
        BigInteger d = divisor.add(Constants.BIGINT_ONE).divide(BigInteger.valueOf(2L));
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = this.coeffs[i].compareTo(Constants.BIGINT_ZERO) > 0 ? this.coeffs[i].add(d) : this.coeffs[i].add(d.negate());
            this.coeffs[i] = this.coeffs[i].divide(divisor);
            ++i;
        }
    }

    public BigDecimalPolynomial div(BigDecimal divisor, int decimalPlaces) {
        BigInteger max = this.maxCoeffAbs();
        int coeffLength = (int)((double)max.bitLength() * LOG_10_2) + 1;
        BigDecimal factor = Constants.BIGDEC_ONE.divide(divisor, coeffLength + decimalPlaces + 1, 6);
        BigDecimalPolynomial p = new BigDecimalPolynomial(this.coeffs.length);
        int i = 0;
        while (i < this.coeffs.length) {
            p.coeffs[i] = new BigDecimal(this.coeffs[i]).multiply(factor).setScale(decimalPlaces, 6);
            ++i;
        }
        return p;
    }

    public int getMaxCoeffLength() {
        return (int)((double)this.maxCoeffAbs().bitLength() * LOG_10_2) + 1;
    }

    private BigInteger maxCoeffAbs() {
        BigInteger max = this.coeffs[0].abs();
        int i = 1;
        while (i < this.coeffs.length) {
            BigInteger coeff = this.coeffs[i].abs();
            if (coeff.compareTo(max) > 0) {
                max = coeff;
            }
            ++i;
        }
        return max;
    }

    public void mod(BigInteger modulus) {
        int i = 0;
        while (i < this.coeffs.length) {
            this.coeffs[i] = this.coeffs[i].mod(modulus);
            ++i;
        }
    }

    BigInteger sumCoeffs() {
        BigInteger sum = Constants.BIGINT_ZERO;
        int i = 0;
        while (i < this.coeffs.length) {
            sum = sum.add(this.coeffs[i]);
            ++i;
        }
        return sum;
    }

    public Object clone() {
        return new BigIntPolynomial((BigInteger[])this.coeffs.clone());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.coeffs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BigIntPolynomial other = (BigIntPolynomial)obj;
        return Arrays.areEqual(this.coeffs, other.coeffs);
    }

    public BigInteger[] getCoeffs() {
        return Arrays.clone(this.coeffs);
    }
}

