/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.math.ntru.util;

import cn.org.bjca.mssp.msspjce.pqc.math.ntru.util.Util;
import cn.org.bjca.mssp.msspjce.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class ArrayEncoder {
    private static final int[] COEFF1_TABLE;
    private static final int[] COEFF2_TABLE;
    private static final int[] BIT1_TABLE;
    private static final int[] BIT2_TABLE;
    private static final int[] BIT3_TABLE;

    static {
        int[] nArray = new int[8];
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = -1;
        nArray[7] = -1;
        COEFF1_TABLE = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 1;
        nArray2[2] = -1;
        nArray2[4] = 1;
        nArray2[5] = -1;
        nArray2[7] = 1;
        COEFF2_TABLE = nArray2;
        int[] nArray3 = new int[9];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[6] = 1;
        nArray3[8] = 1;
        BIT1_TABLE = nArray3;
        int[] nArray4 = new int[9];
        nArray4[0] = 1;
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[7] = 1;
        BIT2_TABLE = nArray4;
        int[] nArray5 = new int[9];
        nArray5[0] = 1;
        nArray5[2] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        BIT3_TABLE = nArray5;
    }

    public static byte[] encodeModQ(int[] a, int q) {
        int bitsPerCoeff = 31 - Integer.numberOfLeadingZeros(q);
        int numBits = a.length * bitsPerCoeff;
        int numBytes = (numBits + 7) / 8;
        byte[] data = new byte[numBytes];
        int bitIndex = 0;
        int byteIndex = 0;
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < bitsPerCoeff) {
                int currentBit = a[i] >> j & 1;
                int n = byteIndex++;
                data[n] = (byte)(data[n] | currentBit << bitIndex);
                bitIndex = bitIndex == 7 ? 0 : ++bitIndex;
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static int[] decodeModQ(byte[] data, int N, int q) {
        int[] coeffs = new int[N];
        int bitsPerCoeff = 31 - Integer.numberOfLeadingZeros(q);
        int numBits = N * bitsPerCoeff;
        int coeffIndex = 0;
        int bitIndex = 0;
        while (bitIndex < numBits) {
            if (bitIndex <= 0 || bitIndex % bitsPerCoeff == 0) {
                // empty if block
            }
            int bit = ArrayEncoder.getBit(data, bitIndex);
            int n = ++coeffIndex;
            coeffs[n] = coeffs[n] + (bit << bitIndex % bitsPerCoeff);
            ++bitIndex;
        }
        return coeffs;
    }

    public static int[] decodeModQ(InputStream is, int N, int q) throws IOException {
        int qBits = 31 - Integer.numberOfLeadingZeros(q);
        int size = (N * qBits + 7) / 8;
        byte[] arr = Util.readFullLength(is, size);
        return ArrayEncoder.decodeModQ(arr, N, q);
    }

    public static int[] decodeMod3Sves(byte[] data, int N) {
        int[] coeffs = new int[N];
        int coeffIndex = 0;
        int bitIndex = 0;
        while (bitIndex < data.length * 8) {
            int bit1 = ArrayEncoder.getBit(data, bitIndex++);
            int bit2 = ArrayEncoder.getBit(data, bitIndex++);
            int bit3 = ArrayEncoder.getBit(data, bitIndex++);
            int coeffTableIndex = bit1 * 4 + bit2 * 2 + bit3;
            coeffs[coeffIndex++] = COEFF1_TABLE[coeffTableIndex];
            coeffs[coeffIndex++] = COEFF2_TABLE[coeffTableIndex];
            if (coeffIndex > N - 2) break;
        }
        return coeffs;
    }

    public static byte[] encodeMod3Sves(int[] arr) {
        int numBits = (arr.length * 3 + 1) / 2;
        int numBytes = (numBits + 7) / 8;
        byte[] data = new byte[numBytes];
        int bitIndex = 0;
        int byteIndex = 0;
        int i = 0;
        while (i < arr.length / 2 * 2) {
            int coeff1 = arr[i++] + 1;
            int coeff2 = arr[i++] + 1;
            if (coeff1 == 0 && coeff2 == 0) {
                throw new IllegalStateException("Illegal encoding!");
            }
            int bitTableIndex = coeff1 * 3 + coeff2;
            int[] bits = new int[]{BIT1_TABLE[bitTableIndex], BIT2_TABLE[bitTableIndex], BIT3_TABLE[bitTableIndex]};
            int j = 0;
            while (j < 3) {
                int n = byteIndex++;
                data[n] = (byte)(data[n] | bits[j] << bitIndex);
                bitIndex = bitIndex == 7 ? 0 : ++bitIndex;
                ++j;
            }
        }
        return data;
    }

    public static byte[] encodeMod3Tight(int[] intArray) {
        BigInteger sum = BigInteger.ZERO;
        int i = intArray.length - 1;
        while (i >= 0) {
            sum = sum.multiply(BigInteger.valueOf(3L));
            sum = sum.add(BigInteger.valueOf(intArray[i] + 1));
            --i;
        }
        int size = (BigInteger.valueOf(3L).pow(intArray.length).bitLength() + 7) / 8;
        byte[] arr = sum.toByteArray();
        if (arr.length < size) {
            byte[] arr2 = new byte[size];
            System.arraycopy(arr, 0, arr2, size - arr.length, arr.length);
            return arr2;
        }
        if (arr.length > size) {
            arr = Arrays.copyOfRange(arr, 1, arr.length);
        }
        return arr;
    }

    public static int[] decodeMod3Tight(byte[] b, int N) {
        BigInteger sum = new BigInteger(1, b);
        int[] coeffs = new int[N];
        int i = 0;
        while (i < N) {
            coeffs[i] = sum.mod(BigInteger.valueOf(3L)).intValue() - 1;
            if (coeffs[i] > 1) {
                int n = i;
                coeffs[n] = coeffs[n] - 3;
            }
            sum = sum.divide(BigInteger.valueOf(3L));
            ++i;
        }
        return coeffs;
    }

    public static int[] decodeMod3Tight(InputStream is, int N) throws IOException {
        int size = (int)Math.ceil((double)N * Math.log(3.0) / Math.log(2.0) / 8.0);
        byte[] arr = Util.readFullLength(is, size);
        return ArrayEncoder.decodeMod3Tight(arr, N);
    }

    private static int getBit(byte[] arr, int bitIndex) {
        int byteIndex = bitIndex / 8;
        int arrElem = arr[byteIndex] & 0xFF;
        return arrElem >> bitIndex % 8 & 1;
    }
}

