/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.pqc.math.ntru.util;

import cn.org.bjca.mssp.msspjce.pqc.math.ntru.euclid.IntEuclidean;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import cn.org.bjca.mssp.msspjce.pqc.math.ntru.polynomial.TernaryPolynomial;
import cn.org.bjca.mssp.msspjce.util.Integers;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;

public class Util {
    private static volatile boolean IS_64_BITNESS_KNOWN;
    private static volatile boolean IS_64_BIT_JVM;

    public static int invert(int n, int modulus) {
        if ((n %= modulus) < 0) {
            n += modulus;
        }
        return IntEuclidean.calculate((int)n, (int)modulus).x;
    }

    public static int pow(int a, int b, int modulus) {
        int p = 1;
        int i = 0;
        while (i < b) {
            p = p * a % modulus;
            ++i;
        }
        return p;
    }

    public static long pow(long a, int b, long modulus) {
        long p = 1L;
        int i = 0;
        while (i < b) {
            p = p * a % modulus;
            ++i;
        }
        return p;
    }

    public static TernaryPolynomial generateRandomTernary(int N, int numOnes, int numNegOnes, boolean sparse, SecureRandom random) {
        if (sparse) {
            return SparseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
        }
        return DenseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
    }

    public static int[] generateRandomTernary(int N, int numOnes, int numNegOnes, SecureRandom random) {
        Integer one = Integers.valueOf(1);
        Integer minusOne = Integers.valueOf(-1);
        Integer zero = Integers.valueOf(0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < numOnes) {
            list.add(one);
            ++i;
        }
        i = 0;
        while (i < numNegOnes) {
            list.add(minusOne);
            ++i;
        }
        while (list.size() < N) {
            list.add(zero);
        }
        Collections.shuffle(list, random);
        int[] arr = new int[N];
        int i2 = 0;
        while (i2 < N) {
            arr[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return arr;
    }

    public static boolean is64BitJVM() {
        if (!IS_64_BITNESS_KNOWN) {
            String arch = System.getProperty("os.arch");
            String sunModel = System.getProperty("sun.arch.data.model");
            IS_64_BIT_JVM = "amd64".equals(arch) || "x86_64".equals(arch) || "ppc64".equals(arch) || "64".equals(sunModel);
            IS_64_BITNESS_KNOWN = true;
        }
        return IS_64_BIT_JVM;
    }

    public static byte[] readFullLength(InputStream is, int length) throws IOException {
        byte[] arr = new byte[length];
        if (is.read(arr) != arr.length) {
            throw new IOException("Not enough bytes to read.");
        }
        return arr;
    }
}

