/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.mssp.msspjce.x509;

import cn.org.bjca.mssp.msspjce.asn1.ASN1Encodable;
import cn.org.bjca.mssp.msspjce.asn1.ASN1InputStream;
import cn.org.bjca.mssp.msspjce.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.ASN1OctetString;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Primitive;
import cn.org.bjca.mssp.msspjce.asn1.ASN1Sequence;
import cn.org.bjca.mssp.msspjce.asn1.ASN1TaggedObject;
import cn.org.bjca.mssp.msspjce.asn1.DEREnumerated;
import cn.org.bjca.mssp.msspjce.asn1.DERIA5String;
import cn.org.bjca.mssp.msspjce.asn1.DERInteger;
import cn.org.bjca.mssp.msspjce.asn1.DERObjectIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.DEROctetString;
import cn.org.bjca.mssp.msspjce.asn1.x509.AccessDescription;
import cn.org.bjca.mssp.msspjce.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.x509.AuthorityInformationAccess;
import cn.org.bjca.mssp.msspjce.asn1.x509.AuthorityKeyIdentifier;
import cn.org.bjca.mssp.msspjce.asn1.x509.BasicConstraints;
import cn.org.bjca.mssp.msspjce.asn1.x509.CRLDistPoint;
import cn.org.bjca.mssp.msspjce.asn1.x509.DistributionPoint;
import cn.org.bjca.mssp.msspjce.asn1.x509.DistributionPointName;
import cn.org.bjca.mssp.msspjce.asn1.x509.GeneralName;
import cn.org.bjca.mssp.msspjce.asn1.x509.GeneralNames;
import cn.org.bjca.mssp.msspjce.asn1.x509.GeneralSubtree;
import cn.org.bjca.mssp.msspjce.asn1.x509.IssuingDistributionPoint;
import cn.org.bjca.mssp.msspjce.asn1.x509.NameConstraints;
import cn.org.bjca.mssp.msspjce.asn1.x509.PolicyInformation;
import cn.org.bjca.mssp.msspjce.asn1.x509.X509Extensions;
import cn.org.bjca.mssp.msspjce.asn1.x509.qualified.Iso4217CurrencyCode;
import cn.org.bjca.mssp.msspjce.asn1.x509.qualified.MonetaryValue;
import cn.org.bjca.mssp.msspjce.asn1.x509.qualified.QCStatement;
import cn.org.bjca.mssp.msspjce.i18n.ErrorBundle;
import cn.org.bjca.mssp.msspjce.i18n.LocaleString;
import cn.org.bjca.mssp.msspjce.i18n.filter.TrustedInput;
import cn.org.bjca.mssp.msspjce.i18n.filter.UntrustedInput;
import cn.org.bjca.mssp.msspjce.i18n.filter.UntrustedUrlInput;
import cn.org.bjca.mssp.msspjce.jce.provider.AnnotatedException;
import cn.org.bjca.mssp.msspjce.jce.provider.CertPathValidatorUtilities;
import cn.org.bjca.mssp.msspjce.jce.provider.PKIXNameConstraintValidator;
import cn.org.bjca.mssp.msspjce.jce.provider.PKIXNameConstraintValidatorException;
import cn.org.bjca.mssp.msspjce.jce.provider.PKIXPolicyNode;
import cn.org.bjca.mssp.msspjce.util.Integers;
import cn.org.bjca.mssp.msspjce.x509.CertPathReviewerException;
import cn.org.bjca.mssp.msspjce.x509.X509CRLStoreSelector;
import cn.org.bjca.mssp.msspjce.x509.extension.X509ExtensionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = X509Extensions.QCStatements.getId();
    private static final String CRL_DIST_POINTS = X509Extensions.CRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = X509Extensions.AuthorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters params) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)params.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate(this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters params) throws CertPathReviewerException {
        this.init(certPath, params);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int index) {
        this.doChecks();
        return this.errors[index + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int index) {
        this.doChecks();
        return this.notifications[index + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean valid = true;
        int i = 0;
        while (i < this.errors.length) {
            if (!this.errors[i].isEmpty()) {
                valid = false;
                break;
            }
            ++i;
        }
        return valid;
    }

    protected void addNotification(ErrorBundle msg) {
        this.notifications[0].add(msg);
    }

    protected void addNotification(ErrorBundle msg, int index) {
        if (index < -1 || index >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[index + 1].add(msg);
    }

    protected void addError(ErrorBundle msg) {
        this.errors[0].add(msg);
    }

    protected void addError(ErrorBundle msg, int index) {
        if (index < -1 || index >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[index + 1].add(msg);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            int i = 0;
            while (i < this.notifications.length) {
                this.notifications[i] = new ArrayList();
                this.errors[i] = new ArrayList();
                ++i;
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        X509Certificate cert = null;
        PKIXNameConstraintValidator nameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            int index = this.certs.size() - 1;
            while (index > 0) {
                ASN1Sequence ncSeq;
                int i = this.n - index;
                cert = (X509Certificate)this.certs.get(index);
                if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                    ASN1Sequence altName;
                    ASN1Sequence dns;
                    X500Principal principal = PKIXCertPathReviewer.getSubjectPrincipal(cert);
                    ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(principal.getEncoded()));
                    try {
                        dns = (ASN1Sequence)aIn.readObject();
                    }
                    catch (IOException e) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(principal)});
                        throw new CertPathReviewerException(msg, (Throwable)e, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkPermittedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    try {
                        nameConstraintValidator.checkExcludedDN(dns);
                    }
                    catch (PKIXNameConstraintValidatorException cpve) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(principal.getName())});
                        throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                    }
                    try {
                        altName = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException ae) {
                        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException(msg, (Throwable)ae, this.certPath, index);
                    }
                    if (altName != null) {
                        int j = 0;
                        while (j < altName.size()) {
                            GeneralName name = GeneralName.getInstance(altName.getObjectAt(j));
                            try {
                                nameConstraintValidator.checkPermitted(name);
                                nameConstraintValidator.checkExcluded(name);
                            }
                            catch (PKIXNameConstraintValidatorException cpve) {
                                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(name)});
                                throw new CertPathReviewerException(msg, (Throwable)cpve, this.certPath, index);
                            }
                            ++j;
                        }
                    }
                }
                try {
                    ncSeq = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException(msg, (Throwable)ae, this.certPath, index);
                }
                if (ncSeq != null) {
                    GeneralSubtree[] excluded;
                    NameConstraints nc = NameConstraints.getInstance(ncSeq);
                    GeneralSubtree[] permitted = nc.getPermittedSubtrees();
                    if (permitted != null) {
                        nameConstraintValidator.intersectPermittedSubtree(permitted);
                    }
                    if ((excluded = nc.getExcludedSubtrees()) != null) {
                        int c = 0;
                        while (c != excluded.length) {
                            nameConstraintValidator.addExcludedSubtree(excluded[c]);
                            ++c;
                        }
                    }
                }
                --index;
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
        }
    }

    private void checkPathLength() {
        int maxPathLength = this.n;
        int totalPathLength = 0;
        X509Certificate cert = null;
        int index = this.certs.size() - 1;
        while (index > 0) {
            int _plc;
            BigInteger _pathLengthConstraint;
            BasicConstraints bc;
            int i = this.n - index;
            cert = (X509Certificate)this.certs.get(index);
            if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                if (maxPathLength <= 0) {
                    ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLenghtExtended");
                    this.addError(msg);
                }
                --maxPathLength;
                ++totalPathLength;
            }
            try {
                bc = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException ae) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(msg, index);
                bc = null;
            }
            if (bc != null && (_pathLengthConstraint = bc.getPathLenConstraint()) != null && (_plc = _pathLengthConstraint.intValue()) < maxPathLength) {
                maxPathLength = _plc;
            }
            --index;
        }
        ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf(totalPathLength)});
        this.addNotification(msg);
    }

    private void checkSignatures() {
        ErrorBundle msg;
        TrustAnchor trust = null;
        X500Principal trustPrincipal = null;
        ErrorBundle msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput(this.validDate), new TrustedInput(new Date())});
        this.addNotification(msg2);
        try {
            X509Certificate cert = (X509Certificate)this.certs.get(this.certs.size() - 1);
            Collection trustColl = this.getTrustAnchors(cert, this.pkixParams.getTrustAnchors());
            if (trustColl.size() > 1) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf(trustColl.size()), new UntrustedInput(cert.getIssuerX500Principal())});
                this.addError(msg);
            } else if (trustColl.isEmpty()) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(cert.getIssuerX500Principal()), Integers.valueOf(this.pkixParams.getTrustAnchors().size())});
                this.addError(msg);
            } else {
                trust = (TrustAnchor)trustColl.iterator().next();
                PublicKey trustPublicKey = trust.getTrustedCert() != null ? trust.getTrustedCert().getPublicKey() : trust.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, trustPublicKey, this.pkixParams.getSigProvider());
                }
                catch (SignatureException e) {
                    ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError(msg3);
                }
                catch (Exception e) {}
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage());
        }
        catch (Throwable t) {
            ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknown", new Object[]{new UntrustedInput(t.getMessage()), new UntrustedInput(t)});
            this.addError(msg4);
        }
        if (trust != null) {
            boolean[] ku;
            X509Certificate sign = trust.getTrustedCert();
            try {
                trustPrincipal = sign != null ? PKIXCertPathReviewer.getSubjectPrincipal(sign) : new X500Principal(trust.getCAName());
            }
            catch (IllegalArgumentException ex) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trust.getCAName())});
                this.addError(msg);
            }
            if (sign != null && (ku = sign.getKeyUsage()) != null && !ku[5]) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustKeyUsage");
                this.addNotification(msg);
            }
        }
        PublicKey workingPublicKey = null;
        X500Principal workingIssuerName = trustPrincipal;
        X509Certificate sign = null;
        AlgorithmIdentifier workingAlgId = null;
        ASN1ObjectIdentifier workingPublicKeyAlgorithm = null;
        ASN1Encodable workingPublicKeyParameters = null;
        if (trust != null) {
            sign = trust.getTrustedCert();
            workingPublicKey = sign != null ? sign.getPublicKey() : trust.getCAPublicKey();
            try {
                workingAlgId = PKIXCertPathReviewer.getAlgorithmIdentifier(workingPublicKey);
                workingPublicKeyAlgorithm = workingAlgId.getObjectId();
                workingPublicKeyParameters = workingAlgId.getParameters();
            }
            catch (CertPathValidatorException ex) {
                ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(msg5);
                workingAlgId = null;
            }
        }
        X509Certificate cert = null;
        int index = this.certs.size() - 1;
        while (index >= 0) {
            ErrorBundle msg6;
            ErrorBundle msg7;
            ErrorBundle msg8;
            int i = this.n - index;
            cert = (X509Certificate)this.certs.get(index);
            if (workingPublicKey != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, workingPublicKey, this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException ex) {
                    msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex.getMessage(), ex, ex.getClass().getName()});
                    this.addError(msg8, index);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued(cert)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(cert, cert.getPublicKey(), this.pkixParams.getSigProvider());
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError(msg7, index);
                }
                catch (GeneralSecurityException ex) {
                    msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{ex.getMessage(), ex, ex.getClass().getName()});
                    this.addError(msg8, index);
                }
            } else {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                byte[] akiBytes = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
                if (akiBytes != null) {
                    try {
                        AuthorityKeyIdentifier aki = AuthorityKeyIdentifier.getInstance(X509ExtensionUtil.fromExtensionValue(akiBytes));
                        GeneralNames issuerNames = aki.getAuthorityCertIssuer();
                        if (issuerNames != null) {
                            GeneralName name = issuerNames.getNames()[0];
                            BigInteger serial = aki.getAuthorityCertSerialNumber();
                            if (serial != null) {
                                Object[] extraArgs = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", name, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", serial};
                                msg7.setExtraArguments(extraArgs);
                            }
                        }
                    }
                    catch (IOException aki) {
                        // empty catch block
                    }
                }
                this.addError(msg7, index);
            }
            try {
                cert.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException cnve) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput(cert.getNotBefore())});
                this.addError(msg8, index);
            }
            catch (CertificateExpiredException cee) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput(cert.getNotAfter())});
                this.addError(msg8, index);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                ErrorBundle msg9;
                CRLDistPoint crlDistPoints = null;
                try {
                    ASN1Primitive crl_dp = PKIXCertPathReviewer.getExtensionValue(cert, CRL_DIST_POINTS);
                    if (crl_dp != null) {
                        crlDistPoints = CRLDistPoint.getInstance(crl_dp);
                    }
                }
                catch (AnnotatedException ae) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPtExtError");
                    this.addError(msg6, index);
                }
                AuthorityInformationAccess authInfoAcc = null;
                try {
                    ASN1Primitive auth_info_acc = PKIXCertPathReviewer.getExtensionValue(cert, AUTH_INFO_ACCESS);
                    if (auth_info_acc != null) {
                        authInfoAcc = AuthorityInformationAccess.getInstance(auth_info_acc);
                    }
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg10 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlAuthInfoAccError");
                    this.addError(msg10, index);
                }
                Vector crlDistPointUrls = this.getCRLDistUrls(crlDistPoints);
                Vector ocspUrls = this.getOCSPUrls(authInfoAcc);
                Iterator urlIt = crlDistPointUrls.iterator();
                while (urlIt.hasNext()) {
                    msg9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(urlIt.next())});
                    this.addNotification(msg9, index);
                }
                urlIt = ocspUrls.iterator();
                while (urlIt.hasNext()) {
                    msg9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(urlIt.next())});
                    this.addNotification(msg9, index);
                }
                try {
                    this.checkRevocation(this.pkixParams, cert, this.validDate, sign, workingPublicKey, crlDistPointUrls, ocspUrls, index);
                }
                catch (CertPathReviewerException cpre) {
                    this.addError(cpre.getErrorMessage(), index);
                }
            }
            if (workingIssuerName != null && !cert.getIssuerX500Principal().equals(workingIssuerName)) {
                msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{workingIssuerName.getName(), cert.getIssuerX500Principal().getName()});
                this.addError(msg7, index);
            }
            if (i != this.n) {
                boolean[] _usage;
                if (cert != null && cert.getVersion() == 1) {
                    msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError(msg7, index);
                }
                try {
                    BasicConstraints bc = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, BASIC_CONSTRAINTS));
                    if (bc != null) {
                        if (!bc.isCA()) {
                            msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError(msg8, index);
                        }
                    } else {
                        msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError(msg8, index);
                    }
                }
                catch (AnnotatedException ae) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError(msg6, index);
                }
                if ((_usage = cert.getKeyUsage()) != null && !_usage[5]) {
                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError(msg6, index);
                }
            }
            sign = cert;
            workingIssuerName = cert.getSubjectX500Principal();
            try {
                workingPublicKey = PKIXCertPathReviewer.getNextWorkingKey(this.certs, index);
                workingAlgId = PKIXCertPathReviewer.getAlgorithmIdentifier(workingPublicKey);
                workingPublicKeyAlgorithm = workingAlgId.getObjectId();
                workingPublicKeyParameters = workingAlgId.getParameters();
            }
            catch (CertPathValidatorException ex) {
                msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError(msg8, index);
                workingAlgId = null;
                workingPublicKeyAlgorithm = null;
                workingPublicKeyParameters = null;
            }
            --index;
        }
        this.trustAnchor = trust;
        this.subjectPublicKey = workingPublicKey;
    }

    private void checkPolicy() {
        Set<String> userInitialPolicySet = this.pkixParams.getInitialPolicies();
        List[] policyNodes = new ArrayList[this.n + 1];
        int j = 0;
        while (j < policyNodes.length) {
            policyNodes[j] = new ArrayList();
            ++j;
        }
        HashSet<String> policySet = new HashSet<String>();
        policySet.add("2.5.29.32.0");
        PKIXPolicyNode validPolicyTree = new PKIXPolicyNode(new ArrayList(), 0, policySet, null, new HashSet(), "2.5.29.32.0", false);
        policyNodes[0].add(validPolicyTree);
        int explicitPolicy = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int inhibitAnyPolicy = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int policyMapping = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        HashSet<String> acceptablePolicies = null;
        X509Certificate cert = null;
        try {
            HashSet _validPolicyNodeSet;
            PKIXPolicyNode intersection;
            ErrorBundle msg;
            int index = this.certs.size() - 1;
            while (index >= 0) {
                ErrorBundle msg2;
                ASN1Sequence certPolicies;
                int i = this.n - index;
                cert = (X509Certificate)this.certs.get(index);
                try {
                    certPolicies = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException ae) {
                    ErrorBundle msg3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException(msg3, (Throwable)ae, this.certPath, index);
                }
                if (certPolicies != null && validPolicyTree != null) {
                    PolicyInformation pInfo;
                    Enumeration e = certPolicies.getObjects();
                    HashSet<String> pols = new HashSet<String>();
                    while (e.hasMoreElements()) {
                        Set pq;
                        pInfo = PolicyInformation.getInstance(e.nextElement());
                        ASN1ObjectIdentifier pOid = pInfo.getPolicyIdentifier();
                        pols.add(pOid.getId());
                        if ("2.5.29.32.0".equals(pOid.getId())) continue;
                        try {
                            pq = PKIXCertPathReviewer.getQualifierSet(pInfo.getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException cpve) {
                            msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException(msg2, (Throwable)cpve, this.certPath, index);
                        }
                        boolean match = PKIXCertPathReviewer.processCertD1i(i, policyNodes, pOid, pq);
                        if (match) continue;
                        PKIXCertPathReviewer.processCertD1ii(i, policyNodes, pOid, pq);
                    }
                    if (acceptablePolicies == null || acceptablePolicies.contains("2.5.29.32.0")) {
                        acceptablePolicies = pols;
                    } else {
                        Iterator it = acceptablePolicies.iterator();
                        HashSet t1 = new HashSet();
                        while (it.hasNext()) {
                            Object o = it.next();
                            if (!pols.contains(o)) continue;
                            t1.add(o);
                        }
                        acceptablePolicies = t1;
                    }
                    if (inhibitAnyPolicy > 0 || i < this.n && PKIXCertPathReviewer.isSelfIssued(cert)) {
                        e = certPolicies.getObjects();
                        while (e.hasMoreElements()) {
                            Set _apq;
                            pInfo = PolicyInformation.getInstance(e.nextElement());
                            if (!"2.5.29.32.0".equals(pInfo.getPolicyIdentifier().getId())) continue;
                            try {
                                _apq = PKIXCertPathReviewer.getQualifierSet(pInfo.getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException cpve) {
                                ErrorBundle msg4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(msg4, (Throwable)cpve, this.certPath, index);
                            }
                            List _nodes = policyNodes[i - 1];
                            int k = 0;
                            while (k < _nodes.size()) {
                                PKIXPolicyNode _node = (PKIXPolicyNode)_nodes.get(k);
                                for (Object _tmp : _node.getExpectedPolicies()) {
                                    String _policy;
                                    if (_tmp instanceof String) {
                                        _policy = (String)_tmp;
                                    } else {
                                        if (!(_tmp instanceof DERObjectIdentifier)) continue;
                                        _policy = ((DERObjectIdentifier)_tmp).getId();
                                    }
                                    boolean _found = false;
                                    Iterator _childrenIter = _node.getChildren();
                                    while (_childrenIter.hasNext()) {
                                        PKIXPolicyNode _child = (PKIXPolicyNode)_childrenIter.next();
                                        if (!_policy.equals(_child.getValidPolicy())) continue;
                                        _found = true;
                                    }
                                    if (_found) continue;
                                    HashSet<String> _newChildExpectedPolicies = new HashSet<String>();
                                    _newChildExpectedPolicies.add(_policy);
                                    PKIXPolicyNode _newChild = new PKIXPolicyNode(new ArrayList(), i, _newChildExpectedPolicies, _node, _apq, _policy, false);
                                    _node.addChild(_newChild);
                                    policyNodes[i].add(_newChild);
                                }
                                ++k;
                            }
                            break block30;
                        }
                    }
                    int j2 = i - 1;
                    while (j2 >= 0) {
                        List nodes = policyNodes[j2];
                        int k = 0;
                        while (k < nodes.size()) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k);
                            if (!node.hasChildren() && (validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node)) == null) break;
                            ++k;
                        }
                        --j2;
                    }
                    Set<String> criticalExtensionOids = cert.getCriticalExtensionOIDs();
                    if (criticalExtensionOids != null) {
                        boolean critical = criticalExtensionOids.contains(CERTIFICATE_POLICIES);
                        List nodes = policyNodes[i];
                        int j3 = 0;
                        while (j3 < nodes.size()) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(j3);
                            node.setCritical(critical);
                            ++j3;
                        }
                    }
                }
                if (certPolicies == null) {
                    validPolicyTree = null;
                }
                if (explicitPolicy <= 0 && validPolicyTree == null) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException(msg);
                }
                if (i != this.n) {
                    ASN1Sequence mappings;
                    ASN1Primitive pm;
                    try {
                        pm = PKIXCertPathReviewer.getExtensionValue(cert, POLICY_MAPPINGS);
                    }
                    catch (AnnotatedException ae) {
                        ErrorBundle msg5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                        throw new CertPathReviewerException(msg5, (Throwable)ae, this.certPath, index);
                    }
                    if (pm != null) {
                        mappings = (ASN1Sequence)pm;
                        int j4 = 0;
                        while (j4 < mappings.size()) {
                            ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j4);
                            DERObjectIdentifier ip_id = (DERObjectIdentifier)mapping.getObjectAt(0);
                            DERObjectIdentifier sp_id = (DERObjectIdentifier)mapping.getObjectAt(1);
                            if ("2.5.29.32.0".equals(ip_id.getId())) {
                                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                                throw new CertPathReviewerException(msg2, this.certPath, index);
                            }
                            if ("2.5.29.32.0".equals(sp_id.getId())) {
                                msg2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                                throw new CertPathReviewerException(msg2, this.certPath, index);
                            }
                            ++j4;
                        }
                    }
                    if (pm != null) {
                        mappings = (ASN1Sequence)pm;
                        HashMap m_idp = new HashMap();
                        HashSet<String> s_idp = new HashSet<String>();
                        int j5 = 0;
                        while (j5 < mappings.size()) {
                            Set<String> tmp;
                            ASN1Sequence mapping = (ASN1Sequence)mappings.getObjectAt(j5);
                            String id_p = ((DERObjectIdentifier)mapping.getObjectAt(0)).getId();
                            String sd_p = ((DERObjectIdentifier)mapping.getObjectAt(1)).getId();
                            if (!m_idp.containsKey(id_p)) {
                                tmp = new HashSet<String>();
                                tmp.add(sd_p);
                                m_idp.put(id_p, tmp);
                                s_idp.add(id_p);
                            } else {
                                tmp = (Set)m_idp.get(id_p);
                                tmp.add(sd_p);
                            }
                            ++j5;
                        }
                        for (String id_p : s_idp) {
                            if (policyMapping > 0) {
                                ErrorBundle msg6;
                                try {
                                    PKIXCertPathReviewer.prepareNextCertB1(i, policyNodes, id_p, m_idp, cert);
                                    continue;
                                }
                                catch (AnnotatedException ae) {
                                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                    throw new CertPathReviewerException(msg6, (Throwable)ae, this.certPath, index);
                                }
                                catch (CertPathValidatorException cpve) {
                                    msg6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                    throw new CertPathReviewerException(msg6, (Throwable)cpve, this.certPath, index);
                                }
                            }
                            if (policyMapping > 0) continue;
                            validPolicyTree = PKIXCertPathReviewer.prepareNextCertB2(i, policyNodes, id_p, validPolicyTree);
                        }
                    }
                    if (!PKIXCertPathReviewer.isSelfIssued(cert)) {
                        if (explicitPolicy != 0) {
                            --explicitPolicy;
                        }
                        if (policyMapping != 0) {
                            --policyMapping;
                        }
                        if (inhibitAnyPolicy != 0) {
                            --inhibitAnyPolicy;
                        }
                    }
                    try {
                        ASN1Sequence pc = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, POLICY_CONSTRAINTS);
                        if (pc != null) {
                            Enumeration policyConstraints = pc.getObjects();
                            while (policyConstraints.hasMoreElements()) {
                                ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                                switch (constraint.getTagNo()) {
                                    case 0: {
                                        int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                        if (tmpInt >= explicitPolicy) break;
                                        explicitPolicy = tmpInt;
                                        break;
                                    }
                                    case 1: {
                                        int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                        if (tmpInt >= policyMapping) break;
                                        policyMapping = tmpInt;
                                    }
                                }
                            }
                        }
                    }
                    catch (AnnotatedException ae) {
                        ErrorBundle msg7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                        throw new CertPathReviewerException(msg7, this.certPath, index);
                    }
                    try {
                        int _inhibitAnyPolicy;
                        DERInteger iap = (DERInteger)PKIXCertPathReviewer.getExtensionValue(cert, INHIBIT_ANY_POLICY);
                        if (iap != null && (_inhibitAnyPolicy = iap.getValue().intValue()) < inhibitAnyPolicy) {
                            inhibitAnyPolicy = _inhibitAnyPolicy;
                        }
                    }
                    catch (AnnotatedException ae) {
                        ErrorBundle msg8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                        throw new CertPathReviewerException(msg8, this.certPath, index);
                    }
                }
                --index;
            }
            if (!PKIXCertPathReviewer.isSelfIssued(cert) && explicitPolicy > 0) {
                --explicitPolicy;
            }
            try {
                ASN1Sequence pc = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, POLICY_CONSTRAINTS);
                if (pc != null) {
                    Enumeration policyConstraints = pc.getObjects();
                    while (policyConstraints.hasMoreElements()) {
                        ASN1TaggedObject constraint = (ASN1TaggedObject)policyConstraints.nextElement();
                        switch (constraint.getTagNo()) {
                            case 0: {
                                int tmpInt = DERInteger.getInstance(constraint, false).getValue().intValue();
                                if (tmpInt != 0) break;
                                explicitPolicy = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException e) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException(msg, this.certPath, index);
            }
            if (validPolicyTree == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException(msg, this.certPath, index);
                }
                intersection = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(userInitialPolicySet)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (acceptablePolicies.isEmpty()) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException(msg, this.certPath, index);
                    }
                    _validPolicyNodeSet = new HashSet();
                    int j6 = 0;
                    while (j6 < policyNodes.length) {
                        ArrayList _nodeDepth = policyNodes[j6];
                        int k = 0;
                        while (k < _nodeDepth.size()) {
                            PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                            if ("2.5.29.32.0".equals(_node.getValidPolicy())) {
                                Iterator _iter = _node.getChildren();
                                while (_iter.hasNext()) {
                                    _validPolicyNodeSet.add(_iter.next());
                                }
                            }
                            ++k;
                        }
                        ++j6;
                    }
                    for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                        String _validPolicy = _node.getValidPolicy();
                        acceptablePolicies.contains(_validPolicy);
                    }
                    if (validPolicyTree != null) {
                        int j7 = this.n - 1;
                        while (j7 >= 0) {
                            List nodes = policyNodes[j7];
                            int k = 0;
                            while (k < nodes.size()) {
                                PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k);
                                if (!node.hasChildren()) {
                                    validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node);
                                }
                                ++k;
                            }
                            --j7;
                        }
                    }
                }
                intersection = validPolicyTree;
            } else {
                _validPolicyNodeSet = new HashSet();
                int j8 = 0;
                while (j8 < policyNodes.length) {
                    ArrayList _nodeDepth = policyNodes[j8];
                    int k = 0;
                    while (k < _nodeDepth.size()) {
                        PKIXPolicyNode _node = (PKIXPolicyNode)_nodeDepth.get(k);
                        if ("2.5.29.32.0".equals(_node.getValidPolicy())) {
                            Iterator _iter = _node.getChildren();
                            while (_iter.hasNext()) {
                                PKIXPolicyNode _c_node = (PKIXPolicyNode)_iter.next();
                                if ("2.5.29.32.0".equals(_c_node.getValidPolicy())) continue;
                                _validPolicyNodeSet.add(_c_node);
                            }
                        }
                        ++k;
                    }
                    ++j8;
                }
                for (PKIXPolicyNode _node : _validPolicyNodeSet) {
                    String _validPolicy = _node.getValidPolicy();
                    if (userInitialPolicySet.contains(_validPolicy)) continue;
                    validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, _node);
                }
                if (validPolicyTree != null) {
                    int j9 = this.n - 1;
                    while (j9 >= 0) {
                        ArrayList nodes = policyNodes[j9];
                        int k = 0;
                        while (k < nodes.size()) {
                            PKIXPolicyNode node = (PKIXPolicyNode)nodes.get(k);
                            if (!node.hasChildren()) {
                                validPolicyTree = PKIXCertPathReviewer.removePolicyNode(validPolicyTree, policyNodes, node);
                            }
                            ++k;
                        }
                        --j9;
                    }
                }
                intersection = validPolicyTree;
            }
            if (explicitPolicy <= 0 && intersection == null) {
                msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException(msg);
            }
            validPolicyTree = intersection;
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
            validPolicyTree = null;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> pathCheckers = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> certIter = pathCheckers.iterator();
        try {
            try {
                while (certIter.hasNext()) {
                    certIter.next().init(false);
                }
            }
            catch (CertPathValidatorException cpve) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{cpve.getMessage(), cpve, cpve.getClass().getName()});
                throw new CertPathReviewerException(msg, (Throwable)cpve);
            }
            X509Certificate cert = null;
            int index = this.certs.size() - 1;
            while (index >= 0) {
                cert = (X509Certificate)this.certs.get(index);
                Set<String> criticalExtensions = cert.getCriticalExtensionOIDs();
                if (criticalExtensions != null && !criticalExtensions.isEmpty()) {
                    criticalExtensions.remove(KEY_USAGE);
                    criticalExtensions.remove(CERTIFICATE_POLICIES);
                    criticalExtensions.remove(POLICY_MAPPINGS);
                    criticalExtensions.remove(INHIBIT_ANY_POLICY);
                    criticalExtensions.remove(ISSUING_DISTRIBUTION_POINT);
                    criticalExtensions.remove(DELTA_CRL_INDICATOR);
                    criticalExtensions.remove(POLICY_CONSTRAINTS);
                    criticalExtensions.remove(BASIC_CONSTRAINTS);
                    criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
                    criticalExtensions.remove(NAME_CONSTRAINTS);
                    if (criticalExtensions.contains(QC_STATEMENT) && this.processQcStatements(cert, index)) {
                        criticalExtensions.remove(QC_STATEMENT);
                    }
                    Iterator<PKIXCertPathChecker> tmpIter = pathCheckers.iterator();
                    while (tmpIter.hasNext()) {
                        try {
                            tmpIter.next().check(cert, criticalExtensions);
                        }
                        catch (CertPathValidatorException e) {
                            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{e.getMessage(), e, e.getClass().getName()});
                            throw new CertPathReviewerException(msg, e.getCause(), this.certPath, index);
                        }
                    }
                    if (!criticalExtensions.isEmpty()) {
                        Iterator<String> it = criticalExtensions.iterator();
                        while (it.hasNext()) {
                            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{new DERObjectIdentifier(it.next())});
                            this.addError(msg, index);
                        }
                    }
                }
                --index;
            }
        }
        catch (CertPathReviewerException cpre) {
            this.addError(cpre.getErrorMessage(), cpre.getIndex());
        }
    }

    private boolean processQcStatements(X509Certificate cert, int index) {
        try {
            boolean unknownStatement = false;
            ASN1Sequence qcSt = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(cert, QC_STATEMENT);
            int j = 0;
            while (j < qcSt.size()) {
                ErrorBundle msg;
                QCStatement stmt = QCStatement.getInstance(qcSt.getObjectAt(j));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals(stmt.getStatementId())) {
                    msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification(msg, index);
                } else if (!QCStatement.id_qcs_pkixQCSyntax_v1.equals(stmt.getStatementId())) {
                    if (QCStatement.id_etsi_qcs_QcSSCD.equals(stmt.getStatementId())) {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                        this.addNotification(msg, index);
                    } else if (QCStatement.id_etsi_qcs_LimiteValue.equals(stmt.getStatementId())) {
                        MonetaryValue limit = MonetaryValue.getInstance(stmt.getStatementInfo());
                        Iso4217CurrencyCode currency = limit.getCurrency();
                        double value = limit.getAmount().doubleValue() * Math.pow(10.0, limit.getExponent().doubleValue());
                        ErrorBundle msg2 = limit.getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{limit.getCurrency().getAlphabetic(), new TrustedInput(new Double(value)), limit}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf(limit.getCurrency().getNumeric()), new TrustedInput(new Double(value)), limit});
                        this.addNotification(msg2, index);
                    } else {
                        msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{stmt.getStatementId(), new UntrustedInput(stmt)});
                        this.addNotification(msg, index);
                        unknownStatement = true;
                    }
                }
                ++j;
            }
            return !unknownStatement;
        }
        catch (AnnotatedException ae) {
            ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(msg, index);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String IPtoString(byte[] ip) {
        block3: {
            try {
                result = InetAddress.getByAddress(ip).getHostAddress();
                break block3;
            }
            catch (Exception e) {
                b = new StringBuffer();
                i = 0;
                ** while (i != ip.length)
            }
lbl-1000:
            // 1 sources

            {
                b.append(Integer.toHexString(ip[i] & 255));
                b.append(' ');
                ++i;
                continue;
            }
lbl14:
            // 1 sources

            result = b.toString();
        }
        return result;
    }

    protected void checkRevocation(PKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, Vector crlDistPointUrls, Vector ocspUrls, int index) throws CertPathReviewerException {
        this.checkCRLs(paramsPKIX, cert, validDate, sign, workingPublicKey, crlDistPointUrls, index);
    }

    /*
     * Unable to fully structure code
     */
    protected void checkCRLs(PKIXParameters paramsPKIX, X509Certificate cert, Date validDate, X509Certificate sign, PublicKey workingPublicKey, Vector crlDistPointUrls, int index) throws CertPathReviewerException {
        block50: {
            block51: {
                crlselect = new X509CRLStoreSelector();
                try {
                    crlselect.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert).getEncoded());
                }
                catch (IOException e) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(msg, (Throwable)e);
                }
                crlselect.setCertificateChecking(cert);
                try {
                    crl_coll = PKIXCertPathReviewer.CRL_UTIL.findCRLs(crlselect, paramsPKIX);
                    crl_iter = crl_coll.iterator();
                    if (crl_coll.isEmpty()) {
                        crl_coll = PKIXCertPathReviewer.CRL_UTIL.findCRLs(new X509CRLStoreSelector(), paramsPKIX);
                        it = crl_coll.iterator();
                        nonMatchingCrlNames = new ArrayList<X500Principal>();
                        while (it.hasNext()) {
                            nonMatchingCrlNames.add(((X509CRL)it.next()).getIssuerX500Principal());
                        }
                        numbOfCrls = nonMatchingCrlNames.size();
                        msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(crlselect.getIssuerNames()), new UntrustedInput(nonMatchingCrlNames), Integers.valueOf(numbOfCrls)});
                        this.addNotification(msg, index);
                    }
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlExtractionError", new Object[]{ae.getCause().getMessage(), ae.getCause(), ae.getCause().getClass().getName()});
                    this.addError(msg, index);
                    crl_iter = new ArrayList<E>().iterator();
                }
                validCrlFound = false;
                crl = null;
                while (crl_iter.hasNext()) {
                    crl = (X509CRL)crl_iter.next();
                    if (crl.getNextUpdate() == null || paramsPKIX.getDate().before(crl.getNextUpdate())) {
                        validCrlFound = true;
                        msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.localValidCRL", new Object[]{new TrustedInput(crl.getThisUpdate()), new TrustedInput(crl.getNextUpdate())});
                        this.addNotification(msg, index);
                        break;
                    }
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.localInvalidCRL", new Object[]{new TrustedInput(crl.getThisUpdate()), new TrustedInput(crl.getNextUpdate())});
                    this.addNotification(msg, index);
                }
                if (!validCrlFound) {
                    onlineCRL = null;
                    urlIt = crlDistPointUrls.iterator();
                    while (urlIt.hasNext()) {
                        try {
                            location = (String)urlIt.next();
                            onlineCRL = this.getCRL(location);
                            if (onlineCRL == null) continue;
                            if (!cert.getIssuerX500Principal().equals(onlineCRL.getIssuerX500Principal())) {
                                msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput(onlineCRL.getIssuerX500Principal().getName()), new UntrustedInput(cert.getIssuerX500Principal().getName()), new UntrustedUrlInput(location)});
                                this.addNotification(msg, index);
                                continue;
                            }
                            if (onlineCRL.getNextUpdate() == null || this.pkixParams.getDate().before(onlineCRL.getNextUpdate())) {
                                validCrlFound = true;
                                msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.onlineValidCRL", new Object[]{new TrustedInput(onlineCRL.getThisUpdate()), new TrustedInput(onlineCRL.getNextUpdate()), new UntrustedUrlInput(location)});
                                this.addNotification(msg, index);
                                crl = onlineCRL;
                                break;
                            }
                            msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.onlineInvalidCRL", new Object[]{new TrustedInput(onlineCRL.getThisUpdate()), new TrustedInput(onlineCRL.getNextUpdate()), new UntrustedUrlInput(location)});
                            this.addNotification(msg, index);
                        }
                        catch (CertPathReviewerException cpre) {
                            this.addNotification(cpre.getErrorMessage(), index);
                        }
                    }
                }
                if (crl == null) break block50;
                if (!(sign == null || (keyusage = sign.getKeyUsage()) == null || keyusage.length >= 7 && keyusage[6])) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.noCrlSigningPermited");
                    throw new CertPathReviewerException(msg);
                }
                if (workingPublicKey != null) {
                    try {
                        crl.verify(workingPublicKey, "MSSP");
                    }
                    catch (Exception e) {
                        msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlVerifyFailed");
                        throw new CertPathReviewerException(msg, (Throwable)e);
                    }
                } else {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlNoIssuerPublicKey");
                    throw new CertPathReviewerException(msg);
                }
                crl_entry = crl.getRevokedCertificate(cert.getSerialNumber());
                if (crl_entry != null) {
                    reason = null;
                    if (crl_entry.hasExtensions()) {
                        try {
                            reasonCode = DEREnumerated.getInstance(PKIXCertPathReviewer.getExtensionValue(crl_entry, X509Extensions.ReasonCode.getId()));
                        }
                        catch (AnnotatedException ae) {
                            msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlReasonExtError");
                            throw new CertPathReviewerException(msg, (Throwable)ae);
                        }
                        if (reasonCode != null) {
                            reason = PKIXCertPathReviewer.crlReasons[reasonCode.getValue().intValue()];
                        }
                    }
                    if (reason == null) {
                        reason = PKIXCertPathReviewer.crlReasons[7];
                    }
                    ls = new LocaleString("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", reason);
                    if (!validDate.before(crl_entry.getRevocationDate())) {
                        msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.certRevoked", new Object[]{new TrustedInput(crl_entry.getRevocationDate()), ls});
                        throw new CertPathReviewerException(msg);
                    }
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput(crl_entry.getRevocationDate()), ls});
                    this.addNotification(msg, index);
                } else {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.notRevoked");
                    this.addNotification(msg, index);
                }
                if (crl.getNextUpdate() != null && crl.getNextUpdate().before(this.pkixParams.getDate())) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput(crl.getNextUpdate())});
                    this.addNotification(msg, index);
                }
                try {
                    idp = PKIXCertPathReviewer.getExtensionValue(crl, PKIXCertPathReviewer.ISSUING_DISTRIBUTION_POINT);
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.distrPtExtError");
                    throw new CertPathReviewerException(msg);
                }
                try {
                    dci = PKIXCertPathReviewer.getExtensionValue(crl, PKIXCertPathReviewer.DELTA_CRL_INDICATOR);
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.deltaCrlExtError");
                    throw new CertPathReviewerException(msg);
                }
                if (dci == null) break block51;
                baseSelect = new X509CRLStoreSelector();
                try {
                    baseSelect.addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal(crl).getEncoded());
                }
                catch (IOException e) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(msg, (Throwable)e);
                }
                baseSelect.setMinCRLNumber(((DERInteger)dci).getPositiveValue());
                try {
                    baseSelect.setMaxCRLNumber(((DERInteger)PKIXCertPathReviewer.getExtensionValue(crl, PKIXCertPathReviewer.CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(msg, (Throwable)ae);
                }
                foundBase = false;
                try {
                    it = PKIXCertPathReviewer.CRL_UTIL.findCRLs(baseSelect, paramsPKIX).iterator();
                    if (true) ** GOTO lbl152
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(msg, (Throwable)ae);
                }
                do {
                    base = (X509CRL)it.next();
                    try {
                        baseIdp = PKIXCertPathReviewer.getExtensionValue(base, PKIXCertPathReviewer.ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException ae) {
                        msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(msg, (Throwable)ae);
                    }
                    if (idp == null) {
                        if (baseIdp != null) continue;
                        foundBase = true;
                        break;
                    }
                    if (!idp.equals(baseIdp)) continue;
                    foundBase = true;
                    break;
lbl152:
                    // 3 sources

                } while (it.hasNext());
                if (!foundBase) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException(msg);
                }
            }
            if (idp != null) {
                p = IssuingDistributionPoint.getInstance(idp);
                bc = null;
                try {
                    bc = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(cert, PKIXCertPathReviewer.BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException ae) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException(msg, (Throwable)ae);
                }
                if (p.onlyContainsUserCerts() && bc != null && bc.isCA()) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException(msg);
                }
                if (p.onlyContainsCACerts() && (bc == null || !bc.isCA())) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException(msg);
                }
                if (p.onlyContainsAttributeCerts()) {
                    msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException(msg);
                }
            }
        }
        if (!validCrlFound) {
            msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(msg);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint crlDistPoints) {
        Vector<String> urls = new Vector<String>();
        if (crlDistPoints != null) {
            DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
            int i = 0;
            while (i < distPoints.length) {
                DistributionPointName dp_name = distPoints[i].getDistributionPoint();
                if (dp_name.getType() == 0) {
                    GeneralName[] generalNames = GeneralNames.getInstance(dp_name.getName()).getNames();
                    int j = 0;
                    while (j < generalNames.length) {
                        if (generalNames[j].getTagNo() == 6) {
                            String url = ((DERIA5String)generalNames[j].getName()).getString();
                            urls.add(url);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return urls;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authInfoAccess) {
        Vector<String> urls = new Vector<String>();
        if (authInfoAccess != null) {
            AccessDescription[] ads = authInfoAccess.getAccessDescriptions();
            int i = 0;
            while (i < ads.length) {
                GeneralName name;
                if (ads[i].getAccessMethod().equals(AccessDescription.id_ad_ocsp) && (name = ads[i].getAccessLocation()).getTagNo() == 6) {
                    String url = ((DERIA5String)name.getName()).getString();
                    urls.add(url);
                }
                ++i;
            }
        }
        return urls;
    }

    private X509CRL getCRL(String location) throws CertPathReviewerException {
        X509CRL result;
        block3: {
            result = null;
            try {
                URL url = new URL(location);
                if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) break block3;
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setUseCaches(false);
                conn.setDoInput(true);
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509", "MSSP");
                    result = (X509CRL)cf.generateCRL(conn.getInputStream());
                    break block3;
                }
                throw new Exception(conn.getResponseMessage());
            }
            catch (Exception e) {
                ErrorBundle msg = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(location), e.getMessage(), e, e.getClass().getName()});
                throw new CertPathReviewerException(msg);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected Collection getTrustAnchors(X509Certificate cert, Set trustanchors) throws CertPathReviewerException {
        trustColl = new ArrayList<TrustAnchor>();
        it = trustanchors.iterator();
        certSelectX509 = new X509CertSelector();
        try {
            certSelectX509.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert).getEncoded());
            ext = cert.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            if (ext == null) ** GOTO lbl27
            oct = (ASN1OctetString)ASN1Primitive.fromByteArray(ext);
            authID = AuthorityKeyIdentifier.getInstance(ASN1Primitive.fromByteArray(oct.getOctets()));
            certSelectX509.setSerialNumber(authID.getAuthorityCertSerialNumber());
            keyID = authID.getKeyIdentifier();
            if (keyID == null) ** GOTO lbl27
            certSelectX509.setSubjectKeyIdentifier(new DEROctetString(keyID).getEncoded());
            if (true) ** GOTO lbl27
        }
        catch (IOException ex) {
            msg = new ErrorBundle("cn.org.bjca.mssp.msspjce.x509.CertPathReviewerMessages", "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(msg);
        }
        do {
            if ((trust = (TrustAnchor)it.next()).getTrustedCert() != null) {
                if (!certSelectX509.match(trust.getTrustedCert())) continue;
                trustColl.add(trust);
                continue;
            }
            if (trust.getCAName() == null || trust.getCAPublicKey() == null || !(certIssuer = PKIXCertPathReviewer.getEncodedIssuerPrincipal(cert)).equals(caName = new X500Principal(trust.getCAName()))) continue;
            trustColl.add(trust);
lbl27:
            // 7 sources

        } while (it.hasNext());
        return trustColl;
    }
}

