/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.kangxin.im.parsing.db.dao.ConverListDao;
import com.kangxin.im.parsing.db.entity.ConverEntity;
import java.util.ArrayList;
import java.util.List;

public final class ConverListDao_Impl
implements ConverListDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ConverEntity> __insertionAdapterOfConverEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateUnread;
    private final SharedSQLiteStatement __preparedStmtOfUpdateSendStatus;
    private final SharedSQLiteStatement __preparedStmtOfUpdateShield;
    private final SharedSQLiteStatement __preparedStmtOfUpdateTitle;
    private final SharedSQLiteStatement __preparedStmtOfUpdateConvIcon;
    private final SharedSQLiteStatement __preparedStmtOfDeleteConversation;

    public ConverListDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfConverEntity = new EntityInsertionAdapter<ConverEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `imconverlist` (`id`,`doctorId`,`headPotrait`,`title`,`content`,`time`,`conversationId`,`conversationType`,`unRead`,`isShield`,`sendStatus`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ConverEntity value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getDoctorId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDoctorId());
                }
                if (value.getHeadPotrait() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getHeadPotrait());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getTitle());
                }
                if (value.getContent() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getContent());
                }
                stmt.bindLong(6, value.getTime());
                if (value.getConversationId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getConversationId());
                }
                stmt.bindLong(8, (long)value.getConversationType());
                stmt.bindLong(9, (long)value.getUnRead());
                int _tmp = value.isShield() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp);
                stmt.bindLong(11, (long)value.getSendStatus());
            }
        };
        this.__preparedStmtOfUpdateUnread = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE imconverlist SET unRead=? WHERE conversationId=?";
                return "UPDATE imconverlist SET unRead=? WHERE conversationId=?";
            }
        };
        this.__preparedStmtOfUpdateSendStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE imconverlist SET sendStatus=? WHERE conversationId=?";
                return "UPDATE imconverlist SET sendStatus=? WHERE conversationId=?";
            }
        };
        this.__preparedStmtOfUpdateShield = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE imconverlist SET isShield=? WHERE conversationId=?";
                return "UPDATE imconverlist SET isShield=? WHERE conversationId=?";
            }
        };
        this.__preparedStmtOfUpdateTitle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE imconverlist SET title=? WHERE conversationId=?";
                return "UPDATE imconverlist SET title=? WHERE conversationId=?";
            }
        };
        this.__preparedStmtOfUpdateConvIcon = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE imconverlist SET headPotrait=? WHERE conversationId=?";
                return "UPDATE imconverlist SET headPotrait=? WHERE conversationId=?";
            }
        };
        this.__preparedStmtOfDeleteConversation = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM imconverlist where conversationId=?";
                return "DELETE FROM imconverlist where conversationId=?";
            }
        };
    }

    @Override
    public void insert(ConverEntity entity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfConverEntity.insert((Object)entity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUnread(String conversationId, int unRead) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateUnread.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)unRead);
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateUnread.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSendStatus(String conversationId, int sendStatus) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateSendStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)sendStatus);
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateSendStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateShield(String conversationId, boolean isShield) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateShield.acquire();
        int _argIndex = 1;
        int _tmp = isShield ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateShield.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableShield(String conversationId, boolean isShield) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateShield.acquire();
        int _argIndex = 1;
        int _tmp = isShield ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateShield.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTitle(String title, String conversationId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateTitle.acquire();
        int _argIndex = 1;
        if (title == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, title);
        }
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateTitle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConvIcon(String iconUrl, String conversationId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateConvIcon.acquire();
        int _argIndex = 1;
        if (iconUrl == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, iconUrl);
        }
        _argIndex = 2;
        if (conversationId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, conversationId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateConvIcon.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConversation(String convId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteConversation.acquire();
        int _argIndex = 1;
        if (convId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, convId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteConversation.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkExsit(String conversationId, String doctorId) {
        String _sql = "SELECT count(*) from imconverlist where conversationId=? and doctorId=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from imconverlist where conversationId=? and doctorId=?", (int)2);
        int _argIndex = 1;
        if (conversationId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, conversationId);
        }
        _argIndex = 2;
        if (doctorId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doctorId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConverEntity getConverData(String conversationId) {
        String _sql = "SELECT * from imconverlist where conversationId=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from imconverlist where conversationId=?", (int)1);
        int _argIndex = 1;
        if (conversationId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, conversationId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ConverEntity _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfDoctorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"doctorId");
            int _cursorIndexOfHeadPotrait = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headPotrait");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content");
            int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
            int _cursorIndexOfConversationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversationId");
            int _cursorIndexOfConversationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversationType");
            int _cursorIndexOfUnRead = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unRead");
            int _cursorIndexOfIsShield = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isShield");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            if (_cursor.moveToFirst()) {
                _result = new ConverEntity();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpDoctorId = _cursor.getString(_cursorIndexOfDoctorId);
                _result.setDoctorId(_tmpDoctorId);
                String _tmpHeadPotrait = _cursor.getString(_cursorIndexOfHeadPotrait);
                _result.setHeadPotrait(_tmpHeadPotrait);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _result.setTitle(_tmpTitle);
                String _tmpContent = _cursor.getString(_cursorIndexOfContent);
                _result.setContent(_tmpContent);
                long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                _result.setTime(_tmpTime);
                String _tmpConversationId = _cursor.getString(_cursorIndexOfConversationId);
                _result.setConversationId(_tmpConversationId);
                int _tmpConversationType = _cursor.getInt(_cursorIndexOfConversationType);
                _result.setConversationType(_tmpConversationType);
                int _tmpUnRead = _cursor.getInt(_cursorIndexOfUnRead);
                _result.setUnRead(_tmpUnRead);
                int _tmp = _cursor.getInt(_cursorIndexOfIsShield);
                boolean _tmpIsShield = _tmp != 0;
                _result.setShield(_tmpIsShield);
                int _tmpSendStatus = _cursor.getInt(_cursorIndexOfSendStatus);
                _result.setSendStatus(_tmpSendStatus);
            } else {
                _result = null;
            }
            ConverEntity converEntity = _result;
            return converEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConverEntity> queryImConverList(String doctorId) {
        String _sql = "SELECT * FROM imconverlist where doctorId=? ORDER BY time DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM imconverlist where doctorId=? ORDER BY time DESC", (int)1);
        int _argIndex = 1;
        if (doctorId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, doctorId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfDoctorId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"doctorId");
            int _cursorIndexOfHeadPotrait = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"headPotrait");
            int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
            int _cursorIndexOfContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content");
            int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
            int _cursorIndexOfConversationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversationId");
            int _cursorIndexOfConversationType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversationType");
            int _cursorIndexOfUnRead = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"unRead");
            int _cursorIndexOfIsShield = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isShield");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            ArrayList<ConverEntity> _result = new ArrayList<ConverEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                ConverEntity _item = new ConverEntity();
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                String _tmpDoctorId = _cursor.getString(_cursorIndexOfDoctorId);
                _item.setDoctorId(_tmpDoctorId);
                String _tmpHeadPotrait = _cursor.getString(_cursorIndexOfHeadPotrait);
                _item.setHeadPotrait(_tmpHeadPotrait);
                String _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
                _item.setTitle(_tmpTitle);
                String _tmpContent = _cursor.getString(_cursorIndexOfContent);
                _item.setContent(_tmpContent);
                long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                _item.setTime(_tmpTime);
                String _tmpConversationId = _cursor.getString(_cursorIndexOfConversationId);
                _item.setConversationId(_tmpConversationId);
                int _tmpConversationType = _cursor.getInt(_cursorIndexOfConversationType);
                _item.setConversationType(_tmpConversationType);
                int _tmpUnRead = _cursor.getInt(_cursorIndexOfUnRead);
                _item.setUnRead(_tmpUnRead);
                int _tmp = _cursor.getInt(_cursorIndexOfIsShield);
                boolean _tmpIsShield = _tmp != 0;
                _item.setShield(_tmpIsShield);
                int _tmpSendStatus = _cursor.getInt(_cursorIndexOfSendStatus);
                _item.setSendStatus(_tmpSendStatus);
                _result.add(_item);
            }
            ArrayList<ConverEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

