/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.db.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.kangxin.im.parsing.db.entity.ImMessage;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\b\u0010\u0006\u001a\u00020\u0007H'J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H'J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH'J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH'J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H'J\u0018\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H'J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H'J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H'J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H'J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0005H'J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H'J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0005H'J4\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u0005H'J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005H'J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005H'J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H'J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\fH'J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005H'J!\u0010'\u001a\u00020\u00072\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0)\"\u00020\fH'\u00a2\u0006\u0002\u0010*\u00a8\u0006+"}, d2={"Lcom/kangxin/im/parsing/db/dao/MessageDao;", "", "checkExist", "", "id", "", "deleteAllMsg", "", "deleteMsgById", "msgId", "getAll", "", "Lcom/kangxin/im/parsing/db/entity/ImMessage;", "getAllSubId", "getImConsuUnreadByConvId", "converId", "applicationCode", "getImConsuUnreadBySubId", "subId", "getImageMsgBySubId", "getLastMsgByConverId", "userId", "getLastMsgBySubId", "getLatestTime", "Ljava/util/Date;", "getMessage", "getMsgList", "getPatUnreadCount", "receiver", "getPreviousMessages", "subIds", "amount", "offset", "", "getUnreadAmount", "getUnreadCount", "insert", "message", "setRead", "update", "messages", "", "([Lcom/kangxin/im/parsing/db/entity/ImMessage;)V", "module_im_parsing_release"})
@Dao
public interface MessageDao {
    @Query(value="SELECT DISTINCT subId from message")
    @NotNull
    public List<String> getAllSubId();

    @Query(value="SELECT * from message where id=:id")
    @Nullable
    public ImMessage getMessage(@NotNull String var1);

    @Query(value="SELECT * from message")
    @NotNull
    public List<ImMessage> getAll();

    @Query(value="SELECT * FROM message where subId=:subId and userId=:userId order by rowid desc limit 1")
    @Nullable
    public ImMessage getLastMsgBySubId(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT * FROM message where converId=:converId and userId=:userId order by date desc limit 1")
    @Nullable
    public ImMessage getLastMsgByConverId(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT count(*) from message where id=:id")
    public int checkExist(@NotNull String var1);

    @Query(value="SELECT count(*) from message where subId = :subId and readStatus = 'None'")
    public int getUnreadAmount(@NotNull String var1);

    @Query(value="SELECT date from message where subId=:subId order by date desc limit 1")
    @Nullable
    public Date getLatestTime(@NotNull String var1);

    @Query(value="SELECT * FROM message WHERE subId=:subId")
    @NotNull
    public List<ImMessage> getMsgList(@NotNull String var1);

    @Query(value="SELECT * from message where subId in (:subIds) and userId=:userId and date < :offset order by date asc limit :amount offset (SELECT count(*) FROM message where subId in (:subIds) and date < :offset) - :amount")
    @NotNull
    public List<ImMessage> getPreviousMessages(@NotNull List<String> var1, int var2, long var3, @NotNull String var5);

    @Query(value="SELECT * from message where subId in (:subIds) and userId=:userId order by date asc limit :amount offset (SELECT count(*) FROM message where subId in (:subIds)) - :amount")
    @NotNull
    public List<ImMessage> getPreviousMessages(@NotNull List<String> var1, int var2, @NotNull String var3);

    @Query(value="SELECT * from message where messageType='PICTURE' and subId=:subId order by date desc")
    @NotNull
    public List<ImMessage> getImageMsgBySubId(@Nullable String var1);

    @Query(value="UPDATE message set readStatus='Had' where subId=:subId")
    public void setRead(@NotNull String var1);

    @Insert(onConflict=5)
    public long insert(@NotNull ImMessage var1);

    @Update
    public void update(ImMessage ... var1);

    @Query(value="DELETE FROM message where id=:msgId")
    public void deleteMsgById(@NotNull String var1);

    @Query(value="SELECT count(*) from message where receiver=:receiver and readStatus = 'None' GROUP BY subId")
    public int getPatUnreadCount(@NotNull String var1);

    @Query(value="SELECT count(*) from message where receiver=:receiver and applicationCode=:applicationCode and readStatus = 'None'")
    public int getUnreadCount(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT count(*) from message where subId=:subId and applicationCode=:applicationCode and readStatus = 'None'")
    public int getImConsuUnreadBySubId(@NotNull String var1, @NotNull String var2);

    @Query(value="SELECT count(*) from message where converId=:converId and applicationCode=:applicationCode and readStatus = 'None'")
    public int getImConsuUnreadByConvId(@NotNull String var1, @NotNull String var2);

    @Query(value="DELETE FROM message")
    public void deleteAllMsg();
}

