/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.kangxin.im.parsing.db.dao.MessageDao;
import com.kangxin.im.parsing.db.entity.HytData;
import com.kangxin.im.parsing.db.entity.ImMessage;
import com.kangxin.im.parsing.db.manager.Converters;
import com.kangxin.im.parsing.tx.types.DirectionType;
import com.kangxin.im.parsing.tx.types.MessageType;
import com.kangxin.im.parsing.tx.types.ReadStatusType;
import com.kangxin.im.parsing.tx.types.SendStatusType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class MessageDao_Impl
implements MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ImMessage> __insertionAdapterOfImMessage;
    private final Converters __converters = new Converters();
    private final EntityDeletionOrUpdateAdapter<ImMessage> __updateAdapterOfImMessage;
    private final SharedSQLiteStatement __preparedStmtOfSetRead;
    private final SharedSQLiteStatement __preparedStmtOfDeleteMsgById;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAllMsg;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfImMessage = new EntityInsertionAdapter<ImMessage>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `message` (`msgId`,`applicationCode`,`subId`,`sender`,`receiver`,`date`,`body`,`path`,`url`,`converId`,`sendStatus`,`messageType`,`direction`,`readStatus`,`data`,`duration`,`id`,`userId`,`conversion_id`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ImMessage value) {
                if (value.getMsgId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMsgId());
                }
                if (value.getApplicationCode() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getApplicationCode());
                }
                if (value.getSubId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSubId());
                }
                if (value.getSender() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSender());
                }
                if (value.getReceiver() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReceiver());
                }
                long _tmp = MessageDao_Impl.this.__converters.dateToTimestamp(value.getDate());
                stmt.bindLong(6, _tmp);
                if (value.getBody() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getBody());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPath());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getUrl());
                }
                if (value.getConverId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getConverId());
                }
                String _tmp_1 = MessageDao_Impl.this.__converters.fromSendStatusType(value.getSendStatus());
                if (_tmp_1 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_1);
                }
                String _tmp_2 = MessageDao_Impl.this.__converters.fromMessageType(value.getMessageType());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                String _tmp_3 = MessageDao_Impl.this.__converters.fromDirectionType(value.getDirection());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                String _tmp_4 = MessageDao_Impl.this.__converters.fromReadStatusType(value.getReadStatus());
                if (_tmp_4 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_4);
                }
                String _tmp_5 = MessageDao_Impl.this.__converters.fromData(value.getData());
                if (_tmp_5 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_5);
                }
                stmt.bindLong(16, (long)value.getDuration());
                if (value.getId() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getUserId());
                }
                stmt.bindLong(19, (long)value.getConversionId());
            }
        };
        this.__updateAdapterOfImMessage = new EntityDeletionOrUpdateAdapter<ImMessage>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `message` SET `msgId` = ?,`applicationCode` = ?,`subId` = ?,`sender` = ?,`receiver` = ?,`date` = ?,`body` = ?,`path` = ?,`url` = ?,`converId` = ?,`sendStatus` = ?,`messageType` = ?,`direction` = ?,`readStatus` = ?,`data` = ?,`duration` = ?,`id` = ?,`userId` = ?,`conversion_id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ImMessage value) {
                if (value.getMsgId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMsgId());
                }
                if (value.getApplicationCode() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getApplicationCode());
                }
                if (value.getSubId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSubId());
                }
                if (value.getSender() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getSender());
                }
                if (value.getReceiver() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReceiver());
                }
                long _tmp = MessageDao_Impl.this.__converters.dateToTimestamp(value.getDate());
                stmt.bindLong(6, _tmp);
                if (value.getBody() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getBody());
                }
                if (value.getPath() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPath());
                }
                if (value.getUrl() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getUrl());
                }
                if (value.getConverId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getConverId());
                }
                String _tmp_1 = MessageDao_Impl.this.__converters.fromSendStatusType(value.getSendStatus());
                if (_tmp_1 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_1);
                }
                String _tmp_2 = MessageDao_Impl.this.__converters.fromMessageType(value.getMessageType());
                if (_tmp_2 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_2);
                }
                String _tmp_3 = MessageDao_Impl.this.__converters.fromDirectionType(value.getDirection());
                if (_tmp_3 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_3);
                }
                String _tmp_4 = MessageDao_Impl.this.__converters.fromReadStatusType(value.getReadStatus());
                if (_tmp_4 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_4);
                }
                String _tmp_5 = MessageDao_Impl.this.__converters.fromData(value.getData());
                if (_tmp_5 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_5);
                }
                stmt.bindLong(16, (long)value.getDuration());
                if (value.getId() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, value.getId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, value.getUserId());
                }
                stmt.bindLong(19, (long)value.getConversionId());
                if (value.getId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getId());
                }
            }
        };
        this.__preparedStmtOfSetRead = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE message set readStatus='Had' where subId=?";
                return "UPDATE message set readStatus='Had' where subId=?";
            }
        };
        this.__preparedStmtOfDeleteMsgById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM message where id=?";
                return "DELETE FROM message where id=?";
            }
        };
        this.__preparedStmtOfDeleteAllMsg = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM message";
                return "DELETE FROM message";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ImMessage message) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfImMessage.insertAndReturnId((Object)message);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ImMessage ... messages) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfImMessage.handleMultiple((Object[])messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRead(String subId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetRead.acquire();
        int _argIndex = 1;
        if (subId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, subId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetRead.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMsgById(String msgId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteMsgById.acquire();
        int _argIndex = 1;
        if (msgId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, msgId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteMsgById.release(_stmt);
        }
    }

    @Override
    public void deleteAllMsg() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAllMsg.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAllMsg.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllSubId() {
        String _sql = "SELECT DISTINCT subId from message";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT DISTINCT subId from message", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImMessage getMessage(String id) {
        String _sql = "SELECT * from message where id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message where id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ImMessage _result;
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                _result = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _result.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _result.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _result.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _result.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _result.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _result.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _result.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _result.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _result.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _result.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _result.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _result.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _result.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _result.setDuration(_tmpDuration);
            } else {
                _result = null;
            }
            ImMessage imMessage = _result;
            return imMessage;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImMessage> getAll() {
        String _sql = "SELECT * from message";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            ArrayList<ImMessage> _result = new ArrayList<ImMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                ImMessage _item = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _item.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _item.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _item.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _item.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _item.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _item.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _item.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _item.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _item.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _item.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _item.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _item.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _item.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _item.setDuration(_tmpDuration);
                _result.add(_item);
            }
            ArrayList<ImMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImMessage getLastMsgBySubId(String subId, String userId) {
        String _sql = "SELECT * FROM message where subId=? and userId=? order by rowid desc limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM message where subId=? and userId=? order by rowid desc limit 1", (int)2);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ImMessage _result;
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                _result = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _result.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _result.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _result.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _result.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _result.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _result.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _result.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _result.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _result.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _result.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _result.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _result.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _result.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _result.setDuration(_tmpDuration);
            } else {
                _result = null;
            }
            ImMessage imMessage = _result;
            return imMessage;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImMessage getLastMsgByConverId(String converId, String userId) {
        String _sql = "SELECT * FROM message where converId=? and userId=? order by date desc limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM message where converId=? and userId=? order by date desc limit 1", (int)2);
        int _argIndex = 1;
        if (converId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, converId);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ImMessage _result;
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                _result = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _result.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _result.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _result.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _result.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _result.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _result.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _result.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _result.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _result.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _result.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _result.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _result.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _result.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _result.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _result.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _result.setDuration(_tmpDuration);
            } else {
                _result = null;
            }
            ImMessage imMessage = _result;
            return imMessage;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkExist(String id) {
        String _sql = "SELECT count(*) from message where id=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where id=?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnreadAmount(String subId) {
        String _sql = "SELECT count(*) from message where subId = ? and readStatus = 'None'";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where subId = ? and readStatus = 'None'", (int)1);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getLatestTime(String subId) {
        String _sql = "SELECT date from message where subId=? order by date desc limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT date from message where subId=? order by date desc limit 1", (int)1);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Date _result;
            if (_cursor.moveToFirst()) {
                long _tmp = _cursor.getLong(0);
                _result = this.__converters.fromTimestamp(_tmp);
            } else {
                _result = null;
            }
            Date date = _result;
            return date;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImMessage> getMsgList(String subId) {
        String _sql = "SELECT * FROM message WHERE subId=?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM message WHERE subId=?", (int)1);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            ArrayList<ImMessage> _result = new ArrayList<ImMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                ImMessage _item = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _item.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _item.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _item.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _item.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _item.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _item.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _item.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _item.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _item.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _item.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _item.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _item.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _item.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _item.setDuration(_tmpDuration);
                _result.add(_item);
            }
            ArrayList<ImMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImMessage> getPreviousMessages(List<String> subIds, int amount, long offset, String userId) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" from message where subId in (");
        int _inputSize = subIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and userId=");
        _stringBuilder.append("?");
        _stringBuilder.append(" and date < ");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by date asc limit ");
        _stringBuilder.append("?");
        _stringBuilder.append(" offset (SELECT count(*) FROM message where subId in (");
        int _inputSize_1 = subIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(") and date < ");
        _stringBuilder.append("?");
        _stringBuilder.append(") - ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 5 + _inputSize + _inputSize_1;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : subIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2 + _inputSize;
        _statement.bindLong(_argIndex, offset);
        _argIndex = 3 + _inputSize;
        _statement.bindLong(_argIndex, (long)amount);
        _argIndex = 4 + _inputSize;
        for (String _item_1 : subIds) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 4 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, offset);
        _argIndex = 5 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, (long)amount);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            ArrayList<ImMessage> _result = new ArrayList<ImMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                ImMessage _item_2 = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _item_2.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _item_2.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _item_2.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _item_2.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _item_2.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _item_2.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _item_2.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _item_2.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_2.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _item_2.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _item_2.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _item_2.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _item_2.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _item_2.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _item_2.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _item_2.setDuration(_tmpDuration);
                _result.add(_item_2);
            }
            ArrayList<ImMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImMessage> getPreviousMessages(List<String> subIds, int amount, String userId) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT ");
        _stringBuilder.append("*");
        _stringBuilder.append(" from message where subId in (");
        int _inputSize = subIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and userId=");
        _stringBuilder.append("?");
        _stringBuilder.append(" order by date asc limit ");
        _stringBuilder.append("?");
        _stringBuilder.append(" offset (SELECT count(*) FROM message where subId in (");
        int _inputSize_1 = subIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) - ");
        _stringBuilder.append("?");
        String _sql = _stringBuilder.toString();
        int _argCount = 3 + _inputSize + _inputSize_1;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : subIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 1 + _inputSize;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2 + _inputSize;
        _statement.bindLong(_argIndex, (long)amount);
        _argIndex = 3 + _inputSize;
        for (String _item_1 : subIds) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 3 + _inputSize + _inputSize;
        _statement.bindLong(_argIndex, (long)amount);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            ArrayList<ImMessage> _result = new ArrayList<ImMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                ImMessage _item_2 = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _item_2.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _item_2.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _item_2.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _item_2.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _item_2.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _item_2.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _item_2.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _item_2.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item_2.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _item_2.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _item_2.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _item_2.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _item_2.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _item_2.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _item_2.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _item_2.setDuration(_tmpDuration);
                _result.add(_item_2);
            }
            ArrayList<ImMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ImMessage> getImageMsgBySubId(String subId) {
        String _sql = "SELECT * from message where messageType='PICTURE' and subId=? order by date desc";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from message where messageType='PICTURE' and subId=? order by date desc", (int)1);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMsgId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"msgId");
            int _cursorIndexOfApplicationCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"applicationCode");
            int _cursorIndexOfSubId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"subId");
            int _cursorIndexOfSender = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sender");
            int _cursorIndexOfReceiver = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"receiver");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"body");
            int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
            int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
            int _cursorIndexOfConverId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"converId");
            int _cursorIndexOfSendStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendStatus");
            int _cursorIndexOfMessageType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageType");
            int _cursorIndexOfDirection = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"direction");
            int _cursorIndexOfReadStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"readStatus");
            int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"data");
            int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfConversionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"conversion_id");
            ArrayList<ImMessage> _result = new ArrayList<ImMessage>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                int _tmpConversionId = _cursor.getInt(_cursorIndexOfConversionId);
                ImMessage _item = new ImMessage(_tmpId, _tmpUserId, _tmpConversionId);
                String _tmpMsgId = _cursor.getString(_cursorIndexOfMsgId);
                _item.setMsgId(_tmpMsgId);
                String _tmpApplicationCode = _cursor.getString(_cursorIndexOfApplicationCode);
                _item.setApplicationCode(_tmpApplicationCode);
                String _tmpSubId = _cursor.getString(_cursorIndexOfSubId);
                _item.setSubId(_tmpSubId);
                String _tmpSender = _cursor.getString(_cursorIndexOfSender);
                _item.setSender(_tmpSender);
                String _tmpReceiver = _cursor.getString(_cursorIndexOfReceiver);
                _item.setReceiver(_tmpReceiver);
                long _tmp = _cursor.getLong(_cursorIndexOfDate);
                Date _tmpDate = this.__converters.fromTimestamp(_tmp);
                _item.setDate(_tmpDate);
                String _tmpBody = _cursor.getString(_cursorIndexOfBody);
                _item.setBody(_tmpBody);
                String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                _item.setPath(_tmpPath);
                String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                _item.setUrl(_tmpUrl);
                String _tmpConverId = _cursor.getString(_cursorIndexOfConverId);
                _item.setConverId(_tmpConverId);
                String _tmp_1 = _cursor.getString(_cursorIndexOfSendStatus);
                SendStatusType _tmpSendStatus = this.__converters.stringToSendStatusType(_tmp_1);
                _item.setSendStatus(_tmpSendStatus);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMessageType);
                MessageType _tmpMessageType = this.__converters.stringToMessageType(_tmp_2);
                _item.setMessageType(_tmpMessageType);
                String _tmp_3 = _cursor.getString(_cursorIndexOfDirection);
                DirectionType _tmpDirection = this.__converters.stringToDirectionType(_tmp_3);
                _item.setDirection(_tmpDirection);
                String _tmp_4 = _cursor.getString(_cursorIndexOfReadStatus);
                ReadStatusType _tmpReadStatus = this.__converters.stringToReadStatusType(_tmp_4);
                _item.setReadStatus(_tmpReadStatus);
                String _tmp_5 = _cursor.getString(_cursorIndexOfData);
                HytData _tmpData = this.__converters.stringToData(_tmp_5);
                _item.setData(_tmpData);
                int _tmpDuration = _cursor.getInt(_cursorIndexOfDuration);
                _item.setDuration(_tmpDuration);
                _result.add(_item);
            }
            ArrayList<ImMessage> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPatUnreadCount(String receiver) {
        String _sql = "SELECT count(*) from message where receiver=? and readStatus = 'None' GROUP BY subId";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where receiver=? and readStatus = 'None' GROUP BY subId", (int)1);
        int _argIndex = 1;
        if (receiver == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, receiver);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnreadCount(String receiver, String applicationCode) {
        String _sql = "SELECT count(*) from message where receiver=? and applicationCode=? and readStatus = 'None'";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where receiver=? and applicationCode=? and readStatus = 'None'", (int)2);
        int _argIndex = 1;
        if (receiver == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, receiver);
        }
        _argIndex = 2;
        if (applicationCode == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, applicationCode);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImConsuUnreadBySubId(String subId, String applicationCode) {
        String _sql = "SELECT count(*) from message where subId=? and applicationCode=? and readStatus = 'None'";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where subId=? and applicationCode=? and readStatus = 'None'", (int)2);
        int _argIndex = 1;
        if (subId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, subId);
        }
        _argIndex = 2;
        if (applicationCode == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, applicationCode);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImConsuUnreadByConvId(String converId, String applicationCode) {
        String _sql = "SELECT count(*) from message where converId=? and applicationCode=? and readStatus = 'None'";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from message where converId=? and applicationCode=? and readStatus = 'None'", (int)2);
        int _argIndex = 1;
        if (converId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, converId);
        }
        _argIndex = 2;
        if (applicationCode == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, applicationCode);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

