/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.db.manager;

import androidx.room.TypeConverter;
import com.google.gson.Gson;
import com.kangxin.im.parsing.db.entity.HytData;
import com.kangxin.im.parsing.tx.types.DirectionType;
import com.kangxin.im.parsing.tx.types.MessageType;
import com.kangxin.im.parsing.tx.types.ReadStatusType;
import com.kangxin.im.parsing.tx.types.SendStatusType;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0011H\u0007J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\bH\u0007J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007J\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u001b"}, d2={"Lcom/kangxin/im/parsing/db/manager/Converters;", "", "()V", "dateToTimestamp", "", "date", "Ljava/util/Date;", "fromData", "", "data", "Lcom/kangxin/im/parsing/db/entity/HytData;", "fromDirectionType", "type", "Lcom/kangxin/im/parsing/tx/types/DirectionType;", "fromMessageType", "Lcom/kangxin/im/parsing/tx/types/MessageType;", "fromReadStatusType", "Lcom/kangxin/im/parsing/tx/types/ReadStatusType;", "fromSendStatusType", "Lcom/kangxin/im/parsing/tx/types/SendStatusType;", "fromTimestamp", "value", "stringToData", "stringToDirectionType", "stringToMessageType", "stringToReadStatusType", "stringToSendStatusType", "module_im_parsing_release"})
public final class Converters {
    @TypeConverter
    @NotNull
    public final Date fromTimestamp(long value) {
        return new Date(value);
    }

    @TypeConverter
    public final long dateToTimestamp(@NotNull Date date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return date.getTime();
    }

    @TypeConverter
    @NotNull
    public final MessageType stringToMessageType(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return MessageType.valueOf(value);
    }

    @TypeConverter
    @NotNull
    public final String fromMessageType(@NotNull MessageType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return type.name();
    }

    @TypeConverter
    @Nullable
    public final SendStatusType stringToSendStatusType(@Nullable String value) {
        return value == null ? null : SendStatusType.valueOf(value);
    }

    @TypeConverter
    @NotNull
    public final String fromSendStatusType(@Nullable SendStatusType type) {
        Object object = type;
        if (object == null || (object = object.name()) == null) {
            object = SendStatusType.Success.name();
        }
        return object;
    }

    @TypeConverter
    @Nullable
    public final DirectionType stringToDirectionType(@Nullable String value) {
        return value == null ? null : DirectionType.valueOf(value);
    }

    @TypeConverter
    @NotNull
    public final String fromDirectionType(@Nullable DirectionType type) {
        Object object = type;
        if (object == null || (object = object.name()) == null) {
            object = DirectionType.Send.name();
        }
        return object;
    }

    @TypeConverter
    @Nullable
    public final ReadStatusType stringToReadStatusType(@Nullable String value) {
        return value == null ? null : ReadStatusType.valueOf(value);
    }

    @TypeConverter
    @NotNull
    public final String fromReadStatusType(@Nullable ReadStatusType type) {
        Object object = type;
        if (object == null || (object = object.name()) == null) {
            object = ReadStatusType.Had.name();
        }
        return object;
    }

    @TypeConverter
    @NotNull
    public final String fromData(@Nullable HytData data) {
        String string = new Gson().toJson((Object)data);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Gson().toJson(data)");
        return string;
    }

    @TypeConverter
    @Nullable
    public final HytData stringToData(@Nullable String data) {
        return data == null ? null : (HytData)new Gson().fromJson(data, HytData.class);
    }
}

