/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.tx.listener.impl;

import com.kangxin.im.parsing.db.entity.ImMessage;
import com.kangxin.im.parsing.db.manager.ImDatabase;
import com.tencent.imsdk.ext.message.TIMMessageLocator;
import com.tencent.imsdk.ext.message.TIMMessageRevokedListener;
import java.util.ArrayList;
import java.util.List;

public class MessageRevokedListener
implements TIMMessageRevokedListener {
    private static final MessageRevokedListener instance = new MessageRevokedListener();
    private List<MessageRevokeHandler> mHandlers = new ArrayList<MessageRevokeHandler>();

    public static MessageRevokedListener getInstance() {
        return instance;
    }

    private MessageRevokedListener() {
    }

    public void onMessageRevoked(TIMMessageLocator locator) {
        for (int i = 0; i < this.mHandlers.size(); ++i) {
            this.mHandlers.get(i).onHandleInvoke(locator);
        }
        if (!locator.isSelf() && locator.isRevokedMsg()) {
            long msgId = locator.getRand();
            ImMessage msgData = ImDatabase.messageDao().getMessage(String.valueOf(msgId));
            String admId = null;
            if (msgData != null) {
                admId = msgData.getSubId();
            }
            ImDatabase.messageDao().deleteMsgById(String.valueOf(msgId));
            for (MessageRevokeHandler mHandler : this.mHandlers) {
                mHandler.onRevokedSuccess(admId);
            }
        }
    }

    public void addHandler(MessageRevokeHandler handler) {
        if (!this.mHandlers.contains(handler)) {
            this.mHandlers.add(handler);
        }
    }

    public void removeHandler(MessageRevokeHandler handler) {
        this.mHandlers.remove(handler);
    }

    public void cleanAll() {
        this.mHandlers.clear();
    }

    public static interface MessageRevokeHandler {
        public void onHandleInvoke(TIMMessageLocator var1);

        public void onRevokedSuccess(String var1);
    }
}

