/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.tx.parser.news.internet;

import android.text.TextUtils;
import com.kangxin.im.parsing.db.entity.HytData;
import com.kangxin.im.parsing.db.entity.ImMessage;
import com.kangxin.im.parsing.db.manager.ImDatabase;
import com.kangxin.im.parsing.tx.parser.news.entity.ImMessageEntity;
import com.kangxin.im.parsing.tx.types.BusinessCodeType;
import com.kangxin.im.parsing.tx.types.DirectionType;
import com.kangxin.im.parsing.tx.types.MessageType;
import com.kangxin.im.parsing.tx.types.ReadStatusType;
import com.kangxin.im.parsing.tx.types.SendStatusType;
import com.kangxin.im.parsing.utils.ImParsingKtxKt;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class InternetMessageParser {
    public static ImMessage parse(String currentUserId, ImMessageEntity bean) {
        ImMessage msg;
        block13: {
            msg = new ImMessage(bean.getMsgId(), currentUserId);
            String sender = bean.getSender();
            String groupId = bean.getGroupId();
            boolean isGroup = !TextUtils.isEmpty((CharSequence)groupId);
            msg.setSender(sender);
            msg.setReceiver(isGroup ? currentUserId : bean.getReceiver());
            msg.setConversionId(ImDatabase.checkConversation(bean.getSender(), msg.getReceiver()));
            msg.setSubId(bean.getAppointmentId());
            msg.setDate(ImParsingKtxKt.getDateToStamp(bean.getSendTime()));
            String msgType = bean.getMsgType();
            if (msgType.equals(BusinessCodeType.SYSTEM.getValue())) {
                String msgContent = bean.getMsgContent();
                try {
                    JSONObject object = (JSONObject)new JSONTokener(msgContent).nextValue();
                    int messageType = object.optInt("messageType");
                    String businessCode = object.optString("businessCode");
                    String applicationCode = object.optString("applicationCode");
                    msg.setApplicationCode(applicationCode);
                    if (messageType == 1) {
                        if (!TextUtils.equals((CharSequence)businessCode, (CharSequence)"time")) {
                            msg.setMessageType(MessageType.System);
                            JSONObject data = object.optJSONObject("data");
                            msg.setBody(data.optString("text"));
                        }
                        break block13;
                    }
                    msg.setMessageType(BusinessCodeType.findType(businessCode));
                    msg.setBody(object.optString("data"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                msg.setBody(bean.getMsgContent());
                String busCode = bean.getBusinessCode();
                if (!"zxzx".equals(busCode)) {
                    if (currentUserId.equals(bean.getSender())) {
                        msg.setDirection(DirectionType.Send);
                    } else {
                        msg.setDirection(DirectionType.Receive);
                    }
                } else if (sender.endsWith("EHOS_DOCTOR")) {
                    msg.setDirection(DirectionType.Send);
                    msg.setSendStatus(SendStatusType.Success);
                } else {
                    msg.setDirection(DirectionType.Receive);
                    msg.setReadStatus(ReadStatusType.None);
                }
                msg.setMessageType(MessageType.valueOf(bean.getMsgType()));
                if (busCode != null) {
                    msg.setApplicationCode(busCode);
                }
                msg.setUrl(bean.getFileUrl());
                HytData data = new HytData();
                data.setAppointmentId(bean.getAppointmentId());
                msg.setData(data);
            }
        }
        return msg;
    }
}

