/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.tx.parser.ordinary.internet;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.kangxin.im.parsing.db.entity.HytData;
import com.kangxin.im.parsing.db.entity.ImMessage;
import com.kangxin.im.parsing.db.manager.ImDatabase;
import com.kangxin.im.parsing.tx.parser.ordinary.entity.ImMessageEntity;
import com.kangxin.im.parsing.tx.types.BusinessCodeType;
import com.kangxin.im.parsing.tx.types.DirectionType;
import com.kangxin.im.parsing.tx.types.MessageType;
import com.kangxin.im.parsing.tx.types.ReadStatusType;
import com.kangxin.im.parsing.tx.types.SendStatusType;
import com.kangxin.im.parsing.utils.ImJsonParsingKt;
import com.kangxin.im.parsing.utils.ImParsingKtxKt;
import org.json.JSONObject;

public class InternetMessageParser {
    @Nullable
    public static ImMessage parse(String currentUserId, ImMessageEntity bean) {
        ImMessage imMessage = new ImMessage(bean.getMsgId(), currentUserId, ImDatabase.checkConversation(bean.getSender(), !TextUtils.isEmpty((CharSequence)bean.getGroupId()) ? currentUserId : bean.getReceiver()));
        imMessage.setReadStatus(ReadStatusType.Had);
        imMessage.setSendStatus(SendStatusType.Success);
        imMessage.setSender(bean.getSender());
        imMessage.setReceiver(!TextUtils.isEmpty((CharSequence)bean.getGroupId()) ? currentUserId : bean.getReceiver());
        imMessage.setSubId(bean.getAppointmentId());
        imMessage.setDate(ImParsingKtxKt.getDateToStamp(bean.getSendTime()));
        if (bean.getMsgType().equals(BusinessCodeType.SYSTEM.getValue())) {
            JSONObject json = ImJsonParsingKt.getJsonOrNull(bean.getMsgContent());
            if (json == null) {
                return null;
            }
            imMessage.setApplicationCode(json.optString("applicationCode"));
            if (json.optInt("messageType") == 1) {
                imMessage.setMessageType(MessageType.System);
                imMessage.setBody(json.optJSONObject("data").optString("text"));
            } else {
                imMessage.setMessageType(BusinessCodeType.findType(json.optString("businessCode")));
                imMessage.setBody(json.optString("data"));
            }
            return imMessage;
        }
        imMessage.setBody(bean.getMsgContent());
        imMessage.setMessageType(MessageType.valueOf(bean.getMsgType()));
        imMessage.setUrl(bean.getFileUrl());
        imMessage.safeSetApplicationCode(bean.getBusinessCode());
        HytData data = new HytData();
        data.setAppointmentId(bean.getAppointmentId());
        imMessage.setData(data);
        if (!"zxzx".equals(bean.getBusinessCode())) {
            imMessage.setDirection(currentUserId.equals(bean.getSender()) ? DirectionType.Send : DirectionType.Receive);
            return imMessage;
        }
        imMessage.setDirection(bean.getSender().endsWith("EHOS_DOCTOR") ? DirectionType.Send : DirectionType.Receive);
        return imMessage;
    }
}

