/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.im.parsing.tx.parser.ordinary.internet;

import com.kangxin.im.parsing.db.entity.ImMessage;
import com.kangxin.im.parsing.tx.types.BusinessCodeType;
import com.kangxin.im.parsing.tx.types.MessageType;
import com.kangxin.im.parsing.utils.ImJsonParsingKt;
import com.tencent.imsdk.TIMCustomElem;
import com.tencent.imsdk.TIMGroupSystemElem;
import com.tencent.imsdk.TIMTextElem;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/kangxin/im/parsing/tx/parser/ordinary/internet/TxImMessageParser;", "", "()V", "isVideoMessage", "", "elem", "Lcom/tencent/imsdk/TIMCustomElem;", "onUpdateGroupMessage", "message", "Lcom/kangxin/im/parsing/db/entity/ImMessage;", "Lcom/tencent/imsdk/TIMGroupSystemElem;", "onUpdateTextMessage", "", "imMessage", "Lcom/tencent/imsdk/TIMTextElem;", "module_im_parsing_release"})
public final class TxImMessageParser {
    public static final TxImMessageParser INSTANCE;

    @JvmStatic
    public static final boolean isVideoMessage(@NotNull TIMCustomElem elem) {
        Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
        byte[] byArray = elem.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"elem.data");
        JSONObject jSONObject = ImJsonParsingKt.getFromJsonObject(byArray);
        if (jSONObject == null) {
            return false;
        }
        JSONObject json = jSONObject;
        int cmd = json.optInt("UserAction");
        return cmd >= 129 && cmd < 200;
    }

    @JvmStatic
    public static final void onUpdateTextMessage(@NotNull ImMessage imMessage, @NotNull TIMTextElem elem) {
        Intrinsics.checkParameterIsNotNull((Object)imMessage, (String)"imMessage");
        Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
        imMessage.setBody(elem.getText());
    }

    @JvmStatic
    public static final boolean onUpdateGroupMessage(@NotNull ImMessage message, @NotNull TIMGroupSystemElem elem) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)elem, (String)"elem");
        byte[] byArray = elem.getUserData();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"elem.userData");
        JSONObject jSONObject = ImJsonParsingKt.getFromJsonObject(byArray);
        if (jSONObject == null) {
            return false;
        }
        JSONObject json = jSONObject;
        int messageType = json.optInt("messageType");
        message.setSubId(json.optString("admissionId"));
        String string2 = json.optString("applicationCode");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.optString(JsonKeys.applicationCode)");
        message.setApplicationCode(string2);
        switch (messageType) {
            case 1: {
                message.setMessageType(MessageType.System);
                message.setBody(json.optJSONObject("data").optString("text"));
                break;
            }
            case 2: {
                String string3 = json.optString("businessCode");
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"json.optString(JsonKeys.businessCode)");
                message.setMessageType(BusinessCodeType.Companion.findType(string3));
                message.setBody(json.optString("data"));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private TxImMessageParser() {
    }

    static {
        TxImMessageParser txImMessageParser;
        INSTANCE = txImMessageParser = new TxImMessageParser();
    }
}

