package com.byh.module.verlogin;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.kangxin.common.base.BaseWebViewActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.widget.ProgressWebView;
import com.kangxin.util.common.byh.WebViewUtils;

import org.jetbrains.annotations.NotNull;

/**
 * 用户协议和隐私政策页面
 */
@Route(path = VerloginRouter.LOGIN_ACTIVITY_AGREEMENT_NOTICE)
public class AgreementNoticeCountryActivity extends BaseWebViewActivity implements IToolView {

  private static final String TAG = "AgreementNoticeCountryA";
  private String loadUrl;
  private String title;

  private WebView webView;

  @Override
  public void onClickBack() {
    if (webView.canGoBack()) {
      webView.goBack();
    } else {
      finish();
    }
  }

  @Override
  public void start() {
    Bundle bundle = getIntent().getExtras();
    if (bundle != null) {
      loadUrl = bundle.getString("loadurl");
      title = bundle.getString("title");
      if (!TextUtils.isEmpty(title)) {
        vToolTitleTextView.setText(title);
        vToolTitleTextView.setMaxEms(9);
        vToolTitleTextView.setSingleLine(true);
        vToolTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
      }
    }

    webView = (ProgressWebView) findViewById(R.id.activity_webview_officialvi);
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
      webView.getSettings().setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);
    }
    WebViewUtils.setSettings(webView);
    webView.setWebViewClient(new WebViewClient() {
      @Override
      public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return false;
      }
    });

    Log.i(TAG, "start: loadurl:" + loadUrl);
    webView.loadUrl(loadUrl);
  }

  @Override
  public int getContentLayoutId() {
    return R.layout.verlogin_activity_official_site;
  }

  @NotNull
  @Override
  public View getVToolView() {
    return rootView.findViewById(R.id.vToolBar);
  }

  @Override
  public void finishCurrentView() {
    finish();
  }

  @Override
  public boolean initYm() {
    return false;
  }
}
