package com.byh.module.verlogin;

import static com.kangxin.common.byh.global.router.VerloginRouter.CHANGE_PHONE_SET;

import android.content.Intent;
import android.widget.ImageView;
import android.widget.TextView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.imageloader.Style;

@Route(path = CHANGE_PHONE_SET)
public class ChangePhoneActivity extends BaseActivity {

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_change_phone;
  }

  @Override
  public void start() {
    String mPhoneNum = getIntent().getStringExtra("phoneNum");

    ImageView vHeadShotImg = findViewById(R.id.iv_header);
    TextView tvPhone = findViewById(R.id.tv_phone);
    TextView tvTel = findViewById(R.id.tv_tel);

    findViewById(R.id.vLeftImage).setOnClickListener(v -> finish());

    Pretty.create().loadImage(VertifyDataUtil.getInstance().getHeaderIcon())
      .placeholder(R.drawable.ic_header_doc_img)
      .err(R.drawable.ic_header_doc_img)
      .diskCacheStrategy(DiskCacheStrategy.NONE)
      .bitmapTransform(Style.CIRCLE)
      .into(vHeadShotImg);

    String maskNumber = mPhoneNum.substring(0, 3) + "****" + mPhoneNum.substring(7, mPhoneNum.length());

    tvPhone.setText("当前手机号：" + maskNumber);
    tvTel.setText("通过"+maskNumber+"接收短信验证码");

    findViewById(R.id.layout_phone).setOnClickListener(v->{
      Intent intent = new Intent(ChangePhoneActivity.this,ChangePhoneByCodeActivity.class);
      intent.putExtra("phoneNum",mPhoneNum);
        startActivity(intent);
    });

    findViewById(R.id.layout_pwd).setOnClickListener(v->{
      startActivity(new Intent(ChangePhoneActivity.this,ChangePhoneByPwdActivity.class));
    });

  }

  @Override
  public boolean initYm() {
    return false;
  }
}
