package com.byh.module.verlogin;

import android.content.Intent;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;

import com.byh.module.verlogin.module.ChangePhoneViewModel;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;

public class ChangePhoneByCodeActivity extends BaseActivity {

  private TextView tv_code;
  private EditText ed_code;
  private Button tv_next;
  private CountDownTimer timer;
  private ChangePhoneViewModel viewModel;
  private String codeKey = "";

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_change_phone_code;
  }

  @Override
  public void start() {

    String mPhoneNum = getIntent().getStringExtra("phoneNum");
    String maskNumber = mPhoneNum.substring(0, 3) + "****" + mPhoneNum.substring(7, mPhoneNum.length());
    TextView tvP = findViewById(R.id.tv_p);
    tv_code = findViewById(R.id.tv_code);
    ed_code = findViewById(R.id.et_code);
    tv_next = findViewById(R.id.code_next);

    tvP.setText("通过+86 " + maskNumber + " 发送短信验证码");

    tv_next.setClickable(false);

    viewModel = new ViewModelProvider(this).get(ChangePhoneViewModel.class);

    //发送验证码
    tv_code.setOnClickListener(view -> {
      sendCode(mPhoneNum);
    });

    findViewById(R.id.vLeftImage).setOnClickListener(v->{
      cancelCountDownTimer();
      finish();
    });

    tv_next.setOnClickListener(v->{
      if(TextUtils.isEmpty(ed_code.getText().toString().trim()) || TextUtils.isEmpty(codeKey)){
        showShortToast("验证码错误,请重新获取");
        return;
      }
      checkCode();
    });

    ed_code.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
      @Override
      public void afterTextChanged(Editable editable) {
        if (editable.length() == 6) {
          tv_next.setClickable(true);
          tv_next.setEnabled(true);
          tv_next.setTextColor(getResources().getColor(R.color.white));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.vercode_order_bg, null));
        } else {
          tv_next.setClickable(false);
          tv_next.setEnabled(false);
          tv_next.setTextColor(getResources().getColor(R.color.color_999999));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.bt_gray_order_bg, null));
        }
      }
    });
  }

  private void sendCode(String mPhoneNum){
    viewModel.getCodeByPhone(mPhoneNum).observe(this, new Observer<String>() {
      @Override
      public void onChanged(String s) {
        codeKey = s;
        isVercodeUsable(false);
        starCountDownTimer();
      }
    });
  }

  private void checkCode(){
    viewModel.checkCode(ed_code.getText().toString().trim(),codeKey).observe(this,new Observer<ResponseBody>(){
      @Override
      public void onChanged(ResponseBody responseBody) {
        if(responseBody.getCode() == 200){
          showShortToast(responseBody.getMsg());
          startActivity(new Intent(ChangePhoneByCodeActivity.this,ChangePhoneNewNumActivity.class));
        }else{
          if(responseBody.getMsg().contains("已失效")){
            showShortToast(responseBody.getMsg());
          }else{
            showShortToast("验证码错误，请重新获取");
          }
          codeKey = "";
          isVercodeUsable(true);
          cancelCountDownTimer();
        }
      }
    });
  }

  private void isVercodeUsable(boolean isUse) {
    if (isUse) {
      tv_code.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.vercode_order_bg, null));
      tv_code.setTextColor(getResources().getColor(android.R.color.white));
      tv_code.setClickable(true);
      tv_code.setFocusable(true);
      tv_code.setText(R.string.ver_getvercode);
    } else {
      tv_code.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.white_corner_bg, null));
      tv_code.setTextColor(getResources().getColor(android.R.color.darker_gray));
      tv_code.setText(R.string.ver_getvercode);
      tv_code.setClickable(false);
      tv_code.setFocusable(false);
    }
  }

  private void cancelCountDownTimer() {
    if (timer != null) {
      timer.cancel();
    }
    timer = null;
  }

  private void starCountDownTimer() {
    if (timer == null) {
      timer = new CountDownTimer(60000, 1000) {
        @Override
        public void onTick(long millisUntilFinished) {
          tv_code.setText(millisUntilFinished/1000+"s");
        }

        @Override
        public void onFinish() {
          isVercodeUsable(true);
          cancelCountDownTimer();
        }
      };
      timer.start();
    }
  }

  @Override
  public boolean initYm() {
    return false;
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    cancelCountDownTimer();
  }
}
