package com.byh.module.verlogin;

import android.content.Intent;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.present.ForgetSendVerifyCodePersent;
import com.byh.module.verlogin.present.ValidatePhoneAndCodePresent;
import com.byh.module.verlogin.present.inter.IValidatePhoneCodePresent;
import com.byh.module.verlogin.view.IForgetSendVercodeView;
import com.byh.module.verlogin.view.IValidatePhoneAndCodeView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.rmvp.BaseActivity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.util.common.EditTextPlusUtil;
import com.kangxin.util.common.VerifyUtil;

@Route(path = VerloginRouter.FORGRT_PWD_PAGE)
public class ForgetPassWordActivity extends BaseActivity implements IForgetSendVercodeView, IValidatePhoneAndCodeView {
  private static final String TAG = "ForgetPassWordActivity";
  private EditText mRealNameEdit;
  private TextView mVercodeTv;
  private EditText mVercodeEdit;
  private TextView mErrNoticeTv;

  private CountDownUtil mCountDownUtil;
  private ForgetSendVerifyCodePersent mForgetSendVerifyCodePersent;
  private String mPhoneNum;
  private String mPhoneNumEdit;
  private IValidatePhoneCodePresent mValidatePhoneCodePresent;

  @Override
  public void goStart() {
    mForgetSendVerifyCodePersent = new ForgetSendVerifyCodePersent(this);
    mValidatePhoneCodePresent = new ValidatePhoneAndCodePresent(this);
    mPhoneNum = getIntent().getStringExtra("phoneNum");
    initViews();
  }


  private void initViews() {
    mRealNameEdit = findViewById(R.id.et_real_name);
    mVercodeTv = findViewById(R.id.tv_vercode);
    mVercodeEdit = findViewById(R.id.edt_vercode);
    mErrNoticeTv = findViewById(R.id.err_notice);

    mCountDownUtil = new CountDownUtil(mVercodeTv)
      .setCountDownMillis(60_000L)
      .setCountDownColor(R.color.white, android.R.color.darker_gray);//倒计时60000ms

    isVercodeUsable(false);

    String maskNumber = mPhoneNum.substring(0, 3) + "****" + mPhoneNum.substring(7, mPhoneNum.length());
    mRealNameEdit.setText(maskNumber);
    if (VerifyUtil.isMobilePhoneNumber(mPhoneNum)) {
      isVercodeUsable(true);
    } else {
      isVercodeUsable(false);
    }

    mCountDownUtil.setOnDownEndListener(() -> {
      String phoneNum;
      if (TextUtils.isEmpty(mPhoneNum)) {
        phoneNum = mRealNameEdit.getText().toString().trim();
      } else {
        phoneNum = mPhoneNum;
      }

      if (!TextUtils.isEmpty(phoneNum)) {
        isVercodeUsable(true);
      } else {
        isVercodeUsable(false);
      }
    });

    mVercodeTv.setOnClickListener(view -> {
      String phoneNum;
      if (TextUtils.isEmpty(mPhoneNum)) {
        phoneNum = mRealNameEdit.getText().toString().trim();
      } else {
        phoneNum = mPhoneNum;
      }

      if (!TextUtils.isEmpty(phoneNum)) {
        isVercodeUsable(true);
      } else {
        isVercodeUsable(false);
      }

      //发送短信验证
      mForgetSendVerifyCodePersent.receiveByVercode(phoneNum);
      mCountDownUtil.start();
      isVercodeUsable(false);
    });

    addEdtChangeListener();
  }

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_forget_pass_word;
  }

  /**
   * 点击提交
   *
   * @param view
   */
  public void onButterKnifeBtnClick(View view) {

    if (TextUtils.isEmpty(mPhoneNum)) {
      mPhoneNumEdit = mRealNameEdit.getText().toString().trim();
    } else {
      mPhoneNumEdit = mPhoneNum;
    }

    String verCode = mVercodeEdit.getText().toString().trim();

    if (TextUtils.isEmpty(mAuthKey)) {
      ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_qingxianfasongyanzhengma));
      return;
    }

    if (TextUtils.isEmpty(mPhoneNumEdit)) {
      mErrNoticeTv.setVisibility(View.VISIBLE);
      mErrNoticeTv.setText(StringsUtils.getString(R.string.verlogin_shoujihaobunengweikong));
      return;
    } else if (!VerifyUtil.isMobilePhoneNumber(mPhoneNumEdit)) {
      mErrNoticeTv.setVisibility(View.VISIBLE);
      mErrNoticeTv.setText(getResources().getString(R.string.forget_phone_error_tips));
      return;
    } else if (TextUtils.isEmpty(verCode)) {
      mErrNoticeTv.setVisibility(View.VISIBLE);
      mErrNoticeTv.setText(StringsUtils.getString(R.string.verlogin_yanzhengmabunengweikong));
      return;
    } else {

      mValidatePhoneCodePresent.getValidatePhoneCodePresenter(verCode, mAuthKey, true);
    }
  }

  public void onBackImageOnClick(View view) {
    finish();
  }

  private void addEdtChangeListener() {

    EditTextPlusUtil.rightAlign(mRealNameEdit, new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence s, int start, int count, int after) {

      }

      @Override
      public void onTextChanged(CharSequence s, int start, int before, int count) {

      }

      @Override
      public void afterTextChanged(Editable s) {
        mErrNoticeTv.setVisibility(View.GONE);

        if (VerifyUtil.isMobilePhoneNumber(mPhoneNum)) {
          isVercodeUsable(true);
        } else {
          isVercodeUsable(false);
        }
      }
    });

    mVercodeEdit.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
      }

      @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
      @Override
      public void afterTextChanged(Editable editable) {
        mErrNoticeTv.setVisibility(View.GONE);
      }
    });
  }

  private void isVercodeUsable(boolean isUse) {
    if (isUse) {
      mCountDownUtil.setUsable(true);
      mVercodeTv.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.vercode_order_bg, null));
      mVercodeTv.setTextColor(getResources().getColor(android.R.color.white));
      mVercodeTv.setClickable(true);
      mVercodeTv.setFocusable(true);
      mVercodeTv.setText(R.string.forget_send_getvercode);
    } else {
      mCountDownUtil.setUsable(false);
      mVercodeTv.setBackground(ResourcesCompat.getDrawable(getResources(), R.drawable.edt_order_bg, null));
      mVercodeTv.setTextColor(getResources().getColor(android.R.color.darker_gray));
      mVercodeTv.setText(R.string.forget_send_getvercode);
      mVercodeTv.setClickable(false);
      mVercodeTv.setFocusable(false);
    }
  }
  
  private String mAuthKey;

  @Override
  public void receiveResult(LoginSuccess responseBody) {
    if (responseBody == null) {
      return;
    }

    mAuthKey = responseBody.getAuthKey();
  }

  @Override
  public void getValidatePhoneAndCodeOk(ResponseBody responseBody) {
    showShortToast(responseBody.getMsg());
    Intent intent = new Intent(this, ResetPasswordActivity.class);
    intent.putExtra("phoneNum", mPhoneNumEdit);
    startActivity(intent);
  }
}
